/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.initializer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.writer.DataWriterBuilder;
import org.apache.gobblin.writer.initializer.MultiWriterInitializer;
import org.apache.gobblin.writer.initializer.WriterInitializer;

public class WriterInitializerFactory {
    public static WriterInitializer newInstace(State state, WorkUnitStream workUnits) {
        int branches = state.getPropAsInt("fork.branches", 1);
        if (branches == 1) {
            return WriterInitializerFactory.newSingleInstance(state, workUnits, branches, 0);
        }
        ArrayList wis = Lists.newArrayList();
        for (int branchId = 0; branchId < branches; ++branchId) {
            wis.add(WriterInitializerFactory.newSingleInstance(state, workUnits, branches, branchId));
        }
        return new MultiWriterInitializer(wis);
    }

    private static WriterInitializer newSingleInstance(State state, WorkUnitStream workUnits, int branches, int branchId) {
        DataWriterBuilder dataWriterBuilder;
        Preconditions.checkNotNull((Object)state);
        String writerBuilderKey = ForkOperatorUtils.getPropertyNameForBranch((String)"writer.builder.class", (int)branches, (int)branchId);
        String writerBuilderClass = state.getProp(writerBuilderKey, "org.apache.gobblin.writer.AvroDataWriterBuilder");
        try {
            dataWriterBuilder = (DataWriterBuilder)Class.forName(writerBuilderClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return dataWriterBuilder.getInitializer(state, workUnits, branches, branchId);
    }
}

