/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.http;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.writer.http.HttpWriterDecoration;
import org.apache.gobblin.writer.http.UnexpectedResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class HttpWriterDecorator<D>
implements HttpWriterDecoration<D> {
    private final HttpWriterDecoration<D> fallback;

    public HttpWriterDecorator(HttpWriterDecoration<D> fallback) {
        Preconditions.checkNotNull(fallback);
        this.fallback = fallback;
    }

    protected HttpWriterDecoration<D> getFallback() {
        return this.fallback;
    }

    @Override
    public URI chooseServerHost() {
        return this.getFallback().chooseServerHost();
    }

    @Override
    public void onConnect(URI serverHost) throws IOException {
        this.getFallback().onConnect(serverHost);
    }

    @Override
    public Optional<HttpUriRequest> onNewRecord(D record) {
        return this.getFallback().onNewRecord(record);
    }

    @Override
    public ListenableFuture<CloseableHttpResponse> sendRequest(HttpUriRequest request) throws IOException {
        return this.getFallback().sendRequest(request);
    }

    @Override
    public CloseableHttpResponse waitForResponse(ListenableFuture<CloseableHttpResponse> responseFuture) {
        return this.getFallback().waitForResponse(responseFuture);
    }

    @Override
    public void processResponse(CloseableHttpResponse response) throws IOException, UnexpectedResponseException {
        this.getFallback().processResponse(response);
    }
}

