/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.http;

import com.google.common.base.Optional;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.gobblin.writer.http.AbstractHttpWriter;
import org.apache.gobblin.writer.http.AbstractHttpWriterBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class HttpWriter<D>
extends AbstractHttpWriter<D> {
    public HttpWriter(AbstractHttpWriterBuilder builder) {
        super(builder);
    }

    @Override
    public URI chooseServerHost() {
        return this.getCurServerHost();
    }

    @Override
    public void onConnect(URI serverHost) throws IOException {
    }

    @Override
    public Optional<HttpUriRequest> onNewRecord(D record) {
        try {
            HttpUriRequest uriRequest = RequestBuilder.post().addHeader("Content-Type", ContentType.TEXT_PLAIN.getMimeType()).setUri(this.getCurServerHost()).setEntity((HttpEntity)new StringEntity(record.toString(), ContentType.TEXT_PLAIN.toString())).build();
            return Optional.of((Object)uriRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    URI combineUrl(URI uri, Optional<String> resourcePath) {
        if (!resourcePath.isPresent()) {
            return uri;
        }
        try {
            return new URL(this.getCurServerHost().toURL(), (String)resourcePath.get()).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Failed combining URL", e);
        }
    }
}

