/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source;

import java.io.IOException;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;

public interface PartitionAwareFileRetriever {
    public void init(SourceState var1);

    public long getWatermarkFromString(String var1);

    public long getWatermarkIncrementMs();

    public List<FileInfo> getFilesToProcess(long var1, int var3) throws IOException;

    public static class FileInfo
    implements Comparable<FileInfo> {
        private final String filePath;
        private final long fileSize;
        private final long watermarkMsSinceEpoch;

        public FileInfo(String filePath, long fileSize, long watermarkMsSinceEpoch) {
            this.fileSize = fileSize;
            this.filePath = filePath;
            this.watermarkMsSinceEpoch = watermarkMsSinceEpoch;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public long getWatermarkMsSinceEpoch() {
            return this.watermarkMsSinceEpoch;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public String toString() {
            return "FileInfo{filePath='" + this.filePath + '\'' + ", watermarkMsSinceEpoch=" + this.watermarkMsSinceEpoch + '}';
        }

        @Override
        public int compareTo(FileInfo o) {
            if (this.watermarkMsSinceEpoch < o.watermarkMsSinceEpoch) {
                return -1;
            }
            if (this.watermarkMsSinceEpoch > o.watermarkMsSinceEpoch) {
                return 1;
            }
            return this.filePath.compareTo(o.filePath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            if (this.watermarkMsSinceEpoch != fileInfo.watermarkMsSinceEpoch) {
                return false;
            }
            return this.filePath != null ? this.filePath.equals(fileInfo.filePath) : fileInfo.filePath == null;
        }

        public int hashCode() {
            int result = this.filePath != null ? this.filePath.hashCode() : 0;
            result = 31 * result + (int)(this.watermarkMsSinceEpoch ^ this.watermarkMsSinceEpoch >>> 32);
            return result;
        }
    }
}

