/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.Compressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class GzipCompressor
implements Compressor {
    private static final String HTTP_NAME = "gzip";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] inflate(InputStream data) throws CompressionException {
        ByteArrayOutputStream out;
        GZIPInputStream gzip = null;
        try {
            out = new ByteArrayOutputStream();
            gzip = new GZIPInputStream(data);
            IOUtils.copy((InputStream)gzip, (OutputStream)out);
            if (gzip == null) return out.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
            }
            catch (Throwable throwable) {
                if (gzip == null) throw throwable;
                IOUtils.closeQuietly(gzip);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)gzip);
        return out.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] deflate(InputStream data) throws CompressionException {
        ByteArrayOutputStream out;
        GZIPOutputStream gzip = null;
        try {
            out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            IOUtils.copy((InputStream)data, (OutputStream)gzip);
            if (gzip == null) return out.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
            }
            catch (Throwable throwable) {
                if (gzip == null) throw throwable;
                IOUtils.closeQuietly(gzip);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)gzip);
        return out.toByteArray();
    }

    @Override
    public String getContentEncodingName() {
        return HTTP_NAME;
    }
}

