/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.SimpleCallback;
import com.linkedin.common.util.None;
import com.linkedin.r2.SizeLimitExceededException;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolStats;
import com.linkedin.r2.transport.http.client.AsyncPoolStatsTracker;
import com.linkedin.r2.transport.http.client.NoopRateLimiter;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.util.Cancellable;
import com.linkedin.r2.util.LinkedDeque;
import com.linkedin.util.ArgumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPoolImpl<T>
implements AsyncPool<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncPoolImpl.class);
    private final String _poolName;
    private final AsyncPool.Lifecycle<T> _lifecycle;
    private final int _maxSize;
    private final int _maxWaiters;
    private final long _idleTimeout;
    private final ScheduledExecutorService _timeoutExecutor;
    private final int _minSize;
    private volatile ScheduledFuture<?> _objectTimeoutFuture;
    private final RateLimiter _rateLimiter;
    private final Strategy _strategy;
    private final Object _lock = new Object();
    private int _poolSize = 0;
    private int _checkedOut = 0;
    private final Deque<TimedObject<T>> _idle = new LinkedList<TimedObject<T>>();
    private final LinkedDeque<Callback<T>> _waiters = new LinkedDeque();
    private Throwable _lastCreateError = null;
    private State _state = State.NOT_YET_STARTED;
    private Callback<None> _shutdownCallback = null;
    private final AsyncPoolStatsTracker _statsTracker;

    public AsyncPoolImpl(String name, AsyncPool.Lifecycle<T> lifecycle, int maxSize, long idleTimeout, ScheduledExecutorService timeoutExecutor) {
        this(name, lifecycle, maxSize, idleTimeout, timeoutExecutor, timeoutExecutor, Integer.MAX_VALUE);
    }

    public AsyncPoolImpl(String name, AsyncPool.Lifecycle<T> lifecycle, int maxSize, long idleTimeout, ScheduledExecutorService timeoutExecutor, ExecutorService callbackExecutor, int maxWaiters) {
        this(name, lifecycle, maxSize, idleTimeout, timeoutExecutor, callbackExecutor, maxWaiters, Strategy.MRU, 0);
    }

    public AsyncPoolImpl(String name, AsyncPool.Lifecycle<T> lifecycle, int maxSize, long idleTimeout, ScheduledExecutorService timeoutExecutor, ExecutorService callbackExecutor, int maxWaiters, Strategy strategy, int minSize) {
        this(name, lifecycle, maxSize, idleTimeout, timeoutExecutor, maxWaiters, strategy, minSize, new NoopRateLimiter());
    }

    public AsyncPoolImpl(String name, AsyncPool.Lifecycle<T> lifecycle, int maxSize, long idleTimeout, ScheduledExecutorService timeoutExecutor, int maxWaiters, Strategy strategy, int minSize, RateLimiter rateLimiter) {
        ArgumentUtil.notNull(lifecycle, (String)"lifecycle");
        ArgumentUtil.notNull((Object)timeoutExecutor, (String)"timeoutExecutor");
        ArgumentUtil.notNull((Object)((Object)strategy), (String)"strategy");
        ArgumentUtil.notNull((Object)rateLimiter, (String)"rateLimiter");
        this._poolName = name;
        this._lifecycle = lifecycle;
        this._maxSize = maxSize;
        this._idleTimeout = idleTimeout;
        this._timeoutExecutor = timeoutExecutor;
        this._maxWaiters = maxWaiters;
        this._strategy = strategy;
        this._minSize = minSize;
        this._rateLimiter = rateLimiter;
        this._statsTracker = new AsyncPoolStatsTracker(() -> this._lifecycle.getStats(), () -> this._maxSize, () -> this._minSize, () -> {
            Object object = this._lock;
            synchronized (object) {
                return this._poolSize;
            }
        }, () -> {
            Object object = this._lock;
            synchronized (object) {
                return this._checkedOut;
            }
        }, () -> {
            Object object = this._lock;
            synchronized (object) {
                return this._idle.size();
            }
        });
    }

    @Override
    public String getName() {
        return this._poolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != State.NOT_YET_STARTED) {
                throw new IllegalStateException(this._poolName + " is " + (Object)((Object)this._state));
            }
            this._state = State.RUNNING;
            if (this._idleTimeout > 0L) {
                long freq = Math.min(this._idleTimeout / 10L, 1000L);
                this._objectTimeoutFuture = this._timeoutExecutor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        AsyncPoolImpl.this.timeoutObjects();
                    }
                }, freq, freq, TimeUnit.MILLISECONDS);
            }
        }
        for (int i = 0; i < this._minSize; ++i) {
            if (!this.shouldCreate()) continue;
            this.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(Callback<None> callback) {
        State state;
        Object object = this._lock;
        synchronized (object) {
            state = this._state;
            if (state == State.RUNNING) {
                this._state = State.SHUTTING_DOWN;
                this._shutdownCallback = callback;
            }
        }
        if (state != State.RUNNING) {
            callback.onError((Throwable)new IllegalStateException(this._poolName + " is " + (Object)((Object)this._state)));
            return;
        }
        LOG.info("{}: {}", (Object)this._poolName, (Object)"shutdown requested");
        this.shutdownIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Callback<T>> cancelWaiters() {
        Object object = this._lock;
        synchronized (object) {
            Callback item;
            ArrayList<Callback<T>> cancelled = new ArrayList<Callback<T>>(this._waiters.size());
            while ((item = (Callback)this._waiters.poll()) != null) {
                cancelled.add(item);
            }
            return cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable get(Callback<T> callback) {
        LinkedDeque.Node<TimeTrackingCallback<T>> node;
        boolean create = false;
        boolean reject = false;
        TimeTrackingCallback<T> callbackWithTracking = new TimeTrackingCallback<T>(callback);
        while (true) {
            State state;
            TimedObject<T> obj = null;
            Object object = this._lock;
            synchronized (object) {
                state = this._state;
                if (state == State.RUNNING && (obj = this._strategy == Strategy.LRU ? this._idle.pollFirst() : this._idle.pollLast()) == null) {
                    if (this._waiters.size() < this._maxWaiters) {
                        node = this._waiters.addLastNode(callbackWithTracking);
                        create = this.shouldCreate();
                    } else {
                        reject = true;
                        node = null;
                    }
                    break;
                }
            }
            if (state != State.RUNNING) {
                callbackWithTracking.onError(new IllegalStateException(this._poolName + " is " + (Object)((Object)this._state)));
                return () -> false;
            }
            Object rawObj = obj.get();
            if (this._lifecycle.validateGet(rawObj)) {
                this.trc("dequeued an idle object");
                Object object2 = this._lock;
                synchronized (object2) {
                    ++this._checkedOut;
                    this._statsTracker.sampleMaxCheckedOut();
                }
                callbackWithTracking.onSuccess(rawObj);
                return () -> false;
            }
            this.destroy(rawObj, true);
            this.trc("dequeued and disposed an invalid idle object");
        }
        if (reject) {
            callbackWithTracking.onError(new SizeLimitExceededException("AsyncPool " + this._poolName + " reached maximum waiter size: " + this._maxWaiters));
            return null;
        }
        this.trc("enqueued a waiter");
        if (create) {
            this.create();
        }
        return new Cancellable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel() {
                Object object = AsyncPoolImpl.this._lock;
                synchronized (object) {
                    return AsyncPoolImpl.this._waiters.removeNode(node) != null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T obj) {
        Object object = this._lock;
        synchronized (object) {
            --this._checkedOut;
        }
        if (!this._lifecycle.validatePut(obj)) {
            this.destroy(obj, true);
            return;
        }
        this._rateLimiter.setPeriod(0L);
        this.add(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(T obj) {
        Callback<None> shutdown;
        Callback waiter;
        Object object = this._lock;
        synchronized (object) {
            waiter = (Callback)this._waiters.poll();
            if (waiter == null) {
                this._idle.offerLast(new TimedObject<T>(obj));
            } else {
                ++this._checkedOut;
                this._statsTracker.sampleMaxCheckedOut();
            }
            shutdown = this.checkShutdownComplete();
        }
        if (waiter != null) {
            this.trc("dequeued a waiter");
            waiter.onSuccess(obj);
        } else {
            this.trc("enqueued an idle object");
        }
        if (shutdown != null) {
            this.finishShutdown(shutdown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(T obj) {
        Object object = this._lock;
        synchronized (object) {
            --this._checkedOut;
        }
        this.destroy(obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncPoolStats getStats() {
        Object object = this._lock;
        synchronized (object) {
            return this._statsTracker.getStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(T obj, boolean bad) {
        if (bad) {
            Object object = this._lock;
            synchronized (object) {
                this._statsTracker.incrementBadDestroyed();
            }
        }
        this.trc("disposing a pooled object");
        this._lifecycle.destroy(obj, bad, new Callback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(T t) {
                boolean create;
                Object object = AsyncPoolImpl.this._lock;
                synchronized (object) {
                    AsyncPoolImpl.this._statsTracker.incrementDestroyed();
                    create = AsyncPoolImpl.this.objectDestroyed();
                }
                if (create) {
                    AsyncPoolImpl.this.create();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable e) {
                boolean create;
                Object object = AsyncPoolImpl.this._lock;
                synchronized (object) {
                    AsyncPoolImpl.this._statsTracker.incrementDestroyErrors();
                    create = AsyncPoolImpl.this.objectDestroyed();
                }
                if (create) {
                    AsyncPoolImpl.this.create();
                }
            }
        });
    }

    private boolean objectDestroyed() {
        return this.objectDestroyed(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean objectDestroyed(int num) {
        boolean create;
        Object object = this._lock;
        synchronized (object) {
            this._poolSize = this._poolSize - num > 0 ? (this._poolSize -= num) : 0;
            create = this.shouldCreate();
            this.shutdownIfNeeded();
        }
        return create;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldCreate() {
        boolean result = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._state == State.RUNNING) {
                if (this._poolSize >= this._maxSize) {
                    this._lastCreateError = null;
                } else if (this._waiters.size() > 0 || this._poolSize < this._minSize) {
                    ++this._poolSize;
                    this._statsTracker.sampleMaxPoolSize();
                    result = true;
                }
            }
        }
        return result;
    }

    private void create() {
        this.trc("initiating object creation");
        this._rateLimiter.submit(new RateLimiter.Task(){

            @Override
            public void run(final SimpleCallback callback) {
                AsyncPoolImpl.this._lifecycle.create(new Callback<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(T t) {
                        Object object = AsyncPoolImpl.this._lock;
                        synchronized (object) {
                            AsyncPoolImpl.this._statsTracker.incrementCreated();
                            AsyncPoolImpl.this._lastCreateError = null;
                        }
                        AsyncPoolImpl.this.add(t);
                        callback.onDone();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onError(Throwable e) {
                        Collection<Object> waitersDenied;
                        boolean create;
                        AsyncPoolImpl.this._rateLimiter.incrementPeriod();
                        Collection<RateLimiter.Task> cancelledCreate = AsyncPoolImpl.this._rateLimiter.cancelPendingTasks();
                        Iterator<Object> iterator = AsyncPoolImpl.this._lock;
                        synchronized (iterator) {
                            AsyncPoolImpl.this._statsTracker.incrementCreateErrors();
                            AsyncPoolImpl.this._lastCreateError = e;
                            create = AsyncPoolImpl.this.objectDestroyed(1 + cancelledCreate.size());
                            waitersDenied = !AsyncPoolImpl.this._waiters.isEmpty() ? AsyncPoolImpl.this.cancelWaiters() : Collections.emptyList();
                        }
                        for (Callback callback2 : waitersDenied) {
                            try {
                                callback2.onError(e);
                            }
                            catch (Exception ex) {
                                LOG.error("Encountered error while invoking error waiter callback", (Throwable)ex);
                            }
                        }
                        if (create) {
                            AsyncPoolImpl.this.create();
                        }
                        LOG.error(AsyncPoolImpl.this._poolName + ": object creation failed", e);
                        callback.onDone();
                    }
                });
            }
        });
    }

    private void timeoutObjects() {
        Collection idle = this.reap(this._idle, this._idleTimeout);
        if (idle.size() > 0) {
            LOG.debug("{}: disposing {} objects due to idle timeout", (Object)this._poolName, (Object)idle.size());
            for (Object obj : idle) {
                this.destroy(obj, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> Collection<U> reap(Queue<TimedObject<U>> queue, long timeout) {
        ArrayList<U> toReap = new ArrayList<U>();
        long now = System.currentTimeMillis();
        long target = now - timeout;
        Object object = this._lock;
        synchronized (object) {
            TimedObject<U> p;
            for (int excess = this._poolSize - this._minSize; (p = queue.peek()) != null && p.getTime() < target && excess > 0; --excess) {
                toReap.add(queue.poll().get());
                this._statsTracker.incrementTimedOut();
            }
        }
        return toReap;
    }

    private void shutdownIfNeeded() {
        Callback<None> shutdown = this.checkShutdownComplete();
        if (shutdown != null) {
            this.finishShutdown(shutdown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callback<None> checkShutdownComplete() {
        int poolSize;
        int idle;
        int waiters;
        State state;
        Callback<None> done = null;
        Object object = this._lock;
        synchronized (object) {
            state = this._state;
            waiters = this._waiters.size();
            idle = this._idle.size();
            poolSize = this._poolSize;
            if (state == State.SHUTTING_DOWN && waiters == 0 && idle == poolSize) {
                this._state = State.STOPPED;
                done = this._shutdownCallback;
                this._shutdownCallback = null;
            }
        }
        if (state == State.SHUTTING_DOWN && done == null) {
            LOG.info("{}: {} waiters and {} objects outstanding before shutdown", new Object[]{this._poolName, waiters, poolSize - idle});
        }
        return done;
    }

    private void finishShutdown(Callback<None> shutdown) {
        ScheduledFuture<?> future = this._objectTimeoutFuture;
        if (future != null) {
            future.cancel(false);
        }
        LOG.info("{}: {}", (Object)this._poolName, (Object)"shutdown complete");
        shutdown.onSuccess((Object)None.none());
    }

    private void trc(Object toLog) {
        LOG.trace("{}: {}", (Object)this._poolName, toLog);
    }

    private class TimeTrackingCallback<T>
    implements Callback<T> {
        private final long _startTime;
        private final Callback<T> _callback;

        public TimeTrackingCallback(Callback<T> callback) {
            this._callback = callback;
            this._startTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable e) {
            Object object = AsyncPoolImpl.this._lock;
            synchronized (object) {
                AsyncPoolImpl.this._statsTracker.trackWaitTime(System.currentTimeMillis() - this._startTime);
            }
            this._callback.onError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(T result) {
            Object object = AsyncPoolImpl.this._lock;
            synchronized (object) {
                AsyncPoolImpl.this._statsTracker.trackWaitTime(System.currentTimeMillis() - this._startTime);
            }
            this._callback.onSuccess(result);
        }
    }

    private static class TimedObject<T> {
        private final T _obj;
        private final long _time;

        public TimedObject(T obj) {
            this._obj = obj;
            this._time = System.currentTimeMillis();
        }

        public T get() {
            return this._obj;
        }

        public long getTime() {
            return this._time;
        }
    }

    public static enum Strategy {
        MRU,
        LRU;

    }

    private static enum State {
        NOT_YET_STARTED,
        RUNNING,
        SHUTTING_DOWN,
        STOPPED;

    }
}

