/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.stream;

import com.linkedin.r2.message.BaseResponse;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.util.ArgumentUtil;
import java.util.List;
import java.util.Map;

final class StreamResponseImpl
extends BaseResponse
implements StreamResponse {
    private final EntityStream _entityStream;

    StreamResponseImpl(EntityStream entityStream, Map<String, String> headers, List<String> cookies, int status) {
        super(headers, cookies, status);
        ArgumentUtil.notNull((Object)entityStream, (String)"entityStream");
        this._entityStream = entityStream;
    }

    @Override
    public StreamResponseBuilder builder() {
        return new StreamResponseBuilder(this);
    }

    @Override
    public EntityStream getEntityStream() {
        return this._entityStream;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamResponseImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StreamResponseImpl that = (StreamResponseImpl)o;
        return this._entityStream == that._entityStream;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._entityStream.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StreamResponse[headers=").append(this.getHeaders()).append("cookies=").append(this.getCookies()).append(",status=").append(this.getStatus()).append("]");
        return builder.toString();
    }
}

