/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller;

import java.util.Arrays;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.manager.zk.HelixManagerShutdownHook;
import org.apache.helix.participant.DistClusterControllerStateModelFactory;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.log4j.Logger;

public class HelixControllerMain {
    public static final String zkServerAddress = "zkSvr";
    public static final String cluster = "cluster";
    public static final String help = "help";
    public static final String mode = "mode";
    public static final String name = "controllerName";
    public static final String STANDALONE = "STANDALONE";
    public static final String DISTRIBUTED = "DISTRIBUTED";
    private static final Logger logger = Logger.getLogger(HelixControllerMain.class);

    private static synchronized Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)zkServerAddress);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)cluster);
        OptionBuilder.withDescription((String)"Provide cluster name");
        Option clusterOption = OptionBuilder.create();
        clusterOption.setArgs(1);
        clusterOption.setRequired(true);
        clusterOption.setArgName("Cluster name (Required)");
        OptionBuilder.withLongOpt((String)mode);
        OptionBuilder.withDescription((String)"Provide cluster controller mode (Optional): STANDALONE (default) or DISTRIBUTED");
        Option modeOption = OptionBuilder.create();
        modeOption.setArgs(1);
        modeOption.setRequired(false);
        modeOption.setArgName("Cluster controller mode (Optional)");
        OptionBuilder.withLongOpt((String)name);
        OptionBuilder.withDescription((String)"Provide cluster controller name (Optional)");
        Option controllerNameOption = OptionBuilder.create();
        controllerNameOption.setArgs(1);
        controllerNameOption.setRequired(false);
        controllerNameOption.setArgName("Cluster controller name (Optional)");
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(zkServerOption);
        options.addOption(clusterOption);
        options.addOption(modeOption);
        options.addOption(controllerNameOption);
        return options;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + HelixControllerMain.class.getName(), cliOptions);
    }

    public static CommandLine processCommandLineArgs(String[] cliArgs) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = HelixControllerMain.constructCommandLineOptions();
        try {
            return cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            logger.error((Object)("fail to parse command-line options. cliArgs: " + Arrays.toString(cliArgs)), (Throwable)pe);
            HelixControllerMain.printUsage(cliOptions);
            System.exit(1);
            return null;
        }
    }

    public static void addListenersToController(HelixManager manager, GenericHelixController controller) {
        try {
            manager.addConfigChangeListener(controller);
            manager.addLiveInstanceChangeListener(controller);
            manager.addIdealStateChangeListener(controller);
            manager.addControllerListener(controller);
        }
        catch (ZkInterruptedException e) {
            logger.warn((Object)("zk connection is interrupted during HelixManagerMain.addListenersToController(). " + (Object)((Object)e)));
        }
        catch (Exception e) {
            logger.error((Object)"Error when creating HelixManagerContollerMonitor", (Throwable)e);
        }
    }

    public static HelixManager startHelixController(String zkConnectString, String clusterName, String controllerName, String controllerMode) {
        HelixManager manager = null;
        try {
            if (controllerMode.equalsIgnoreCase(STANDALONE)) {
                manager = HelixManagerFactory.getZKHelixManager(clusterName, controllerName, InstanceType.CONTROLLER, zkConnectString);
                manager.connect();
            } else if (controllerMode.equalsIgnoreCase(DISTRIBUTED)) {
                manager = HelixManagerFactory.getZKHelixManager(clusterName, controllerName, InstanceType.CONTROLLER_PARTICIPANT, zkConnectString);
                DistClusterControllerStateModelFactory stateModelFactory = new DistClusterControllerStateModelFactory(zkConnectString);
                StateMachineEngine stateMach = manager.getStateMachineEngine();
                stateMach.registerStateModelFactory("LeaderStandby", stateModelFactory);
                manager.connect();
            } else {
                logger.error((Object)("cluster controller mode:" + controllerMode + " NOT supported"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception while starting controller", (Throwable)e);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CommandLine cmd = HelixControllerMain.processCommandLineArgs(args);
        String zkConnectString = cmd.getOptionValue(zkServerAddress);
        String clusterName = cmd.getOptionValue(cluster);
        String controllerMode = STANDALONE;
        String controllerName = null;
        if (cmd.hasOption(mode)) {
            controllerMode = cmd.getOptionValue(mode);
        }
        if (controllerMode.equalsIgnoreCase(DISTRIBUTED) && !cmd.hasOption(name)) {
            throw new IllegalArgumentException("A unique cluster controller name is required in DISTRIBUTED mode");
        }
        controllerName = cmd.getOptionValue(name);
        logger.info((Object)("Cluster manager started, zkServer: " + zkConnectString + ", clusterName:" + clusterName + ", controllerName:" + controllerName + ", mode:" + controllerMode));
        HelixManager manager = HelixControllerMain.startHelixController(zkConnectString, clusterName, controllerName, controllerMode);
        Runtime.getRuntime().addShutdownHook(new HelixManagerShutdownHook(manager));
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            logger.info((Object)("controller:" + controllerName + ", " + Thread.currentThread().getName() + " interrupted"));
        }
        finally {
            manager.disconnect();
        }
    }
}

