/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.RestfulRequestBuilder;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.common.ResourceSpec;

public abstract class SingleEntityRequestBuilder<K, V extends RecordTemplate, R extends Request<?>>
extends RestfulRequestBuilder<K, V, R> {
    private V _input;
    private K _id;
    private Class<V> _valueClass;

    public SingleEntityRequestBuilder(String baseUriTemplate, Class<V> valueClass, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        super(baseUriTemplate, resourceSpec, requestOptions);
        this._valueClass = valueClass;
    }

    protected SingleEntityRequestBuilder<K, V, R> id(K id) {
        this._id = id;
        return this;
    }

    protected SingleEntityRequestBuilder<K, V, R> input(V entity) {
        this._input = entity;
        return this;
    }

    protected K getId() {
        return this._id;
    }

    protected K buildReadOnlyId() {
        try {
            return this.getReadOnlyOrCopyKey(this._id);
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Key cannot be copied.", cloneException);
        }
    }

    protected V getInput() {
        return this._input;
    }

    protected Class<V> getValueClass() {
        return this._valueClass;
    }

    protected V buildReadOnlyInput() {
        try {
            return (V)((RecordTemplate)this.getReadOnlyOrCopyDataTemplate(this._input));
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Data template cannot be cloned", cloneException);
        }
    }
}

