/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hive;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Set;
import org.apache.gobblin.compaction.hive.CompactionRunner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HdfsIO {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsIO.class);
    private static final String HDFS_URI = "hdfs.uri";
    private static final String HDFS_URI_DEFAULT = "hdfs://localhost:9000";
    private static final String HADOOP_CONFIGFILE_ = "hadoop.configfile.";
    private static final String HDFS_URI_HADOOP = "fs.defaultFS";
    @Deprecated
    private static final String HADOOP_VERSION = "hadoop.version";
    protected final String filePathInHdfs;
    protected final FileSystem fileSystem;

    public HdfsIO(String filePathInHdfs) throws IOException {
        this.filePathInHdfs = filePathInHdfs;
        this.fileSystem = HdfsIO.getFileSystem();
    }

    protected static FileSystem getFileSystem() throws IOException {
        Configuration conf = HdfsIO.getConfiguration();
        return FileSystem.get((Configuration)conf);
    }

    protected static Configuration getConfiguration() {
        Configuration conf = new Configuration();
        HdfsIO.addResourceToConf(conf);
        return conf;
    }

    private static void addResourceToConf(Configuration conf) {
        HdfsIO.addHadoopConfigPropertiesToConf(conf);
        if (CompactionRunner.properties.containsKey(HDFS_URI)) {
            conf.set(HDFS_URI_HADOOP, CompactionRunner.properties.getProperty(HDFS_URI));
        }
        if (Strings.isNullOrEmpty((String)conf.get(HDFS_URI_HADOOP))) {
            conf.set(HDFS_URI_HADOOP, HDFS_URI_DEFAULT);
        }
        CompactionRunner.properties.setProperty(HDFS_URI, conf.get(HDFS_URI_HADOOP));
    }

    private static void addHadoopConfigPropertiesToConf(Configuration conf) {
        Set<String> propertyNames = CompactionRunner.properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith(HADOOP_CONFIGFILE_)) continue;
            String hadoopConfigFile = CompactionRunner.properties.getProperty(propertyName);
            conf.addResource(new Path(hadoopConfigFile));
            LOG.info("Added Hadoop Config File: " + hadoopConfigFile);
        }
    }

    public static String getHdfsUri() {
        return CompactionRunner.properties.getProperty(HDFS_URI, HDFS_URI_DEFAULT);
    }
}

