/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAvroSerializer
extends AbstractKafkaAvroSerializer
implements Serializer<Object> {
    private boolean isKey;

    public KafkaAvroSerializer() {
    }

    public KafkaAvroSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        Object url = configs.get("schema.registry.url");
        if (url == null) {
            throw new ConfigException("Missing Schema registry url!");
        }
        Object maxSchemaObject = configs.get("max.schemas.per.subject");
        this.schemaRegistry = maxSchemaObject == null ? new CachedSchemaRegistryClient((String)url, 1000) : new CachedSchemaRegistryClient((String)url, ((Integer)maxSchemaObject).intValue());
    }

    public byte[] serialize(String topic, Object record) {
        return this.serializeImpl(KafkaAvroSerializer.getSubjectName(topic, this.isKey), record);
    }

    public void close() {
    }
}

