/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cli;

import com.google.common.base.Optional;
import com.linkedin.data.template.StringMap;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.cli.CliTablePrinter;
import org.apache.gobblin.rest.JobExecutionInfo;
import org.apache.gobblin.rest.JobStateEnum;
import org.apache.gobblin.rest.Metric;
import org.apache.gobblin.rest.MetricArray;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class JobInfoPrintUtils {
    private static NumberFormat decimalFormatter = new DecimalFormat("#0.00");
    private static DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateHourMinuteSecond();
    private static PeriodFormatter periodFormatter = PeriodFormat.getDefault();

    public static String extractJobSchedule(JobExecutionInfo jobInfo) {
        if (jobInfo.hasJobProperties() && jobInfo.getJobProperties().size() > 0) {
            StringMap props = jobInfo.getJobProperties();
            if (props.containsKey((Object)"job.runonce") || !props.containsKey((Object)"job.schedule")) {
                return "RUN_ONCE";
            }
            if (props.containsKey((Object)"job.schedule")) {
                return (String)props.get((Object)"job.schedule");
            }
        }
        return "UNKNOWN";
    }

    public static void printJobRuns(List<JobExecutionInfo> jobExecutionInfos) {
        if (jobExecutionInfos == null) {
            System.err.println("No job executions found.");
            System.exit(1);
        }
        List<String> labels = Arrays.asList("Job Id", "State", "Schedule", "Completed Tasks", "Launched Tasks", "Start Time", "End Time", "Duration (s)");
        List<String> flags = Arrays.asList("-", "-", "-", "", "", "-", "-", "-");
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (JobExecutionInfo jobInfo : jobExecutionInfos) {
            ArrayList<String> entry = new ArrayList<String>();
            entry.add(jobInfo.getJobId());
            entry.add(jobInfo.getState().toString());
            entry.add(JobInfoPrintUtils.extractJobSchedule(jobInfo));
            entry.add(jobInfo.getCompletedTasks().toString());
            entry.add(jobInfo.getLaunchedTasks().toString());
            entry.add(dateTimeFormatter.print(jobInfo.getStartTime().longValue()));
            entry.add(dateTimeFormatter.print(jobInfo.getEndTime().longValue()));
            entry.add(jobInfo.getState() == JobStateEnum.COMMITTED ? decimalFormatter.format((double)jobInfo.getDuration().longValue() / 1000.0) : "-");
            data.add(entry);
        }
        new CliTablePrinter.Builder().labels(labels).data(data).flags(flags).delimiterWidth(2).build().printTable();
    }

    public static void printAllJobs(List<JobExecutionInfo> jobExecutionInfos, int resultsLimit) {
        if (jobExecutionInfos == null) {
            System.err.println("No jobs found.");
            System.exit(1);
        }
        List<String> labels = Arrays.asList("Job Name", "State", "Last Run Started", "Last Run Completed", "Schedule", "Last Run Records Processed", "Last Run Records Failed");
        List<String> flags = Arrays.asList("-", "-", "-", "-", "-", "", "");
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (JobExecutionInfo jobInfo : jobExecutionInfos) {
            ArrayList<String> entry = new ArrayList<String>();
            entry.add(jobInfo.getJobName());
            entry.add(jobInfo.getState().toString());
            entry.add(dateTimeFormatter.print(jobInfo.getStartTime().longValue()));
            entry.add(dateTimeFormatter.print(jobInfo.getEndTime().longValue()));
            entry.add(JobInfoPrintUtils.extractJobSchedule(jobInfo));
            MetricArray metrics = jobInfo.getMetrics();
            Double recordsProcessed = null;
            Double recordsFailed = null;
            try {
                for (Metric metric : metrics) {
                    if (metric.getName().equals("gobblin.extractor.records.read")) {
                        recordsProcessed = Double.parseDouble(metric.getValue());
                        continue;
                    }
                    if (!metric.getName().equals("gobblin.extractor.records.failed")) continue;
                    recordsFailed = Double.parseDouble(metric.getValue());
                }
                if (recordsProcessed != null && recordsFailed != null) {
                    entry.add(recordsProcessed.toString());
                    entry.add(recordsFailed.toString());
                }
            }
            catch (NumberFormatException ex) {
                System.err.println("Failed to process metrics");
            }
            if (recordsProcessed == null || recordsFailed == null) {
                entry.add("-");
                entry.add("-");
            }
            data.add(entry);
        }
        new CliTablePrinter.Builder().labels(labels).data(data).flags(flags).delimiterWidth(2).build().printTable();
        if (jobExecutionInfos.size() == resultsLimit) {
            System.out.println("\nWARNING: There may be more jobs (# of results is equal to the limit)");
        }
    }

    public static void printJob(Optional<JobExecutionInfo> jobExecutionInfoOptional) {
        if (!jobExecutionInfoOptional.isPresent()) {
            System.err.println("Job id not found.");
            return;
        }
        JobExecutionInfo jobExecutionInfo = (JobExecutionInfo)jobExecutionInfoOptional.get();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        List<String> flags = Arrays.asList("", "-");
        data.add(Arrays.asList("Job Name", jobExecutionInfo.getJobName()));
        data.add(Arrays.asList("Job Id", jobExecutionInfo.getJobId()));
        data.add(Arrays.asList("State", jobExecutionInfo.getState().toString()));
        data.add(Arrays.asList("Completed/Launched Tasks", String.format("%d/%d", jobExecutionInfo.getCompletedTasks(), jobExecutionInfo.getLaunchedTasks())));
        data.add(Arrays.asList("Start Time", dateTimeFormatter.print(jobExecutionInfo.getStartTime().longValue())));
        data.add(Arrays.asList("End Time", dateTimeFormatter.print(jobExecutionInfo.getEndTime().longValue())));
        data.add(Arrays.asList("Duration", jobExecutionInfo.getState() == JobStateEnum.COMMITTED ? periodFormatter.print((ReadablePeriod)new Period(jobExecutionInfo.getDuration().longValue())) : "-"));
        data.add(Arrays.asList("Tracking URL", jobExecutionInfo.getTrackingUrl()));
        data.add(Arrays.asList("Launcher Type", jobExecutionInfo.getLauncherType().name()));
        new CliTablePrinter.Builder().data(data).flags(flags).delimiterWidth(2).build().printTable();
        JobInfoPrintUtils.printMetrics(jobExecutionInfo.getMetrics());
    }

    public static void printJobProperties(Optional<JobExecutionInfo> jobExecutionInfoOptional) {
        if (!jobExecutionInfoOptional.isPresent()) {
            System.err.println("Job not found.");
            return;
        }
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        List<String> flags = Arrays.asList("", "-");
        List<String> labels = Arrays.asList("Property Key", "Property Value");
        for (Map.Entry entry : ((JobExecutionInfo)jobExecutionInfoOptional.get()).getJobProperties().entrySet()) {
            data.add(Arrays.asList((String)entry.getKey(), (String)entry.getValue()));
        }
        new CliTablePrinter.Builder().labels(labels).data(data).flags(flags).delimiterWidth(2).build().printTable();
    }

    private static void printMetrics(MetricArray metrics) {
        System.out.println();
        if (metrics.size() == 0) {
            System.out.println("No metrics found.");
            return;
        }
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        List<String> flags = Arrays.asList("", "-");
        for (Metric metric : metrics) {
            data.add(Arrays.asList(metric.getName(), metric.getValue()));
        }
        new CliTablePrinter.Builder().data(data).flags(flags).delimiterWidth(2).build().printTable();
    }
}

