/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2;

import com.linkedin.d2.D2DegraderProperties;
import com.linkedin.d2.D2LoadBalancerStrategyProperties;
import com.linkedin.d2.D2TransportClientProperties;
import com.linkedin.d2.LoadBalancerStrategyTypeArray;
import com.linkedin.d2.SchemeArray;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import java.util.List;

public class D2Service
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"D2Service\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"A service as represented in D2\",\"include\":[{\"type\":\"record\",\"name\":\"D2ChangeTimeStamps\",\"doc\":\"Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages.\",\"fields\":[{\"name\":\"created\",\"type\":\"long\",\"doc\":\"A timestamp corresponding to the creation of this resource/association/sub-resource\"},{\"name\":\"lastModified\",\"type\":\"long\",\"doc\":\"A timestamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created\"},{\"name\":\"deleted\",\"type\":\"long\",\"doc\":\"A timestamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.\",\"optional\":true}]}],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"The name of the service\"},{\"name\":\"path\",\"type\":\"string\",\"doc\":\"The path to reach the resource/service\"},{\"name\":\"loadBalancerStrategyList\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"loadBalancerStrategyType\",\"doc\":\"There are 2 types of strategy: DEGRADER, RANDOM\",\"symbols\":[\"DEGRADER\",\"RANDOM\"],\"symbolDocs\":{\"DEGRADER\":\"This strategy will choose an endpoint based on multiple hints like latency, error rate and other call statistics\",\"RANDOM\":\"This strategy will choose an endpoint randomly.\"}}},\"doc\":\"Prioritized order of strategy that this service should use.\"},{\"name\":\"prioritizedSchemes\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"scheme\",\"doc\":\"There are 2 types of scheme: HTTP, HTTPS\",\"symbols\":[\"HTTP\",\"HTTPS\"]}},\"doc\":\"List of schemes that this service supports ordered by priority\"},{\"name\":\"bannedUris\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"banned Uris for this service\"},{\"name\":\"serviceMetadataProperties\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Metadata properties about the service e.g. multi colo routing, service variants, etc\"},{\"name\":\"cluster\",\"type\":\"string\",\"doc\":\"The cluster where this service belongs\"},{\"name\":\"loadBalancerStrategyProperties\",\"type\":{\"type\":\"record\",\"name\":\"D2LoadBalancerStrategyProperties\",\"doc\":\"Load balancer properties for a particular D2 service\",\"fields\":[{\"name\":\"globalStepDown\",\"type\":\"double\",\"doc\":\"The step down function's delta size when adjusting the drop rate. Should be between 0.0 - 1.0. Defaults to 0.2.\",\"optional\":true},{\"name\":\"globalStepUp\",\"type\":\"double\",\"doc\":\"The step up function's delta size when adjusting the drop rate. Should be between 0.0 - 1.0. Defaults to 0.2.\",\"optional\":true},{\"name\":\"initialRecoveryLevel\",\"type\":\"double\",\"doc\":\"When a node is completely degraded, this config is used to determine the starting recovery weight for that node. Should be between 0.0 - 1.0. Defaults to 0.01.\",\"optional\":true},{\"name\":\"ringRampFactor\",\"type\":\"double\",\"doc\":\"How fast should load balancer ramp up node that has been 100% degraded and is being recovered. This is used with initialRecoveryLevel to recover the traffic of a node. Defaults to 1.0.\",\"optional\":true},{\"name\":\"highWaterMark\",\"type\":\"double\",\"doc\":\"If average ms latency for the entire service is over this number then we consider the service is in a bad state. Defaults to 3000ms.\",\"optional\":true},{\"name\":\"lowWaterMark\",\"type\":\"double\",\"doc\":\"If average ms latency for the entire service is lower than this number then we consider the service is in a good state. Defaults to 500ms.\",\"optional\":true},{\"name\":\"pointsPerWeight\",\"type\":\"int\",\"doc\":\"The number of points per weight given for a particular node in a hash ring. Defaults to 100.\",\"optional\":true},{\"name\":\"updateIntervalMs\",\"type\":\"long\",\"doc\":\"Interval in ms between each round of load balancer calculation. Defaults to 5000ms.\",\"optional\":true},{\"name\":\"minCallCountHighWaterMark\",\"type\":\"long\",\"doc\":\"If call count for the cluster for this service is over this number then we can use the statistics to calculate drop rate. Defaults to 10.\",\"optional\":true},{\"name\":\"minCallCountLowWaterMark\",\"type\":\"long\",\"doc\":\"If call count for the cluster for this service is below this number then we will not use the statistics to calculate drop rate. Defaults to 5.\",\"optional\":true},{\"name\":\"hashMethod\",\"type\":{\"type\":\"enum\",\"name\":\"hashMethodEnum\",\"symbols\":[\"RANDOM\",\"URI_REGEX\"]},\"doc\":\"What hashing method used to hash incoming request. Used to determine which node should serve the request. Choices are Random, UriRegex\",\"optional\":true,\"symbolDocs\":{\"URI_REGEX\":\"Extract a key from URI and use it to hash\",\"RANDOM\":\"The default fall back value\"}},{\"name\":\"hashConfig\",\"type\":{\"type\":\"record\",\"name\":\"hashConfigType\",\"fields\":[{\"name\":\"uriRegexes\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"List of Regex to match against the URI of incoming request and compute hash value. The hash value is computed based on the contents of the first capture group of the first expression that matches the request URI\",\"optional\":true},{\"name\":\"failOnNoMatch\",\"type\":\"boolean\",\"doc\":\"Optional config value. if true, fail if no regex matches, otherwise fall back to random.\",\"default\":false},{\"name\":\"warnOnNoMatch\",\"type\":\"boolean\",\"doc\":\" Optional config value. if false, don't warn on falling back to random if the uri doesn't match the regex\",\"default\":true}]},\"doc\":\"Configuration used to supplement the hash method.\",\"optional\":true},{\"name\":\"updateOnlyAtInterval\",\"type\":\"boolean\",\"doc\":\"Whether to update load balancer strategy state only at each update interval.\",\"default\":false},{\"name\":\"hashRingPointCleanupRate\",\"type\":\"double\",\"doc\":\"The highest ratio of unused entries over the total entries of the Ring points that d2 maintains.\",\"optional\":true},{\"name\":\"consistentHashAlgorithm\",\"type\":{\"type\":\"enum\",\"name\":\"ConsistentHashAlgorithmEnum\",\"symbols\":[\"POINT_BASED\",\"MULTI_PROBE\"],\"symbolDocs\":{\"POINT_BASED\":\"Point-based consistent hash ring. The more points the ring has, the more balanced it is.\",\"MULTI_PROBE\":\"Multi-probe consistent hash. The more probes to use, the more balanced the ring is.\"}},\"doc\":\"Consistent hash algorithm the d2 load balancer should use. Defaults to POINT_BASED.\",\"optional\":true},{\"name\":\"numberOfProbes\",\"type\":\"int\",\"doc\":\"The number of probes used to look up a key in consistent hash ring. Defaults to 21.\",\"optional\":true},{\"name\":\"quarantineCfg\",\"type\":{\"type\":\"record\",\"name\":\"quarantineInfo\",\"doc\":\"Config info for d2 quarantine feature\",\"fields\":[{\"name\":\"quarantineMaxPercent\",\"type\":\"double\",\"doc\":\"The percentage of the hosts that can be quarantined at the same time. It is also the switch to turn on Quarantine feature.\"},{\"name\":\"quarantineMethod\",\"type\":\"string\",\"doc\":\"Config the health checking method for quarantine. Format: <METHOD>:<FULL_PATH>. Default to OPTIONS method.\",\"optional\":true},{\"name\":\"quarantineLatency\",\"type\":\"long\",\"doc\":\"The latency threshold (in milliseconds) for health checking response. Responding time longer than this threshold is considered as unhealthy.\",\"optional\":true}]},\"optional\":true},{\"name\":\"errorStatusRegex\",\"type\":\"string\",\"doc\":\"Regular expression to match the status code indicates a server-side error.\",\"optional\":true}]},\"doc\":\"The load balancer strategy properties for this service\"},{\"name\":\"degraderProperties\",\"type\":{\"type\":\"record\",\"name\":\"D2DegraderProperties\",\"doc\":\"Degrader properties that is applied to all tracker clients talking to this particular D2 service\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"The name of this degrader.\",\"optional\":true},{\"name\":\"logEnabled\",\"type\":\"boolean\",\"doc\":\"Whether degrader-specific logging is enabled or not. Defaults to false.\",\"default\":false},{\"name\":\"maxDropRate\",\"type\":\"double\",\"doc\":\"The maximum drop rate that this degrader can achieve. Values are from 0.0 - 1.0. Defaults to 1.0.\",\"optional\":true},{\"name\":\"upStep\",\"type\":\"double\",\"doc\":\"Degrader's step function's delta size for increasing the drop rate. Values are from 0.0 - 1.0. Defaults to 0.2.\",\"optional\":true},{\"name\":\"downStep\",\"type\":\"double\",\"doc\":\"Degrader's step function's delta size for decreasing the drop rate. Values are from 0.0 - 1.0. Defaults to 0.2.\",\"optional\":true},{\"name\":\"minCallCount\",\"type\":\"int\",\"doc\":\"The minimum number of call count that should be achieved before degrader start using the call statistics to compute drop rate. Defaults to 10.\",\"optional\":true},{\"name\":\"highLatency\",\"type\":\"int\",\"doc\":\"If the call latency during the interval exceeds this value, then we will increase the drop rate by upStep. Defaults to 3000ms.\",\"optional\":true},{\"name\":\"lowLatency\",\"type\":\"int\",\"doc\":\"If the call latency during the interval is under this value, then we will decrease the drop rate by downStep. Defaults to 500ms.\",\"optional\":true},{\"name\":\"highErrorRate\",\"type\":\"double\",\"doc\":\"If the error rate during the interval exceeds this value, then we will increase the drop rate by upStep. Values are from 0.0 - 1.0. Defaults to 1.1.\",\"optional\":true},{\"name\":\"lowErrorRate\",\"type\":\"double\",\"doc\":\"If the error rate during the interval is under this value, then we will decrease the drop rate by downStep. Values are from 0.0 - 1.0. Defaults to 1.1.\",\"optional\":true},{\"name\":\"highOutstanding\",\"type\":\"int\",\"doc\":\"If the latency of outstanding calls during the interval exceeds this value, then we will increase the drop rate by upStep. Defaults to 10000ms.\",\"optional\":true},{\"name\":\"lowOutstanding\",\"type\":\"int\",\"doc\":\"If the latency of outstanding calls during the interval is under this value, then we will decrease the drop rate by downStep. Defaults to 500ms.\",\"optional\":true},{\"name\":\"minOutstandingCount\",\"type\":\"int\",\"doc\":\"If the number of minOutstanding calls exceeds this value then we will consider outstanding latency to compute drop rate. Defaults to 5.\",\"optional\":true},{\"name\":\"maxDropDuration\",\"type\":\"long\",\"doc\":\"maximum duration that is allowed when all requests are dropped. For example, if maxDropDuration is 1 min and the last request that should not be dropped is older than 1 min, then the next request should not be dropped. Defaults to 60000ms.\",\"optional\":true},{\"name\":\"latencyToUse\",\"type\":{\"type\":\"enum\",\"name\":\"latencyType\",\"symbols\":[\"AVERAGE\",\"PCT50\",\"PCT90\",\"PCT95\",\"PCT99\"],\"symbolDocs\":{\"AVERAGE\":\"Average latency\",\"PCT50\":\"50th percentile latency\",\"PCT90\":\"90th percentile latency\",\"PCT95\":\"95th percentile latency\",\"PCT99\":\"99th percentile latency\"}},\"doc\":\"latency used to calculate the drop rate. Defaults to AVERAGE.\",\"optional\":true},{\"name\":\"initialDropRate\",\"type\":\"double\",\"doc\":\"The initial drop rate that this degrader should start with. Defaults to 0.0. For values greater than 0, it means the tracker client corresponding to this degrader will receive less than 100% of the normal traffic initially and slowly recover from there.\",\"optional\":true},{\"name\":\"slowStartThreshold\",\"type\":\"double\",\"doc\":\"The drop rate threshold that controls whether the degrader should perform slow start(by doubling the transmission rate) or the normal stepUp/Down operation. Defaults to 0.0 which means no slow start phase will be performed.\",\"optional\":true}]},\"doc\":\"The degrader properties for this service\"},{\"name\":\"transportClientProperties\",\"type\":{\"type\":\"record\",\"name\":\"D2TransportClientProperties\",\"doc\":\"The properties that is applied when creating transport client to talk to this particular D2 service\",\"fields\":[{\"name\":\"queryPostThreshold\",\"type\":\"int\",\"doc\":\"The minimum size of GET requests parameters before we start converting it to POST request.\",\"optional\":true},{\"name\":\"requestTimeout\",\"type\":\"long\",\"doc\":\"Timeout in ms for this transport client. Defaults to 10s.\",\"optional\":true},{\"name\":\"maxResponseSize\",\"type\":\"long\",\"doc\":\"Max payload that this transport client can carry in bytes. Defaults to 2MB.\",\"optional\":true},{\"name\":\"maxHeaderSize\",\"type\":\"int\",\"doc\":\"Maximum size, in bytes, of all headers for a single HTTP request/response. Defaults to 8KB.\",\"optional\":true},{\"name\":\"maxChunkSize\",\"type\":\"int\",\"doc\":\"Maximum chunk size, in bytes, of HTTP chunked encoding. Defaults to 8KB.\",\"optional\":true},{\"name\":\"poolSize\",\"type\":\"int\",\"doc\":\"Maximum size of the underlying HTTP connection pool. Defaults to 200.\",\"optional\":true},{\"name\":\"poolWaiterSize\",\"type\":\"int\",\"doc\":\"Maximum waiters waiting on the HTTP connection pool.\",\"optional\":true},{\"name\":\"poolStrategy\",\"type\":{\"type\":\"enum\",\"name\":\"poolStrategyType\",\"symbols\":[\"MRU\",\"LRU\"],\"symbolDocs\":{\"MRU\":\"Select most recently used connection\",\"LRU\":\"Select least recently used connection\"}},\"doc\":\"The strategy HTTP connection pool uses to select connections. Defaults to MRU.\",\"optional\":true},{\"name\":\"minPoolSize\",\"type\":\"int\",\"doc\":\"Minimum size of the HTTP connection pool\",\"optional\":true},{\"name\":\"maxConcurrentConnections\",\"type\":\"int\",\"doc\":\"Maximum connection requests this transport client can send to an endpoint concurrently.\",\"optional\":true},{\"name\":\"idleTimeout\",\"type\":\"long\",\"doc\":\"interval after which idle connections will be automatically closed. Defaults to 25s.\",\"optional\":true},{\"name\":\"shutdownTimeout\",\"type\":\"long\",\"doc\":\"timeout, in ms, the client should wait after shutdown is initiated before terminating outstanding requests. Defaults to 5s\",\"optional\":true},{\"name\":\"responseCompressionOperations\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"operations where compression should be used\",\"optional\":true},{\"name\":\"responseContentEncodings\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"preferred content encodings for responses, used to construct Accept-Encoding header\",\"optional\":true},{\"name\":\"requestContentEncodings\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"supported content encodings for requests\",\"optional\":true},{\"name\":\"useResponseCompression\",\"type\":\"boolean\",\"doc\":\"whether to enable response compression or not\",\"default\":false},{\"name\":\"allowedClientOverrideKeys\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"a list of keys in D2TransportClientProperties which client can override\",\"default\":[]},{\"name\":\"protocolVersion\",\"type\":{\"type\":\"enum\",\"name\":\"HttpProtocolVersionType\",\"symbols\":[\"HTTP_1_1\",\"HTTP_2\"],\"symbolDocs\":{\"HTTP_1_1\":\"HTTP/1.1\",\"HTTP_2\":\"HTTP/2\"}},\"doc\":\"service desired transport client protocol version e.g. HTTP/1.1, HTTP/2\",\"optional\":true}]},\"doc\":\"The transport client properties for this service\"}]}");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");
    private static final RecordDataSchema.Field FIELD_Deleted = SCHEMA.getField("deleted");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Path = SCHEMA.getField("path");
    private static final RecordDataSchema.Field FIELD_LoadBalancerStrategyList = SCHEMA.getField("loadBalancerStrategyList");
    private static final RecordDataSchema.Field FIELD_PrioritizedSchemes = SCHEMA.getField("prioritizedSchemes");
    private static final RecordDataSchema.Field FIELD_BannedUris = SCHEMA.getField("bannedUris");
    private static final RecordDataSchema.Field FIELD_ServiceMetadataProperties = SCHEMA.getField("serviceMetadataProperties");
    private static final RecordDataSchema.Field FIELD_Cluster = SCHEMA.getField("cluster");
    private static final RecordDataSchema.Field FIELD_LoadBalancerStrategyProperties = SCHEMA.getField("loadBalancerStrategyProperties");
    private static final RecordDataSchema.Field FIELD_DegraderProperties = SCHEMA.getField("degraderProperties");
    private static final RecordDataSchema.Field FIELD_TransportClientProperties = SCHEMA.getField("transportClientProperties");

    public D2Service() {
        super(new DataMap(), SCHEMA);
    }

    public D2Service(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasCreated() {
        return this.contains(FIELD_Created);
    }

    public void removeCreated() {
        this.remove(FIELD_Created);
    }

    public Long getCreated(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_Created, Long.class, mode);
    }

    public Long getCreated() {
        return (Long)this.obtainDirect(FIELD_Created, Long.class, GetMode.STRICT);
    }

    public D2Service setCreated(Long value, SetMode mode) {
        this.putDirect(FIELD_Created, Long.class, Long.class, value, mode);
        return this;
    }

    public D2Service setCreated(Long value) {
        this.putDirect(FIELD_Created, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Service setCreated(long value) {
        this.putDirect(FIELD_Created, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLastModified() {
        return this.contains(FIELD_LastModified);
    }

    public void removeLastModified() {
        this.remove(FIELD_LastModified);
    }

    public Long getLastModified(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_LastModified, Long.class, mode);
    }

    public Long getLastModified() {
        return (Long)this.obtainDirect(FIELD_LastModified, Long.class, GetMode.STRICT);
    }

    public D2Service setLastModified(Long value, SetMode mode) {
        this.putDirect(FIELD_LastModified, Long.class, Long.class, value, mode);
        return this;
    }

    public D2Service setLastModified(Long value) {
        this.putDirect(FIELD_LastModified, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Service setLastModified(long value) {
        this.putDirect(FIELD_LastModified, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDeleted() {
        return this.contains(FIELD_Deleted);
    }

    public void removeDeleted() {
        this.remove(FIELD_Deleted);
    }

    public Long getDeleted(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_Deleted, Long.class, mode);
    }

    public Long getDeleted() {
        return (Long)this.obtainDirect(FIELD_Deleted, Long.class, GetMode.STRICT);
    }

    public D2Service setDeleted(Long value, SetMode mode) {
        this.putDirect(FIELD_Deleted, Long.class, Long.class, value, mode);
        return this;
    }

    public D2Service setDeleted(Long value) {
        this.putDirect(FIELD_Deleted, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Service setDeleted(long value) {
        this.putDirect(FIELD_Deleted, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasName() {
        return this.contains(FIELD_Name);
    }

    public void removeName() {
        this.remove(FIELD_Name);
    }

    public String getName(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Name, String.class, mode);
    }

    public String getName() {
        return (String)this.obtainDirect(FIELD_Name, String.class, GetMode.STRICT);
    }

    public D2Service setName(String value, SetMode mode) {
        this.putDirect(FIELD_Name, String.class, String.class, value, mode);
        return this;
    }

    public D2Service setName(String value) {
        this.putDirect(FIELD_Name, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPath() {
        return this.contains(FIELD_Path);
    }

    public void removePath() {
        this.remove(FIELD_Path);
    }

    public String getPath(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Path, String.class, mode);
    }

    public String getPath() {
        return (String)this.obtainDirect(FIELD_Path, String.class, GetMode.STRICT);
    }

    public D2Service setPath(String value, SetMode mode) {
        this.putDirect(FIELD_Path, String.class, String.class, value, mode);
        return this;
    }

    public D2Service setPath(String value) {
        this.putDirect(FIELD_Path, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLoadBalancerStrategyList() {
        return this.contains(FIELD_LoadBalancerStrategyList);
    }

    public void removeLoadBalancerStrategyList() {
        this.remove(FIELD_LoadBalancerStrategyList);
    }

    public LoadBalancerStrategyTypeArray getLoadBalancerStrategyList(GetMode mode) {
        return (LoadBalancerStrategyTypeArray)this.obtainWrapped(FIELD_LoadBalancerStrategyList, LoadBalancerStrategyTypeArray.class, mode);
    }

    public LoadBalancerStrategyTypeArray getLoadBalancerStrategyList() {
        return (LoadBalancerStrategyTypeArray)this.obtainWrapped(FIELD_LoadBalancerStrategyList, LoadBalancerStrategyTypeArray.class, GetMode.STRICT);
    }

    public D2Service setLoadBalancerStrategyList(LoadBalancerStrategyTypeArray value, SetMode mode) {
        this.putWrapped(FIELD_LoadBalancerStrategyList, LoadBalancerStrategyTypeArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Service setLoadBalancerStrategyList(LoadBalancerStrategyTypeArray value) {
        this.putWrapped(FIELD_LoadBalancerStrategyList, LoadBalancerStrategyTypeArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPrioritizedSchemes() {
        return this.contains(FIELD_PrioritizedSchemes);
    }

    public void removePrioritizedSchemes() {
        this.remove(FIELD_PrioritizedSchemes);
    }

    public SchemeArray getPrioritizedSchemes(GetMode mode) {
        return (SchemeArray)this.obtainWrapped(FIELD_PrioritizedSchemes, SchemeArray.class, mode);
    }

    public SchemeArray getPrioritizedSchemes() {
        return (SchemeArray)this.obtainWrapped(FIELD_PrioritizedSchemes, SchemeArray.class, GetMode.STRICT);
    }

    public D2Service setPrioritizedSchemes(SchemeArray value, SetMode mode) {
        this.putWrapped(FIELD_PrioritizedSchemes, SchemeArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Service setPrioritizedSchemes(SchemeArray value) {
        this.putWrapped(FIELD_PrioritizedSchemes, SchemeArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasBannedUris() {
        return this.contains(FIELD_BannedUris);
    }

    public void removeBannedUris() {
        this.remove(FIELD_BannedUris);
    }

    public StringArray getBannedUris(GetMode mode) {
        return (StringArray)this.obtainWrapped(FIELD_BannedUris, StringArray.class, mode);
    }

    public StringArray getBannedUris() {
        return (StringArray)this.obtainWrapped(FIELD_BannedUris, StringArray.class, GetMode.STRICT);
    }

    public D2Service setBannedUris(StringArray value, SetMode mode) {
        this.putWrapped(FIELD_BannedUris, StringArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Service setBannedUris(StringArray value) {
        this.putWrapped(FIELD_BannedUris, StringArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasServiceMetadataProperties() {
        return this.contains(FIELD_ServiceMetadataProperties);
    }

    public void removeServiceMetadataProperties() {
        this.remove(FIELD_ServiceMetadataProperties);
    }

    public StringMap getServiceMetadataProperties(GetMode mode) {
        return (StringMap)this.obtainWrapped(FIELD_ServiceMetadataProperties, StringMap.class, mode);
    }

    public StringMap getServiceMetadataProperties() {
        return (StringMap)this.obtainWrapped(FIELD_ServiceMetadataProperties, StringMap.class, GetMode.STRICT);
    }

    public D2Service setServiceMetadataProperties(StringMap value, SetMode mode) {
        this.putWrapped(FIELD_ServiceMetadataProperties, StringMap.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Service setServiceMetadataProperties(StringMap value) {
        this.putWrapped(FIELD_ServiceMetadataProperties, StringMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasCluster() {
        return this.contains(FIELD_Cluster);
    }

    public void removeCluster() {
        this.remove(FIELD_Cluster);
    }

    public String getCluster(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Cluster, String.class, mode);
    }

    public String getCluster() {
        return (String)this.obtainDirect(FIELD_Cluster, String.class, GetMode.STRICT);
    }

    public D2Service setCluster(String value, SetMode mode) {
        this.putDirect(FIELD_Cluster, String.class, String.class, value, mode);
        return this;
    }

    public D2Service setCluster(String value) {
        this.putDirect(FIELD_Cluster, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLoadBalancerStrategyProperties() {
        return this.contains(FIELD_LoadBalancerStrategyProperties);
    }

    public void removeLoadBalancerStrategyProperties() {
        this.remove(FIELD_LoadBalancerStrategyProperties);
    }

    public D2LoadBalancerStrategyProperties getLoadBalancerStrategyProperties(GetMode mode) {
        return (D2LoadBalancerStrategyProperties)this.obtainWrapped(FIELD_LoadBalancerStrategyProperties, D2LoadBalancerStrategyProperties.class, mode);
    }

    public D2LoadBalancerStrategyProperties getLoadBalancerStrategyProperties() {
        return (D2LoadBalancerStrategyProperties)this.obtainWrapped(FIELD_LoadBalancerStrategyProperties, D2LoadBalancerStrategyProperties.class, GetMode.STRICT);
    }

    public D2Service setLoadBalancerStrategyProperties(D2LoadBalancerStrategyProperties value, SetMode mode) {
        this.putWrapped(FIELD_LoadBalancerStrategyProperties, D2LoadBalancerStrategyProperties.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Service setLoadBalancerStrategyProperties(D2LoadBalancerStrategyProperties value) {
        this.putWrapped(FIELD_LoadBalancerStrategyProperties, D2LoadBalancerStrategyProperties.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDegraderProperties() {
        return this.contains(FIELD_DegraderProperties);
    }

    public void removeDegraderProperties() {
        this.remove(FIELD_DegraderProperties);
    }

    public D2DegraderProperties getDegraderProperties(GetMode mode) {
        return (D2DegraderProperties)this.obtainWrapped(FIELD_DegraderProperties, D2DegraderProperties.class, mode);
    }

    public D2DegraderProperties getDegraderProperties() {
        return (D2DegraderProperties)this.obtainWrapped(FIELD_DegraderProperties, D2DegraderProperties.class, GetMode.STRICT);
    }

    public D2Service setDegraderProperties(D2DegraderProperties value, SetMode mode) {
        this.putWrapped(FIELD_DegraderProperties, D2DegraderProperties.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Service setDegraderProperties(D2DegraderProperties value) {
        this.putWrapped(FIELD_DegraderProperties, D2DegraderProperties.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTransportClientProperties() {
        return this.contains(FIELD_TransportClientProperties);
    }

    public void removeTransportClientProperties() {
        this.remove(FIELD_TransportClientProperties);
    }

    public D2TransportClientProperties getTransportClientProperties(GetMode mode) {
        return (D2TransportClientProperties)this.obtainWrapped(FIELD_TransportClientProperties, D2TransportClientProperties.class, mode);
    }

    public D2TransportClientProperties getTransportClientProperties() {
        return (D2TransportClientProperties)this.obtainWrapped(FIELD_TransportClientProperties, D2TransportClientProperties.class, GetMode.STRICT);
    }

    public D2Service setTransportClientProperties(D2TransportClientProperties value, SetMode mode) {
        this.putWrapped(FIELD_TransportClientProperties, D2TransportClientProperties.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Service setTransportClientProperties(D2TransportClientProperties value) {
        this.putWrapped(FIELD_TransportClientProperties, D2TransportClientProperties.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Service clone() throws CloneNotSupportedException {
        return (D2Service)super.clone();
    }

    public D2Service copy() throws CloneNotSupportedException {
        return (D2Service)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec created() {
            return new PathSpec(this.getPathComponents(), "created");
        }

        public PathSpec lastModified() {
            return new PathSpec(this.getPathComponents(), "lastModified");
        }

        public PathSpec deleted() {
            return new PathSpec(this.getPathComponents(), "deleted");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec path() {
            return new PathSpec(this.getPathComponents(), "path");
        }

        public PathSpec loadBalancerStrategyList() {
            return new PathSpec(this.getPathComponents(), "loadBalancerStrategyList");
        }

        public PathSpec prioritizedSchemes() {
            return new PathSpec(this.getPathComponents(), "prioritizedSchemes");
        }

        public PathSpec bannedUris() {
            return new PathSpec(this.getPathComponents(), "bannedUris");
        }

        public PathSpec serviceMetadataProperties() {
            return new PathSpec(this.getPathComponents(), "serviceMetadataProperties");
        }

        public PathSpec cluster() {
            return new PathSpec(this.getPathComponents(), "cluster");
        }

        public D2LoadBalancerStrategyProperties.Fields loadBalancerStrategyProperties() {
            return new D2LoadBalancerStrategyProperties.Fields(this.getPathComponents(), "loadBalancerStrategyProperties");
        }

        public D2DegraderProperties.Fields degraderProperties() {
            return new D2DegraderProperties.Fields(this.getPathComponents(), "degraderProperties");
        }

        public D2TransportClientProperties.Fields transportClientProperties() {
            return new D2TransportClientProperties.Fields(this.getPathComponents(), "transportClientProperties");
        }
    }
}

