/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2;

import com.linkedin.d2.PartitionTypeEnum;
import com.linkedin.d2.hashAlgorithm;
import com.linkedin.d2.rangedPartitionProperties;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;

public class D2ClusterPartitionConfiguration
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"D2ClusterPartitionConfiguration\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"Partitioning configuration for D2 clusters\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"PartitionTypeEnum\",\"symbols\":[\"HASH\",\"RANGE\",\"NONE\"]},\"doc\":\"The type of partitioning. We support HASH, RANGE, NONE.\",\"symbolDocs\":{\"NONE\":\"No Partitioning.\",\"RANGE\":\"partitioning based on range e.g. Id 1-1000 goes to bucket A, Id 1001-2000 goes to bucket B, etc.\",\"HASH\":\"Partitioning based on hash.\"}},{\"name\":\"partitionKeyRegex\",\"type\":\"string\",\"doc\":\"The regular expression to extract the partition key from a request URI.\",\"optional\":true},{\"name\":\"partitionCount\",\"type\":\"int\",\"doc\":\"The number of partitions this cluster has.\",\"optional\":true},{\"name\":\"partitionTypeSpecificData\",\"type\":[{\"type\":\"record\",\"name\":\"rangedPartitionProperties\",\"fields\":[{\"name\":\"partitionSize\",\"type\":\"long\",\"doc\":\"The size of each partition. Used only for RANGE based partition. Not used for HASH based partition\"},{\"name\":\"keyRangeStart\",\"type\":\"long\",\"doc\":\"The starting point for RANGE partitioning. Not used for HASH based partition.\"}]},{\"type\":\"enum\",\"name\":\"hashAlgorithm\",\"doc\":\"The hashing algorithm used in HASH based partitioning. Supported algorithms are: MODULO or MD5. Not used for RANGE based partition.\",\"symbols\":[\"MODULO\",\"MD5\"],\"symbolDocs\":{\"MODULO\":\"Mod the key with partitionCount to get the partitionKey\",\"MD5\":\"Hash the key and mod it with partitionCount to get the partitionKey\"}}],\"doc\":\"If the partition type is RANGE, then we have rangedPartitionProperties. If it's type HASH, we should have a hashAlgorithm. Otherwise we won't have any extra data in this field\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_PartitionKeyRegex = SCHEMA.getField("partitionKeyRegex");
    private static final RecordDataSchema.Field FIELD_PartitionCount = SCHEMA.getField("partitionCount");
    private static final RecordDataSchema.Field FIELD_PartitionTypeSpecificData = SCHEMA.getField("partitionTypeSpecificData");

    public D2ClusterPartitionConfiguration() {
        super(new DataMap(), SCHEMA);
    }

    public D2ClusterPartitionConfiguration(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasType() {
        return this.contains(FIELD_Type);
    }

    public void removeType() {
        this.remove(FIELD_Type);
    }

    public PartitionTypeEnum getType(GetMode mode) {
        return (PartitionTypeEnum)((Object)this.obtainDirect(FIELD_Type, PartitionTypeEnum.class, mode));
    }

    public PartitionTypeEnum getType() {
        return (PartitionTypeEnum)((Object)this.obtainDirect(FIELD_Type, PartitionTypeEnum.class, GetMode.STRICT));
    }

    public D2ClusterPartitionConfiguration setType(PartitionTypeEnum value, SetMode mode) {
        this.putDirect(FIELD_Type, PartitionTypeEnum.class, String.class, (Object)value, mode);
        return this;
    }

    public D2ClusterPartitionConfiguration setType(PartitionTypeEnum value) {
        this.putDirect(FIELD_Type, PartitionTypeEnum.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPartitionKeyRegex() {
        return this.contains(FIELD_PartitionKeyRegex);
    }

    public void removePartitionKeyRegex() {
        this.remove(FIELD_PartitionKeyRegex);
    }

    public String getPartitionKeyRegex(GetMode mode) {
        return (String)this.obtainDirect(FIELD_PartitionKeyRegex, String.class, mode);
    }

    public String getPartitionKeyRegex() {
        return (String)this.obtainDirect(FIELD_PartitionKeyRegex, String.class, GetMode.STRICT);
    }

    public D2ClusterPartitionConfiguration setPartitionKeyRegex(String value, SetMode mode) {
        this.putDirect(FIELD_PartitionKeyRegex, String.class, String.class, value, mode);
        return this;
    }

    public D2ClusterPartitionConfiguration setPartitionKeyRegex(String value) {
        this.putDirect(FIELD_PartitionKeyRegex, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPartitionCount() {
        return this.contains(FIELD_PartitionCount);
    }

    public void removePartitionCount() {
        this.remove(FIELD_PartitionCount);
    }

    public Integer getPartitionCount(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_PartitionCount, Integer.class, mode);
    }

    public Integer getPartitionCount() {
        return (Integer)this.obtainDirect(FIELD_PartitionCount, Integer.class, GetMode.STRICT);
    }

    public D2ClusterPartitionConfiguration setPartitionCount(Integer value, SetMode mode) {
        this.putDirect(FIELD_PartitionCount, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2ClusterPartitionConfiguration setPartitionCount(Integer value) {
        this.putDirect(FIELD_PartitionCount, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2ClusterPartitionConfiguration setPartitionCount(int value) {
        this.putDirect(FIELD_PartitionCount, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPartitionTypeSpecificData() {
        return this.contains(FIELD_PartitionTypeSpecificData);
    }

    public void removePartitionTypeSpecificData() {
        this.remove(FIELD_PartitionTypeSpecificData);
    }

    public PartitionTypeSpecificData getPartitionTypeSpecificData(GetMode mode) {
        return (PartitionTypeSpecificData)this.obtainWrapped(FIELD_PartitionTypeSpecificData, PartitionTypeSpecificData.class, mode);
    }

    public PartitionTypeSpecificData getPartitionTypeSpecificData() {
        return (PartitionTypeSpecificData)this.obtainWrapped(FIELD_PartitionTypeSpecificData, PartitionTypeSpecificData.class, GetMode.STRICT);
    }

    public D2ClusterPartitionConfiguration setPartitionTypeSpecificData(PartitionTypeSpecificData value, SetMode mode) {
        this.putWrapped(FIELD_PartitionTypeSpecificData, PartitionTypeSpecificData.class, (DataTemplate)value, mode);
        return this;
    }

    public D2ClusterPartitionConfiguration setPartitionTypeSpecificData(PartitionTypeSpecificData value) {
        this.putWrapped(FIELD_PartitionTypeSpecificData, PartitionTypeSpecificData.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2ClusterPartitionConfiguration clone() throws CloneNotSupportedException {
        return (D2ClusterPartitionConfiguration)super.clone();
    }

    public D2ClusterPartitionConfiguration copy() throws CloneNotSupportedException {
        return (D2ClusterPartitionConfiguration)super.copy();
    }

    public static final class PartitionTypeSpecificData
    extends UnionTemplate {
        private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema((String)"[{\"type\":\"record\",\"name\":\"rangedPartitionProperties\",\"namespace\":\"com.linkedin.d2\",\"fields\":[{\"name\":\"partitionSize\",\"type\":\"long\",\"doc\":\"The size of each partition. Used only for RANGE based partition. Not used for HASH based partition\"},{\"name\":\"keyRangeStart\",\"type\":\"long\",\"doc\":\"The starting point for RANGE partitioning. Not used for HASH based partition.\"}]},{\"type\":\"enum\",\"name\":\"hashAlgorithm\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"The hashing algorithm used in HASH based partitioning. Supported algorithms are: MODULO or MD5. Not used for RANGE based partition.\",\"symbols\":[\"MODULO\",\"MD5\"],\"symbolDocs\":{\"MODULO\":\"Mod the key with partitionCount to get the partitionKey\",\"MD5\":\"Hash the key and mod it with partitionCount to get the partitionKey\"}}]");
        private static final DataSchema MEMBER_RangedPartitionProperties = SCHEMA.getType("com.linkedin.d2.rangedPartitionProperties");
        private static final DataSchema MEMBER_HashAlgorithm = SCHEMA.getType("com.linkedin.d2.hashAlgorithm");

        public PartitionTypeSpecificData() {
            super((Object)new DataMap(), SCHEMA);
        }

        public PartitionTypeSpecificData(Object data) {
            super(data, SCHEMA);
        }

        public static PartitionTypeSpecificData create(rangedPartitionProperties value) {
            PartitionTypeSpecificData newUnion = new PartitionTypeSpecificData();
            newUnion.setRangedPartitionProperties(value);
            return newUnion;
        }

        public boolean isRangedPartitionProperties() {
            return this.memberIs("com.linkedin.d2.rangedPartitionProperties");
        }

        public rangedPartitionProperties getRangedPartitionProperties() {
            return (rangedPartitionProperties)this.obtainWrapped(MEMBER_RangedPartitionProperties, rangedPartitionProperties.class, "com.linkedin.d2.rangedPartitionProperties");
        }

        public void setRangedPartitionProperties(rangedPartitionProperties value) {
            this.selectWrapped(MEMBER_RangedPartitionProperties, rangedPartitionProperties.class, "com.linkedin.d2.rangedPartitionProperties", (DataTemplate)value);
        }

        public static PartitionTypeSpecificData create(hashAlgorithm value) {
            PartitionTypeSpecificData newUnion = new PartitionTypeSpecificData();
            newUnion.setHashAlgorithm(value);
            return newUnion;
        }

        public boolean isHashAlgorithm() {
            return this.memberIs("com.linkedin.d2.hashAlgorithm");
        }

        public hashAlgorithm getHashAlgorithm() {
            return (hashAlgorithm)((Object)this.obtainDirect(MEMBER_HashAlgorithm, hashAlgorithm.class, "com.linkedin.d2.hashAlgorithm"));
        }

        public void setHashAlgorithm(hashAlgorithm value) {
            this.selectDirect(MEMBER_HashAlgorithm, hashAlgorithm.class, String.class, "com.linkedin.d2.hashAlgorithm", (Object)value);
        }

        public PartitionTypeSpecificData clone() throws CloneNotSupportedException {
            return (PartitionTypeSpecificData)super.clone();
        }

        public PartitionTypeSpecificData copy() throws CloneNotSupportedException {
            return (PartitionTypeSpecificData)super.copy();
        }

        public static class Fields
        extends PathSpec {
            public Fields(List<String> path, String name) {
                super(path, name);
            }

            public Fields() {
            }

            public rangedPartitionProperties.Fields RangedPartitionProperties() {
                return new rangedPartitionProperties.Fields(this.getPathComponents(), "com.linkedin.d2.rangedPartitionProperties");
            }

            public PathSpec HashAlgorithm() {
                return new PathSpec(this.getPathComponents(), "com.linkedin.d2.hashAlgorithm");
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec partitionKeyRegex() {
            return new PathSpec(this.getPathComponents(), "partitionKeyRegex");
        }

        public PathSpec partitionCount() {
            return new PathSpec(this.getPathComponents(), "partitionCount");
        }

        public PartitionTypeSpecificData.Fields partitionTypeSpecificData() {
            return new PartitionTypeSpecificData.Fields(this.getPathComponents(), "partitionTypeSpecificData");
        }
    }
}

