/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace.codec.json;

import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.codec.TraceCodec;
import com.linkedin.parseq.trace.codec.json.JsonTraceDeserializer;
import com.linkedin.parseq.trace.codec.json.JsonTraceSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonTraceCodec
implements TraceCodec {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    static final String TRACES = "traces";
    static final String RELATIONSHIPS = "relationships";
    static final String PLAN_ID = "planId";
    static final String PLAN_CLASS = "planClass";
    static final String TRACE_ID = "id";
    static final String TRACE_HIDDEN = "hidden";
    static final String TRACE_SYSTEM_HIDDEN = "systemHidden";
    static final String TRACE_NAME = "name";
    static final String TRACE_VALUE = "value";
    static final String TRACE_RESULT_TYPE = "resultType";
    static final String TRACE_START_NANOS = "startNanos";
    static final String TRACE_PENDING_NANOS = "pendingNanos";
    static final String TRACE_END_NANOS = "endNanos";
    static final String TRACE_ATTRIBUTES = "attributes";
    static final String TRACE_ATTRIBUTE_KEY = "key";
    static final String TRACE_ATTRIBUTE_VALUE = "value";
    static final String RELATIONSHIP_RELATIONSHIP = "relationship";
    static final String RELATIONSHIP_FROM = "from";
    static final String RELATIONSHIP_TO = "to";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public Trace decode(InputStream inputStream) throws IOException {
        JsonParser parser = OBJECT_MAPPER.getJsonFactory().createJsonParser(inputStream);
        JsonNode rootNode = OBJECT_MAPPER.readTree(parser);
        return JsonTraceDeserializer.deserialize(rootNode);
    }

    @Override
    public Trace decode(String traceStr) throws IOException {
        return this.decode(new ByteArrayInputStream(traceStr.getBytes(DEFAULT_CHARSET.name())));
    }

    @Override
    public void encode(Trace trace, OutputStream outputStream) throws IOException {
        JsonGenerator generator = OBJECT_MAPPER.getJsonFactory().createJsonGenerator(outputStream, JsonEncoding.UTF8);
        JsonTraceSerializer.serialize(trace, generator);
        generator.flush();
    }

    @Override
    public String encode(Trace trace) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(trace, baos);
        return new String(baos.toByteArray(), DEFAULT_CHARSET);
    }
}

