/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace;

import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.trace.ResultType;
import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.ShallowTraceImp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ShallowTraceBuilder {
    private final Long _id;
    private volatile String _name;
    private volatile boolean _hidden;
    private volatile String _value;
    private volatile ResultType _resultType;
    private volatile Long _startNanos;
    private volatile Long _pendingNanos;
    private volatile Long _endNanos;
    private volatile boolean _systemHidden;
    private Map<String, String> _attributes;

    public ShallowTraceBuilder(Long id) {
        this._id = id;
    }

    public ShallowTraceBuilder(ShallowTrace shallowTrace) {
        this(shallowTrace.getId());
        this.setResultType(shallowTrace.getResultType());
        this.setName(shallowTrace.getName());
        this.setValue(shallowTrace.getValue());
        this.setStartNanos(shallowTrace.getStartNanos());
        this.setPendingNanos(shallowTrace.getPendingNanos());
        this.setEndNanos(shallowTrace.getEndNanos());
        this.setHidden(shallowTrace.getHidden());
        this.setSystemHidden(shallowTrace.getSystemHidden());
        Map<String, String> attributes = shallowTrace.getAttributes();
        if (!attributes.isEmpty()) {
            this._attributes = new HashMap<String, String>();
            this._attributes.putAll(attributes);
        }
    }

    public boolean getHidden() {
        return this._hidden;
    }

    public ShallowTraceBuilder setHidden(boolean hidden) {
        this._hidden = hidden;
        return this;
    }

    public boolean getSystemHidden() {
        return this._systemHidden;
    }

    public ShallowTraceBuilder setSystemHidden(boolean systemHidden) {
        this._systemHidden = systemHidden;
        return this;
    }

    public ShallowTraceBuilder setName(String name) {
        ArgumentUtil.requireNotNull(name, "name");
        this._name = name;
        return this;
    }

    public ShallowTraceBuilder setValue(String value) {
        this._value = value;
        return this;
    }

    public ShallowTraceBuilder setResultType(ResultType resultType) {
        ArgumentUtil.requireNotNull((Object)resultType, "resultType");
        if (resultType != ResultType.UNFINISHED) {
            long nanoTime = System.nanoTime();
            if (this._startNanos == null) {
                this._startNanos = nanoTime;
            }
            if (this._pendingNanos == null) {
                this._pendingNanos = nanoTime;
            }
            if (this._endNanos == null) {
                this._endNanos = nanoTime;
            }
        }
        this._resultType = resultType;
        return this;
    }

    public ShallowTraceBuilder setStartNanos(Long startNanos) {
        this._startNanos = startNanos;
        return this;
    }

    public ShallowTraceBuilder setPendingNanos(Long pendingNanos) {
        this._pendingNanos = pendingNanos;
        return this;
    }

    public ShallowTraceBuilder setEndNanos(Long endNanos) {
        this._endNanos = endNanos;
        return this;
    }

    public Long getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public ResultType getResultType() {
        return this._resultType;
    }

    public Long getStartNanos() {
        return this._startNanos;
    }

    public Long getPendingNanos() {
        return this._pendingNanos;
    }

    public Long getEndNanos() {
        return this._endNanos;
    }

    public synchronized Map<String, String> getAttributes() {
        if (this._attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._attributes);
    }

    public synchronized ShallowTraceBuilder addAttribute(String key, String value) {
        ArgumentUtil.requireNotNull(key, "key");
        ArgumentUtil.requireNotNull(value, "value");
        if (this._attributes == null) {
            this._attributes = new HashMap<String, String>();
        }
        this._attributes.put(key, value);
        return this;
    }

    public synchronized ShallowTraceBuilder removeAttribute(String key) {
        ArgumentUtil.requireNotNull(key, "key");
        if (this._attributes != null) {
            this._attributes.remove(key);
            if (this._attributes.isEmpty()) {
                this._attributes = null;
            }
        }
        return this;
    }

    public ShallowTraceImp build() {
        String value = this._value;
        ResultType resultType = this._resultType;
        Long endNanos = this._endNanos;
        Long pendingNanos = this._pendingNanos;
        Long startNanos = this._startNanos;
        if (resultType == ResultType.UNFINISHED && startNanos != null && endNanos == null) {
            endNanos = System.nanoTime();
        }
        return new ShallowTraceImp(this._id, this._name, this._hidden, this._systemHidden, resultType, value, startNanos, pendingNanos, endNanos, this.getAttributes());
    }
}

