/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.promise;

import com.linkedin.parseq.function.Function1;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromisePropagator;
import com.linkedin.parseq.promise.Settable;

public class PromiseTransformer<S, T>
implements PromisePropagator<S, T> {
    private final Function1<? super S, ? extends T> _transform;
    private static final PromiseTransformer IDENTITY = new PromiseTransformer(Function1.identity());

    public PromiseTransformer(Function1<? super S, ? extends T> transform) {
        this._transform = transform;
    }

    @Override
    public <R> PromisePropagator<S, R> compose(PromisePropagator<T, R> propagator) {
        if (propagator instanceof PromiseTransformer) {
            return this.doCompose((PromiseTransformer)propagator);
        }
        return PromisePropagator.super.compose(propagator);
    }

    private <R> PromiseTransformer<S, R> doCompose(PromiseTransformer<T, R> propagator) {
        return new PromiseTransformer<S, T>(this._transform.andThen(propagator._transform));
    }

    @Override
    public void accept(Promise<S> src, Settable<T> dst) {
        if (src.isFailed()) {
            dst.fail(src.getError());
        } else {
            try {
                dst.done(this._transform.apply(src.get()));
            }
            catch (Throwable t) {
                dst.fail(t);
            }
        }
    }

    public static <R> PromiseTransformer<R, R> identity() {
        return IDENTITY;
    }
}

