/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.promise;

import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.SettablePromise;
import java.util.concurrent.atomic.AtomicInteger;

public class CountDownPromiseListener<T>
implements PromiseListener<T> {
    private final AtomicInteger _counter;
    private final SettablePromise<T> _promise;
    private final T _value;

    public CountDownPromiseListener(int count, SettablePromise<T> promise, T value) {
        this._counter = new AtomicInteger(count);
        this._promise = promise;
        this._value = value;
    }

    @Override
    public void onResolved(Promise<T> resolvedPromise) {
        if (this._counter.decrementAndGet() == 0) {
            this._promise.done(this._value);
        }
    }
}

