/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.idlgen;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.javadoc.Main;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RestLiDoclet {
    private static RestLiDoclet _currentDocLet = null;
    private final DocInfo _docInfo;

    public static synchronized RestLiDoclet generateDoclet(String programName, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter, String[] args) {
        int javadocRetCode = Main.execute((String)programName, (PrintWriter)errWriter, (PrintWriter)warnWriter, (PrintWriter)noticeWriter, (String)RestLiDoclet.class.getName(), (String[])args);
        if (javadocRetCode != 0) {
            throw new IllegalArgumentException("Javadoc failed with return code " + javadocRetCode);
        }
        return _currentDocLet;
    }

    public static boolean start(RootDoc root) {
        DocInfo docInfo = new DocInfo();
        for (ClassDoc classDoc : root.classes()) {
            docInfo.setClassDoc(classDoc.qualifiedName(), classDoc);
            for (MethodDoc methodDoc : classDoc.methods()) {
                docInfo.setMethodDoc(MethodIdentity.create(methodDoc), methodDoc);
            }
        }
        _currentDocLet = new RestLiDoclet(docInfo);
        return true;
    }

    private RestLiDoclet(DocInfo docInfo) {
        this._docInfo = docInfo;
    }

    public ClassDoc getClassDoc(Class<?> resourceClass) {
        return this._docInfo.getClassDoc(resourceClass.getCanonicalName());
    }

    public MethodDoc getMethodDoc(Method method) {
        MethodIdentity methodId = MethodIdentity.create(method);
        return this._docInfo.getMethodDoc(methodId);
    }

    private static class MethodIdentity {
        private final String _methodQualifiedName;
        private final List<String> _parameterTypeNames;

        public static MethodIdentity create(Method method) {
            ArrayList<String> parameterTypeNames = new ArrayList<String>();
            for (Class<?> paramClass : method.getParameterTypes()) {
                parameterTypeNames.add(paramClass.getCanonicalName());
            }
            return new MethodIdentity(method.getDeclaringClass().getName() + "." + method.getName(), parameterTypeNames);
        }

        public static MethodIdentity create(MethodDoc method) {
            ArrayList<String> parameterTypeNames = new ArrayList<String>();
            for (Parameter param : method.parameters()) {
                Type type = param.type();
                parameterTypeNames.add(type.qualifiedTypeName() + type.dimension());
            }
            return new MethodIdentity(method.qualifiedName(), parameterTypeNames);
        }

        private MethodIdentity(String methodQualifiedName, List<String> parameterTypeNames) {
            this._methodQualifiedName = methodQualifiedName;
            this._parameterTypeNames = parameterTypeNames;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 29).append((Object)this._methodQualifiedName).append(this._parameterTypeNames).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodIdentity other = (MethodIdentity)obj;
            return new EqualsBuilder().append((Object)this._methodQualifiedName, (Object)other._methodQualifiedName).append(this._parameterTypeNames, other._parameterTypeNames).isEquals();
        }
    }

    private static class DocInfo {
        private final Map<String, ClassDoc> _classNameToClassDoc = new HashMap<String, ClassDoc>();
        private final Map<MethodIdentity, MethodDoc> _methodIdToMethodDoc = new HashMap<MethodIdentity, MethodDoc>();

        private DocInfo() {
        }

        public ClassDoc getClassDoc(String className) {
            return this._classNameToClassDoc.get(className);
        }

        public MethodDoc getMethodDoc(MethodIdentity methodId) {
            return this._methodIdToMethodDoc.get(methodId);
        }

        public void setClassDoc(String className, ClassDoc classDoc) {
            this._classNameToClassDoc.put(className, classDoc);
        }

        public void setMethodDoc(MethodIdentity methodId, MethodDoc methodDoc) {
            this._methodIdToMethodDoc.put(methodId, methodDoc);
        }
    }
}

