/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.util.None;
import com.linkedin.data.ByteString;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import com.linkedin.r2.transport.http.client.ChannelPoolStreamHandler;
import com.linkedin.r2.util.Timeout;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RAPResponseDecoder
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = LoggerFactory.getLogger(RAPResponseDecoder.class);
    public static final AttributeKey<Timeout<None>> TIMEOUT_ATTR_KEY = AttributeKey.valueOf((String)"TimeoutExecutor");
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final int BUFFER_HIGH_WATER_MARK = 24576;
    private static final int BUFFER_LOW_WATER_MARK = 8192;
    private final long _maxContentLength;
    private TimeoutBufferedWriter _chunkedMessageWriter;
    boolean _shouldCloseConnection;

    RAPResponseDecoder(long maxContentLength) {
        this._maxContentLength = maxContentLength;
    }

    protected void channelRead0(final ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpResponse) {
            Timeout timeout;
            HttpResponse m = (HttpResponse)msg;
            boolean bl = this._shouldCloseConnection = !HttpUtil.isKeepAlive((HttpMessage)m);
            if (HttpUtil.is100ContinueExpected((HttpMessage)m)) {
                ctx.writeAndFlush((Object)CONTINUE).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            ctx.fireExceptionCaught(future.cause());
                        }
                    }
                });
            }
            if (!m.decoderResult().isSuccess()) {
                ctx.fireExceptionCaught(m.decoderResult().cause());
                return;
            }
            if (HttpUtil.isTransferEncodingChunked((HttpMessage)m)) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)m, (boolean)false);
            }
            if ((timeout = (Timeout)ctx.channel().attr(TIMEOUT_ATTR_KEY).getAndRemove()) == null) {
                LOG.debug("dropped a response after channel inactive or exception had happened.");
                return;
            }
            TimeoutBufferedWriter writer = new TimeoutBufferedWriter(ctx, this._maxContentLength, 24576, 8192, (Timeout<None>)timeout);
            EntityStream entityStream = EntityStreams.newEntityStream((Writer)writer);
            this._chunkedMessageWriter = writer;
            StreamResponseBuilder builder = new StreamResponseBuilder();
            builder.setStatus(m.status().code());
            for (Map.Entry e : m.headers()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                if (key.equalsIgnoreCase("Set-Cookie")) {
                    builder.addCookie(value);
                    continue;
                }
                builder.unsafeAddHeaderValue(key, value);
            }
            ctx.fireChannelRead((Object)builder.build(entityStream));
        } else if (msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            TimeoutBufferedWriter currentWriter = this._chunkedMessageWriter;
            if (currentWriter == null) {
                throw new IllegalStateException("received " + HttpContent.class.getSimpleName() + " without " + HttpResponse.class.getSimpleName());
            }
            if (!chunk.decoderResult().isSuccess()) {
                this.exceptionCaught(ctx, chunk.decoderResult().cause());
            }
            currentWriter.processHttpChunk(chunk);
            if (chunk instanceof LastHttpContent) {
                this._chunkedMessageWriter = null;
            }
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Timeout timeout = (Timeout)ctx.channel().attr(TIMEOUT_ATTR_KEY).getAndRemove();
        if (timeout != null) {
            timeout.getItem();
        }
        if (this._chunkedMessageWriter != null) {
            this._chunkedMessageWriter.fail(new ClosedChannelException());
            this._chunkedMessageWriter = null;
        }
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Timeout timeout = (Timeout)ctx.channel().attr(TIMEOUT_ATTR_KEY).getAndRemove();
        if (timeout != null) {
            timeout.getItem();
        }
        if (this._chunkedMessageWriter != null) {
            this._chunkedMessageWriter.fail(cause);
            this._chunkedMessageWriter = null;
        }
        ctx.fireExceptionCaught(cause);
    }

    private class TimeoutBufferedWriter
    implements Writer {
        private final ChannelHandlerContext _ctx;
        private final long _maxContentLength;
        private final int _highWaterMark;
        private final int _lowWaterMark;
        private WriteHandle _wh;
        private boolean _lastChunkReceived;
        private int _totalBytesWritten;
        private int _bufferedBytes;
        private final List<ByteString> _buffer;
        private final Timeout<None> _timeout;
        private volatile Throwable _failureBeforeInit;

        TimeoutBufferedWriter(final ChannelHandlerContext ctx, long maxContentLength, int highWaterMark, int lowWaterMark, Timeout<None> timeout) {
            this._ctx = ctx;
            this._maxContentLength = maxContentLength;
            this._highWaterMark = highWaterMark;
            this._lowWaterMark = lowWaterMark;
            this._failureBeforeInit = null;
            this._lastChunkReceived = false;
            this._totalBytesWritten = 0;
            this._bufferedBytes = 0;
            this._buffer = new LinkedList<ByteString>();
            Runnable timeoutTask = new Runnable(){

                @Override
                public void run() {
                    TimeoutBufferedWriter.this._ctx.executor().execute(new Runnable(){

                        @Override
                        public void run() {
                            TimeoutException ex = new TimeoutException("Timeout while receiving the response entity.");
                            TimeoutBufferedWriter.this.fail(ex);
                            ctx.fireExceptionCaught((Throwable)ex);
                        }
                    });
                }
            };
            this._timeout = timeout;
            this._timeout.addTimeoutTask(timeoutTask);
        }

        public void onInit(WriteHandle wh) {
            this._wh = wh;
        }

        public void onWritePossible() {
            if (this._failureBeforeInit != null) {
                this.fail(this._failureBeforeInit);
                return;
            }
            if (this._ctx.executor().inEventLoop()) {
                this.doWrite();
            } else {
                this._ctx.executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        TimeoutBufferedWriter.this.doWrite();
                    }
                });
            }
        }

        public void onAbort(Throwable ex) {
            this._timeout.getItem();
            this._ctx.fireChannelRead(ChannelPoolStreamHandler.CHANNEL_DESTROY_SIGNAL);
        }

        public void processHttpChunk(HttpContent chunk) throws TooLongFrameException {
            if ((long)(chunk.content().readableBytes() + this._totalBytesWritten) > this._maxContentLength) {
                TooLongFrameException ex = new TooLongFrameException("HTTP content length exceeded " + this._maxContentLength + " bytes.");
                this.fail((Throwable)ex);
                RAPResponseDecoder.this._chunkedMessageWriter = null;
                throw ex;
            }
            if (chunk.content().isReadable()) {
                ByteString data;
                ByteBuf rawData = chunk.content();
                ByteBufInputStream is = new ByteBufInputStream(rawData);
                try {
                    data = ByteString.read((InputStream)is, (int)rawData.readableBytes());
                }
                catch (IOException ex) {
                    this.fail(ex);
                    return;
                }
                this._buffer.add(data);
                this._bufferedBytes += data.length();
                if (this._bufferedBytes > this._highWaterMark && this._ctx.channel().config().isAutoRead()) {
                    this._ctx.channel().config().setAutoRead(false);
                }
            }
            if (chunk instanceof LastHttpContent) {
                this._lastChunkReceived = true;
            }
            if (this._wh != null) {
                this.doWrite();
            }
        }

        public void fail(Throwable ex) {
            this._timeout.getItem();
            if (this._wh != null) {
                this._wh.error((Throwable)new RemoteInvocationException(ex));
            } else {
                this._failureBeforeInit = ex;
            }
        }

        private void doWrite() {
            while (this._wh.remaining() > 0) {
                if (!this._buffer.isEmpty()) {
                    ByteString data = this._buffer.remove(0);
                    this._wh.write(data);
                    this._bufferedBytes -= data.length();
                    this._totalBytesWritten += data.length();
                    if (this._ctx.channel().config().isAutoRead() || this._bufferedBytes >= this._lowWaterMark) continue;
                    this._ctx.channel().config().setAutoRead(true);
                    continue;
                }
                if (!this._lastChunkReceived) break;
                this._wh.done();
                this._timeout.getItem();
                if (RAPResponseDecoder.this._shouldCloseConnection) {
                    this._ctx.fireChannelRead(ChannelPoolStreamHandler.CHANNEL_DESTROY_SIGNAL);
                    break;
                }
                this._ctx.fireChannelRead(ChannelPoolStreamHandler.CHANNEL_RELEASE_SIGNAL);
                break;
            }
        }
    }
}

