/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.transport.common.bridge.common.RequestWithCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.AsyncPoolHandle;
import com.linkedin.r2.transport.http.client.Http2ClientPipelineInitializer;
import com.linkedin.r2.transport.http.client.NettyRequestAdapter;
import com.linkedin.r2.transport.http.client.TimeoutAsyncPoolHandle;
import com.linkedin.r2.transport.http.client.TimeoutTransportCallback;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2StreamCodec
extends Http2ConnectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http2StreamCodec.class);
    private static final int NO_PADDING = 0;
    private static final int NO_DATA = 0;
    private static final boolean NOT_END_STREAM = false;
    private static final boolean END_STREAM = true;

    protected Http2StreamCodec(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof RequestWithCallback)) {
            ctx.write(msg, promise);
            return;
        }
        Request request = ((RequestWithCallback)msg).request();
        Http2ConnectionEncoder encoder = this.encoder();
        int streamId = this.connection().local().incrementAndGetNextStreamId();
        if (request instanceof StreamRequest) {
            LOG.debug("Writing StreamRequest...");
            StreamRequest streamRequest = (StreamRequest)request;
            Http2Headers http2Headers = NettyRequestAdapter.toHttp2Headers(streamRequest);
            BufferedReader reader = new BufferedReader(ctx, encoder, streamId, ((RequestWithCallback)msg).handle());
            streamRequest.getEntityStream().setReader((Reader)reader);
            encoder.writeHeaders(ctx, streamId, http2Headers, 0, false, promise).addListener(future -> reader.request());
            LOG.debug("Sent HTTP/2 HEADERS frame, stream={}, end={}, headers={}, padding={}bytes", new Object[]{streamId, false, http2Headers.size(), 0});
        } else if (request instanceof RestRequest) {
            LOG.debug("Writing RestRequest...");
            PromiseCombiner promiseCombiner = new PromiseCombiner();
            ChannelPromise headersPromise = ctx.channel().newPromise();
            ChannelPromise dataPromise = ctx.channel().newPromise();
            promiseCombiner.add((Promise)headersPromise);
            promiseCombiner.add((Promise)dataPromise);
            promiseCombiner.finish((Promise)promise);
            RestRequest restRequest = (RestRequest)request;
            Http2Headers headers = NettyRequestAdapter.toHttp2Headers(restRequest);
            encoder.writeHeaders(ctx, streamId, headers, 0, false, headersPromise);
            LOG.debug("Sent HTTP/2 HEADERS frame, stream={}, end={}, headers={}, padding={}bytes", new Object[]{streamId, false, headers.size(), 0});
            ByteBuf data = Unpooled.wrappedBuffer((ByteBuffer)restRequest.getEntity().asByteBuffer());
            encoder.writeData(ctx, streamId, data, 0, true, dataPromise);
            LOG.debug("Sent HTTP/2 DATA frame, stream={}, end={}, data={}bytes, padding={}bytes", new Object[]{streamId, true, data.readableBytes(), 0});
        } else {
            ctx.fireChannelRead((Object)((RequestWithCallback)msg).handle());
            throw new IllegalArgumentException("Request is neither StreamRequest or RestRequest");
        }
        TransportCallback callback = ((RequestWithCallback)msg).callback();
        Http2Connection.PropertyKey callbackKey = (Http2Connection.PropertyKey)ctx.channel().attr(Http2ClientPipelineInitializer.CALLBACK_ATTR_KEY).get();
        this.connection().stream(streamId).setProperty(callbackKey, (Object)callback);
        AsyncPoolHandle handle = ((RequestWithCallback)msg).handle();
        Http2Connection.PropertyKey handleKey = (Http2Connection.PropertyKey)ctx.channel().attr(Http2ClientPipelineInitializer.CHANNEL_POOL_HANDLE_ATTR_KEY).get();
        this.connection().stream(streamId).setProperty(handleKey, (Object)handle);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        this.onError(ctx, cause);
    }

    public void onError(ChannelHandlerContext ctx, Throwable cause) {
        super.onError(ctx, cause);
        Http2Exception http2Exception = Http2CodecUtil.getEmbeddedHttp2Exception((Throwable)cause);
        if (http2Exception == null) {
            this.doHandleConnectionException(ctx, cause);
        } else if (http2Exception instanceof Http2Exception.StreamException) {
            Http2Exception.StreamException streamException = (Http2Exception.StreamException)http2Exception;
            this.doHandleStreamException(this.connection().stream(streamException.streamId()), ctx, (Throwable)streamException);
        } else if (http2Exception instanceof Http2Exception.CompositeStreamException) {
            Http2Exception.CompositeStreamException compositException = (Http2Exception.CompositeStreamException)http2Exception;
            for (Http2Exception.StreamException streamException : compositException) {
                this.doHandleStreamException(this.connection().stream(streamException.streamId()), ctx, (Throwable)streamException);
            }
        } else {
            this.doHandleConnectionException(ctx, http2Exception);
        }
    }

    private void doHandleStreamException(Http2Stream stream, ChannelHandlerContext ctx, Throwable cause) {
        TimeoutAsyncPoolHandle handle;
        Http2Connection.PropertyKey callbackKey = (Http2Connection.PropertyKey)ctx.channel().attr(Http2ClientPipelineInitializer.CALLBACK_ATTR_KEY).get();
        Http2Connection.PropertyKey handleKey = (Http2Connection.PropertyKey)ctx.channel().attr(Http2ClientPipelineInitializer.CHANNEL_POOL_HANDLE_ATTR_KEY).get();
        TimeoutTransportCallback callback = (TimeoutTransportCallback)stream.removeProperty(callbackKey);
        if (callback != null) {
            callback.onResponse(TransportResponseImpl.error((Throwable)cause, Collections.emptyMap()));
        }
        if ((handle = (TimeoutAsyncPoolHandle)stream.removeProperty(handleKey)) != null) {
            ctx.fireChannelRead((Object)handle.error());
        }
    }

    private void doHandleConnectionException(ChannelHandlerContext ctx, Throwable cause) {
        try {
            this.connection().forEachActiveStream(stream -> {
                this.doHandleStreamException(stream, ctx, cause);
                return true;
            });
        }
        catch (Http2Exception e) {
            LOG.error("Encountered exception while invoking request callbacks with errors", (Throwable)e);
            super.onError(ctx, cause);
        }
    }

    private class BufferedReader
    implements Reader {
        private static final int MAX_BUFFERED_CHUNKS = 10;
        private static final int FLUSH_THRESHOLD = 8192;
        private final int _streamId;
        private final ChannelHandlerContext _ctx;
        private final Http2ConnectionEncoder _encoder;
        private final AsyncPoolHandle<?> _poolHandle;
        private volatile ReadHandle _readHandle;
        private int _notFlushedBytes;
        private int _notFlushedChunks;

        BufferedReader(ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, int streamId, AsyncPoolHandle<?> poolHandle) {
            this._streamId = streamId;
            this._ctx = ctx;
            this._encoder = encoder;
            this._poolHandle = poolHandle;
            this._notFlushedBytes = 0;
            this._notFlushedChunks = 0;
        }

        public void onInit(ReadHandle rh) {
            this._readHandle = rh;
        }

        public void onDataAvailable(ByteString data) {
            ByteBuf content = Unpooled.wrappedBuffer((ByteBuffer)data.asByteBuffer());
            this._encoder.writeData(this._ctx, this._streamId, content, 0, false, this._ctx.channel().newPromise()).addListener(future -> this._readHandle.request(1));
            LOG.debug("Sent HTTP/2 DATA frame, stream={}, end={}, data={}bytes, padding={}bytes", new Object[]{this._streamId, false, content.readableBytes(), 0});
            this._notFlushedBytes += data.length();
            ++this._notFlushedChunks;
            if (this._notFlushedBytes >= 8192 || this._notFlushedChunks == 10) {
                this.flush();
                this._notFlushedBytes = 0;
                this._notFlushedChunks = 0;
            }
        }

        public void onDone() {
            this._encoder.writeData(this._ctx, this._streamId, Unpooled.EMPTY_BUFFER, 0, true, this._ctx.channel().voidPromise());
            LOG.debug("Sent HTTP/2 DATA frame, stream={}, end={}, data={}bytes, padding={}bytes", new Object[]{this._streamId, true, 0, 0});
            this.flush();
        }

        public void onError(Throwable cause) {
            Http2StreamCodec.this.resetStream(this._ctx, this._streamId, Http2Error.CANCEL.code(), this._ctx.newPromise());
            this._ctx.fireChannelRead(this._poolHandle);
        }

        private void request() {
            this._readHandle.request(10);
        }

        private void flush() {
            try {
                this._encoder.flowController().writePendingBytes();
            }
            catch (Http2Exception e) {
                Http2StreamCodec.this.onError(this._ctx, e);
            }
            finally {
                this._ctx.flush();
            }
        }
    }
}

