/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.util.StringUtils;

public class StatsTask
extends Task<StatsWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(StatsTask.class);
    private Table table;
    private List<LinkedHashMap<String, String>> dpPartSpecs = null;

    @Override
    protected void receiveFeed(Task.FeedType feedType, Object feedValue) {
        if (feedType == Task.FeedType.DYNAMIC_PARTITIONS) {
            assert (feedValue instanceof List);
            this.dpPartSpecs = (List)feedValue;
        }
    }

    @Override
    public int execute(DriverContext driverContext) {
        LOG.info((Object)"Executing stats task");
        int workComponentsPresent = 0;
        if (((StatsWork)this.work).getLoadTableDesc() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        if (((StatsWork)this.work).getTableSpecs() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        if (((StatsWork)this.work).getLoadFileDesc() != null) {
            workComponentsPresent = (short)(workComponentsPresent + 1);
        }
        assert (workComponentsPresent == 1);
        String tableName = "";
        try {
            tableName = ((StatsWork)this.work).getLoadTableDesc() != null ? ((StatsWork)this.work).getLoadTableDesc().getTable().getTableName() : (((StatsWork)this.work).getTableSpecs() != null ? ((StatsWork)this.work).getTableSpecs().tableName : ((StatsWork)this.work).getLoadFileDesc().getDestinationCreateTable());
            this.table = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            LOG.error((Object)("Cannot get table " + tableName), (Throwable)e);
            this.console.printError("Cannot get table " + tableName, e.toString());
        }
        return this.aggregateStats();
    }

    @Override
    public StageType getType() {
        return StageType.STATS;
    }

    @Override
    public String getName() {
        return "STATS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int aggregateStats() {
        StatsAggregator statsAggregator = null;
        int ret = 0;
        try {
            Warehouse wh = new Warehouse((Configuration)this.conf);
            if (!((StatsWork)this.getWork()).getNoStatsAggregator() && !((StatsWork)this.getWork()).isNoScanAnalyzeCommand()) {
                try {
                    statsAggregator = this.createStatsAggregator(this.conf);
                }
                catch (HiveException e) {
                    if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
                        throw e;
                    }
                    this.console.printError(ErrorMsg.STATS_SKIPPING_BY_ERROR.getErrorCodedMsg(e.toString()));
                }
            }
            List<Partition> partitions = this.getPartitionsList();
            boolean atomic = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_ATOMIC);
            String tableFullName = this.table.getDbName() + "." + this.table.getTableName();
            int maxPrefixLength = StatsFactory.getMaxPrefixLength((Configuration)this.conf);
            boolean taskIndependent = statsAggregator instanceof StatsCollectionTaskIndependent;
            if (partitions == null) {
                org.apache.hadoop.hive.metastore.api.Table tTable = this.table.getTTable();
                Map parameters = tTable.getParameters();
                if (!this.existStats(parameters) && atomic) {
                    int n = 0;
                    return n;
                }
                if (((StatsWork)this.work).isClearAggregatorStats()) {
                    this.clearStats(parameters);
                }
                if (statsAggregator != null) {
                    String prefix = this.getAggregationPrefix(taskIndependent, this.table, null);
                    this.updateStats(statsAggregator, parameters, prefix, maxPrefixLength, atomic);
                }
                this.updateQuickStats(wh, parameters, tTable.getSd());
                parameters.put("STATS_GENERATED_VIA_STATS_TASK", "true");
                this.db.alterTable(tableFullName, new Table(tTable));
                this.console.printInfo("Table " + tableFullName + " stats: [" + this.toString(parameters) + ']');
            } else {
                ArrayList<Partition> updates = new ArrayList<Partition>();
                for (Partition partn : partitions) {
                    org.apache.hadoop.hive.metastore.api.Partition tPart = partn.getTPartition();
                    Map parameters = tPart.getParameters();
                    if (!this.existStats(parameters) && atomic) continue;
                    if (((StatsWork)this.work).isClearAggregatorStats()) {
                        this.clearStats(parameters);
                    }
                    if (statsAggregator != null) {
                        String prefix = this.getAggregationPrefix(taskIndependent, this.table, partn);
                        this.updateStats(statsAggregator, parameters, prefix, maxPrefixLength, atomic);
                    }
                    this.updateQuickStats(wh, parameters, tPart.getSd());
                    parameters.put("STATS_GENERATED_VIA_STATS_TASK", "true");
                    updates.add(new Partition(this.table, tPart));
                    this.console.printInfo("Partition " + tableFullName + partn.getSpec() + " stats: [" + this.toString(parameters) + ']');
                }
                if (!updates.isEmpty()) {
                    this.db.alterPartitions(tableFullName, updates);
                }
            }
        }
        catch (Exception e) {
            this.console.printInfo("[Warning] could not update stats.", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
            if (((StatsWork)this.work).isStatsReliable()) {
                ret = 1;
            }
        }
        finally {
            if (statsAggregator != null) {
                statsAggregator.closeConnection();
            }
        }
        return ret;
    }

    private String getAggregationPrefix(boolean counter, Table table, Partition partition) throws MetaException {
        if (!counter && partition == null) {
            return ((StatsWork)this.work).getAggKey();
        }
        StringBuilder prefix = new StringBuilder();
        if (counter) {
            prefix.append(table.getDbName()).append('.').append(table.getTableName());
        } else {
            prefix.append(((StatsWork)this.work).getAggKey());
        }
        if (partition != null) {
            return Utilities.join(prefix.toString(), Warehouse.makePartPath(partition.getSpec()));
        }
        return prefix.toString();
    }

    private StatsAggregator createStatsAggregator(HiveConf conf) throws HiveException {
        String statsImpl = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESTATSDBCLASS);
        StatsFactory factory = StatsFactory.newFactory(statsImpl, (Configuration)conf);
        if (factory == null) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
        }
        StatsPublisher statsPublisher = factory.getStatsPublisher();
        if (!statsPublisher.init((Configuration)conf)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
        }
        Task sourceTask = ((StatsWork)this.getWork()).getSourceTask();
        if (sourceTask == null) {
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_SOURCETASK_NULL.getErrorCodedMsg());
        }
        StatsAggregator statsAggregator = factory.getStatsAggregator();
        if (!statsAggregator.connect((Configuration)conf, sourceTask)) {
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_CONNECTION_ERROR.getErrorCodedMsg(statsImpl));
        }
        return statsAggregator;
    }

    private boolean existStats(Map<String, String> parameters) {
        return parameters.containsKey("numRows") || parameters.containsKey("numFiles") || parameters.containsKey("totalSize") || parameters.containsKey("rawDataSize") || parameters.containsKey("numPartitions");
    }

    private void updateStats(StatsAggregator statsAggregator, Map<String, String> parameters, String prefix, int maxPrefixLength, boolean atomic) throws HiveException {
        String aggKey = Utilities.getHashedStatsPrefix(prefix, maxPrefixLength);
        for (String statType : StatsSetupConst.statsRequireCompute) {
            String value = statsAggregator.aggregateStats(aggKey, statType);
            if (value != null && !value.isEmpty()) {
                String originalValue;
                long longValue = Long.parseLong(value);
                if (((StatsWork)this.work).getLoadTableDesc() != null && !((StatsWork)this.work).getLoadTableDesc().getReplace() && (originalValue = parameters.get(statType)) != null && !originalValue.equals("-1")) {
                    longValue += Long.parseLong(originalValue);
                }
                parameters.put(statType, String.valueOf(longValue));
                continue;
            }
            if (!atomic) continue;
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_MISSED_SOMESTATS, statType);
        }
        statsAggregator.cleanUp(aggKey);
    }

    private void updateQuickStats(Warehouse wh, Map<String, String> parameters, StorageDescriptor desc) throws MetaException {
        FileStatus[] partfileStatus = wh.getFileStatusesForSD(desc);
        MetaStoreUtils.populateQuickStats((FileStatus[])partfileStatus, parameters);
    }

    private void clearStats(Map<String, String> parameters) {
        for (String statType : StatsSetupConst.supportedStats) {
            if (!parameters.containsKey(statType)) continue;
            parameters.put(statType, "0");
        }
    }

    private String toString(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (String statType : StatsSetupConst.supportedStats) {
            String value = parameters.get(statType);
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(statType).append('=').append(value);
        }
        return builder.toString();
    }

    private List<Partition> getPartitionsList() throws HiveException {
        if (((StatsWork)this.work).getLoadFileDesc() != null) {
            return null;
        }
        ArrayList<Partition> list = new ArrayList<Partition>();
        if (((StatsWork)this.work).getTableSpecs() != null) {
            BaseSemanticAnalyzer.tableSpec tblSpec = ((StatsWork)this.work).getTableSpecs();
            this.table = tblSpec.tableHandle;
            if (!this.table.isPartitioned()) {
                return null;
            }
            List<Partition> partitions = tblSpec.partitions;
            if (partitions != null) {
                for (Partition partn : partitions) {
                    list.add(partn);
                }
            }
        } else if (((StatsWork)this.work).getLoadTableDesc() != null) {
            LoadTableDesc tbd = ((StatsWork)this.work).getLoadTableDesc();
            this.table = this.db.getTable(tbd.getTable().getTableName());
            if (!this.table.isPartitioned()) {
                return null;
            }
            DynamicPartitionCtx dpCtx = tbd.getDPCtx();
            if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                if (this.dpPartSpecs != null) {
                    for (LinkedHashMap<String, String> partSpec : this.dpPartSpecs) {
                        Partition partn = this.db.getPartition(this.table, partSpec, false);
                        list.add(partn);
                    }
                }
            } else {
                Partition partn = this.db.getPartition(this.table, tbd.getPartitionSpec(), false);
                list.add(partn);
            }
        }
        return list;
    }
}

