/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveSerDeManager;
import org.apache.hadoop.fs.Path;

@Alpha
public class HiveRegistrationUnit {
    protected final String dbName;
    protected final String tableName;
    protected final List<Column> columns = Lists.newArrayList();
    protected final State props = new State();
    protected final State storageProps = new State();
    protected final State serDeProps = new State();
    protected final Optional<HiveSerDeManager> serDeManager;
    protected Optional<Long> createTime;
    protected Optional<Long> lastAccessTime;
    protected Optional<String> location;
    protected Optional<String> inputFormat;
    protected Optional<String> outputFormat;
    protected Optional<Boolean> isCompressed;
    protected Optional<Integer> numBuckets;
    protected Optional<List<String>> bucketColumns;
    protected Optional<Boolean> isStoredAsSubDirs;
    protected Optional<String> serDeType;

    HiveRegistrationUnit(Builder<?> builder) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)((Builder)builder).dbName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)((Builder)builder).tableName) ? 1 : 0) != 0);
        this.dbName = ((Builder)builder).dbName;
        this.tableName = ((Builder)builder).tableName;
        this.columns.addAll(((Builder)builder).columns);
        this.props.addAll(((Builder)builder).props);
        this.storageProps.addAll(((Builder)builder).storageProps);
        this.serDeProps.addAll(((Builder)builder).serDeProps);
        this.serDeManager = ((Builder)builder).serDeManager;
        this.populateTablePartitionFields(this.props);
        this.populateStorageFields(this.storageProps);
        this.populateSerDeFields(this.serDeProps);
    }

    protected void populateTablePartitionFields(State state) {
        this.createTime = HiveRegistrationUnit.populateField(state, "create.time", new TypeToken<Long>(){});
        this.lastAccessTime = HiveRegistrationUnit.populateField(state, "last.access.time", new TypeToken<Long>(){});
    }

    protected void populateStorageFields(State state) {
        this.location = HiveRegistrationUnit.populateField(state, "location", new TypeToken<String>(){});
        this.inputFormat = HiveRegistrationUnit.populateField(state, "input.format", new TypeToken<String>(){});
        this.outputFormat = HiveRegistrationUnit.populateField(state, "output.format", new TypeToken<String>(){});
        this.isCompressed = HiveRegistrationUnit.populateField(state, "compressed", new TypeToken<Boolean>(){});
        this.numBuckets = HiveRegistrationUnit.populateField(state, "num.buckets", new TypeToken<Integer>(){});
        this.bucketColumns = HiveRegistrationUnit.populateField(state, "bucket.columns", new TypeToken<List<String>>(){});
        this.isStoredAsSubDirs = HiveRegistrationUnit.populateField(state, "stored.as.sub.dirs", new TypeToken<Boolean>(){});
    }

    protected void populateSerDeFields(State state) {
        this.serDeType = HiveRegistrationUnit.populateField(state, "serde.type", new TypeToken<String>(){});
    }

    protected static <T> Optional<T> populateField(State state, String key, TypeToken<T> token) {
        if (state.contains(key)) {
            Optional fieldValue = new TypeToken<Boolean>(){}.isAssignableFrom(token) ? Optional.of((Object)state.getPropAsBoolean(key)) : (new TypeToken<Integer>(){}.isAssignableFrom(token) ? Optional.of((Object)state.getPropAsInt(key)) : (new TypeToken<Long>(){}.isAssignableFrom(token) ? Optional.of((Object)state.getPropAsLong(key)) : (new TypeToken<List<String>>(){}.isAssignableFrom(token) ? Optional.of((Object)state.getPropAsList(key)) : Optional.of((Object)state.getProp(key)))));
            state.removeProp(key);
            return fieldValue;
        }
        return Optional.absent();
    }

    public void setColumns(List<Column> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    public void setProp(String key, Object value) {
        this.props.setProp(key, value);
        this.updateTablePartitionFields(this.props, key, value);
    }

    public void setStorageProp(String key, Object value) {
        this.storageProps.setProp(key, value);
        this.updateStorageFields(this.storageProps, key, value);
    }

    public void setSerDeProp(String key, Object value) {
        this.serDeProps.setProp(key, value);
        this.updateSerDeFields(this.serDeProps, key, value);
    }

    public void setProps(State props) {
        for (String propKey : props.getPropertyNames()) {
            this.setProp(propKey, props.getProp(propKey));
        }
    }

    public void setStorageProps(State storageProps) {
        for (String propKey : storageProps.getPropertyNames()) {
            this.setStorageProp(propKey, storageProps.getProp(propKey));
        }
    }

    public void setSerDeProps(State serdeProps) {
        for (String propKey : serdeProps.getPropertyNames()) {
            this.setSerDeProp(propKey, serdeProps.getProp(propKey));
        }
    }

    protected void updateTablePartitionFields(State state, String key, Object value) {
        boolean isExistingField = true;
        switch (key) {
            case "create.time": {
                this.createTime = Optional.of((Object)((Long)value));
                break;
            }
            case "last.access.time": {
                this.createTime = Optional.of((Object)((Long)value));
                break;
            }
            default: {
                isExistingField = false;
            }
        }
        if (isExistingField) {
            state.removeProp(key);
        }
    }

    protected void updateStorageFields(State state, String key, Object value) {
        boolean isExistingField = true;
        switch (key) {
            case "location": {
                this.location = Optional.of((Object)((String)value));
                break;
            }
            case "input.format": {
                this.inputFormat = Optional.of((Object)((String)value));
                break;
            }
            case "output.format": {
                this.outputFormat = Optional.of((Object)((String)value));
                break;
            }
            case "compressed": {
                this.isCompressed = Optional.of((Object)((Boolean)value));
                break;
            }
            case "num.buckets": {
                this.numBuckets = Optional.of((Object)((Integer)value));
                break;
            }
            case "bucket.columns": {
                this.bucketColumns = Optional.of((Object)Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)((String)value)));
                break;
            }
            case "stored.as.sub.dirs": {
                this.isStoredAsSubDirs = Optional.of((Object)((Boolean)value));
                break;
            }
            default: {
                isExistingField = false;
            }
        }
        if (isExistingField) {
            state.removeProp(key);
        }
    }

    protected void updateSerDeFields(State state, String key, Object value) {
        boolean isExistingField = true;
        switch (key) {
            case "serde.type": {
                this.serDeType = Optional.of((Object)((String)value));
                break;
            }
            default: {
                isExistingField = false;
            }
        }
        if (isExistingField) {
            state.removeProp(key);
        }
    }

    public void setSerDeProps(Path path) throws IOException {
        ((HiveSerDeManager)this.serDeManager.get()).addSerDeProperties(path, this);
    }

    public void setSerDeProps(HiveRegistrationUnit other) throws IOException {
        ((HiveSerDeManager)this.serDeManager.get()).addSerDeProperties(other, this);
    }

    public void setCreateTime(long createTime) {
        this.createTime = Optional.of((Object)createTime);
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = Optional.of((Object)lastAccessTime);
    }

    public void setLocation(String location) {
        this.location = Optional.of((Object)location);
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = Optional.of((Object)inputFormat);
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = Optional.of((Object)outputFormat);
    }

    public void setCompressed(boolean isCompressed) {
        this.isCompressed = Optional.of((Object)isCompressed);
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = Optional.of((Object)numBuckets);
    }

    public void setBucketColumns(List<String> bucketColumns) {
        this.bucketColumns = Optional.of((Object)ImmutableList.copyOf(bucketColumns));
    }

    public void setStoredAsSubDirs(boolean isStoredAsSubDirs) {
        this.isStoredAsSubDirs = Optional.of((Object)isStoredAsSubDirs);
    }

    public void setSerDeType(String serDeType) {
        this.serDeType = Optional.of((Object)serDeType);
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public State getProps() {
        return this.props;
    }

    public State getStorageProps() {
        return this.storageProps;
    }

    public State getSerDeProps() {
        return this.serDeProps;
    }

    public Optional<HiveSerDeManager> getSerDeManager() {
        return this.serDeManager;
    }

    public Optional<Long> getCreateTime() {
        return this.createTime;
    }

    public Optional<Long> getLastAccessTime() {
        return this.lastAccessTime;
    }

    public Optional<String> getLocation() {
        return this.location;
    }

    public Optional<String> getInputFormat() {
        return this.inputFormat;
    }

    public Optional<String> getOutputFormat() {
        return this.outputFormat;
    }

    public Optional<Boolean> getIsCompressed() {
        return this.isCompressed;
    }

    public Optional<Integer> getNumBuckets() {
        return this.numBuckets;
    }

    public Optional<List<String>> getBucketColumns() {
        return this.bucketColumns;
    }

    public Optional<Boolean> getIsStoredAsSubDirs() {
        return this.isStoredAsSubDirs;
    }

    public Optional<String> getSerDeType() {
        return this.serDeType;
    }

    public String toString() {
        return "HiveRegistrationUnit(dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", columns=" + this.getColumns() + ", props=" + this.getProps() + ", storageProps=" + this.getStorageProps() + ", serDeProps=" + this.getSerDeProps() + ", serDeManager=" + this.getSerDeManager() + ", createTime=" + this.getCreateTime() + ", lastAccessTime=" + this.getLastAccessTime() + ", location=" + this.getLocation() + ", inputFormat=" + this.getInputFormat() + ", outputFormat=" + this.getOutputFormat() + ", isCompressed=" + this.getIsCompressed() + ", numBuckets=" + this.getNumBuckets() + ", bucketColumns=" + this.getBucketColumns() + ", isStoredAsSubDirs=" + this.getIsStoredAsSubDirs() + ", serDeType=" + this.getSerDeType() + ")";
    }

    public static class Column {
        private final String name;
        private final String type;
        private final String comment;

        @ConstructorProperties(value={"name", "type", "comment"})
        public Column(String name, String type, String comment) {
            this.name = name;
            this.type = type;
            this.comment = comment;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getComment() {
            return this.comment;
        }
    }

    static abstract class Builder<T extends Builder<?>> {
        private String dbName;
        private String tableName;
        private List<Column> columns = Lists.newArrayList();
        private State props = new State();
        private State storageProps = new State();
        private State serDeProps = new State();
        private Optional<HiveSerDeManager> serDeManager = Optional.absent();

        Builder() {
        }

        public T withDbName(String dbName) {
            this.dbName = dbName;
            return (T)this;
        }

        public T withTableName(String tableName) {
            this.tableName = tableName;
            return (T)this;
        }

        public T withColumns(List<Column> columns) {
            this.columns = columns;
            return (T)this;
        }

        public T withProps(State props) {
            this.props = props;
            return (T)this;
        }

        public T withStorageProps(State storageProps) {
            this.storageProps = storageProps;
            return (T)this;
        }

        public T withSerdeProps(State serDeProps) {
            this.serDeProps = serDeProps;
            return (T)this;
        }

        public T withSerdeManaager(HiveSerDeManager serDeManager) {
            this.serDeManager = Optional.of((Object)serDeManager);
            return (T)this;
        }

        public abstract HiveRegistrationUnit build();
    }
}

