/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;

public class AggregateFilterTransposeRule
extends RelOptRule {
    public static final AggregateFilterTransposeRule INSTANCE = new AggregateFilterTransposeRule();

    private AggregateFilterTransposeRule() {
        super(AggregateFilterTransposeRule.operand(Aggregate.class, AggregateFilterTransposeRule.operand(Filter.class, AggregateFilterTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Filter filter = (Filter)call.rel(1);
        ImmutableBitSet filterColumns = RelOptUtil.InputFinder.bits(filter.getCondition());
        final ImmutableBitSet newGroupSet = aggregate.getGroupSet().union(filterColumns);
        RelNode input = filter.getInput();
        Boolean unique = RelMetadataQuery.areColumnsUnique(input, newGroupSet);
        if (unique != null && unique.booleanValue()) {
            return;
        }
        boolean allColumnsInAggregate = aggregate.getGroupSet().contains(filterColumns);
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), input, false, newGroupSet, null, aggregate.getAggCallList());
        Mappings.TargetMapping mapping = Mappings.target(new Function<Integer, Integer>(){

            public Integer apply(Integer a0) {
                return newGroupSet.indexOf(a0);
            }
        }, input.getRowType().getFieldCount(), newGroupSet.cardinality());
        RexNode newCondition = RexUtil.apply(mapping, filter.getCondition());
        Filter newFilter = filter.copy(filter.getTraitSet(), newAggregate, newCondition);
        if (allColumnsInAggregate && !aggregate.indicator) {
            assert (newGroupSet.equals(aggregate.getGroupSet()));
            call.transformTo(newFilter);
        } else {
            ImmutableBitSet.Builder topGroupSet = ImmutableBitSet.builder();
            for (int c : aggregate.getGroupSet()) {
                topGroupSet.set(newGroupSet.indexOf(c));
            }
            ImmutableList newGroupingSets = null;
            if (aggregate.indicator) {
                ImmutableList.Builder newGroupingSetsBuilder = ImmutableList.builder();
                for (ImmutableBitSet groupingSet : aggregate.getGroupSets()) {
                    ImmutableBitSet.Builder newGroupingSet = ImmutableBitSet.builder();
                    for (int c : groupingSet) {
                        newGroupingSet.set(newGroupSet.indexOf(c));
                    }
                    newGroupingSetsBuilder.add((Object)newGroupingSet.build());
                }
                newGroupingSets = newGroupingSetsBuilder.build();
            }
            ArrayList topAggCallList = Lists.newArrayList();
            int i = newGroupSet.cardinality();
            for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                SqlAggFunction rollup = SubstitutionVisitor.getRollup(aggregateCall.getAggregation());
                if (rollup == null) {
                    return;
                }
                if (aggregateCall.isDistinct()) {
                    return;
                }
                topAggCallList.add(AggregateCall.create(rollup, aggregateCall.isDistinct(), (List<Integer>)ImmutableList.of((Object)i++), -1, aggregateCall.type, aggregateCall.name));
            }
            Aggregate topAggregate = aggregate.copy(aggregate.getTraitSet(), newFilter, aggregate.indicator, topGroupSet.build(), (List<ImmutableBitSet>)newGroupingSets, topAggCallList);
            call.transformTo(topAggregate);
        }
    }
}

