/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.util.LinkedList;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.writer.Batch;

@Alpha
public class BytesBoundedBatch<D>
extends Batch<D> {
    private RecordMemory memory;
    private final long creationTimestamp = System.currentTimeMillis();
    private final long memSizeLimit;
    private final long ttlInMilliSeconds;
    public static final int OVERHEAD_SIZE_IN_BYTES = 15;

    public BytesBoundedBatch(long memSizeLimit, long ttlInMilliSeconds) {
        this.memory = new RecordMemory();
        this.memSizeLimit = memSizeLimit;
        this.ttlInMilliSeconds = ttlInMilliSeconds;
    }

    public boolean isTTLExpire() {
        return System.currentTimeMillis() - this.creationTimestamp >= this.ttlInMilliSeconds;
    }

    private long getInternalSize(D record) {
        return record.toString().length() + 15;
    }

    @Override
    public List<D> getRecords() {
        return this.memory.getRecords();
    }

    @Override
    public boolean hasRoom(D object) {
        return this.memory.hasRoom(object);
    }

    @Override
    public void append(D object) {
        this.memory.append(object);
    }

    @Override
    public int getRecordSizeInByte(D record) {
        return record.toString().length();
    }

    @Override
    public long getCurrentSizeInByte() {
        return this.memory.getByteSize();
    }

    public class RecordMemory {
        private List<D> records = new LinkedList();
        private long byteSize = 0L;

        void append(D record) {
            this.byteSize += BytesBoundedBatch.this.getInternalSize(record);
            this.records.add(record);
        }

        boolean hasRoom(D record) {
            long recordLen = BytesBoundedBatch.this.getInternalSize(record);
            return this.byteSize + recordLen <= BytesBoundedBatch.this.memSizeLimit;
        }

        long getByteSize() {
            return this.byteSize;
        }

        List<D> getRecords() {
            return this.records;
        }
    }
}

