/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.writer;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.FinalState;
import org.apache.gobblin.writer.DataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class InstrumentedDataWriterBase<D>
implements DataWriter<D>,
Instrumentable,
Closeable,
FinalState {
    private static final Logger log = LoggerFactory.getLogger(InstrumentedDataWriterBase.class);
    private final Optional<ScheduledThreadPoolExecutor> writerMetricsUpdater;
    private final boolean instrumentationEnabled;
    private MetricContext metricContext;
    private Optional<Meter> recordsInMeter;
    private Optional<Meter> successfulWritesMeter;
    private Optional<Meter> failedWritesMeter;
    private Optional<Timer> dataWriterTimer;
    private Optional<Meter> recordsWrittenMeter;
    private Optional<Meter> bytesWrittenMeter;
    protected final Closer closer = Closer.create();
    public static final String WRITER_METRICS_UPDATER_INTERVAL = "gobblin.writer.metrics.updater.interval";
    public static final long DEFAULT_WRITER_METRICS_UPDATER_INTERVAL = 30000L;

    public InstrumentedDataWriterBase(State state) {
        this(state, Optional.absent());
    }

    protected InstrumentedDataWriterBase(State state, Optional<Class<?>> classTag) {
        this.instrumentationEnabled = GobblinMetrics.isEnabled((State)state);
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.getMetricContext(state, (Class)classTag.or(this.getClass())));
        if (this.instrumentationEnabled) {
            this.writerMetricsUpdater = Optional.of((Object)InstrumentedDataWriterBase.buildWriterMetricsUpdater());
            this.scheduleWriterMetricsUpdater((ScheduledThreadPoolExecutor)this.writerMetricsUpdater.get(), InstrumentedDataWriterBase.getWriterMetricsUpdaterInterval(state));
        } else {
            this.writerMetricsUpdater = Optional.absent();
        }
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(List<Tag<?>> tags) {
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.newContextFromReferenceContext(this.metricContext, tags, (Optional<String>)Optional.absent()));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(MetricContext context) {
        this.metricContext = context;
        this.regenerateMetrics();
    }

    protected void regenerateMetrics() {
        if (this.isInstrumentationEnabled()) {
            this.recordsInMeter = Optional.of((Object)this.metricContext.meter("gobblin.writer.records.in"));
            this.successfulWritesMeter = Optional.of((Object)this.metricContext.meter("gobblin.writer.successful.writes"));
            this.failedWritesMeter = Optional.of((Object)this.metricContext.meter("gobblin.writer.failed.writes"));
            this.setRecordsWrittenMeter(this.isInstrumentationEnabled());
            this.setBytesWrittenMeter(this.isInstrumentationEnabled());
            this.dataWriterTimer = Optional.of((Object)this.metricContext.timer("gobblin.writer.write.time"));
        } else {
            this.recordsInMeter = Optional.absent();
            this.successfulWritesMeter = Optional.absent();
            this.failedWritesMeter = Optional.absent();
            this.setRecordsWrittenMeter(this.isInstrumentationEnabled());
            this.setBytesWrittenMeter(this.isInstrumentationEnabled());
            this.dataWriterTimer = Optional.absent();
        }
    }

    private synchronized void setRecordsWrittenMeter(boolean isInstrumentationEnabled) {
        this.recordsWrittenMeter = isInstrumentationEnabled ? Optional.of((Object)this.metricContext.meter("gobblin.writer.records.written")) : Optional.absent();
    }

    private synchronized void setBytesWrittenMeter(boolean isInstrumentationEnabled) {
        this.bytesWrittenMeter = isInstrumentationEnabled ? Optional.of((Object)this.metricContext.meter("gobblin.writer.bytes.written")) : Optional.absent();
    }

    @Override
    public List<Tag<?>> generateTags(State state) {
        return Lists.newArrayList();
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return this.instrumentationEnabled;
    }

    public void write(D record) throws IOException {
        if (!this.isInstrumentationEnabled()) {
            this.writeImpl(record);
            return;
        }
        try {
            long startTimeNanos = System.nanoTime();
            this.beforeWrite(record);
            this.writeImpl(record);
            this.onSuccessfulWrite(startTimeNanos);
        }
        catch (IOException exception) {
            this.onException(exception);
            throw exception;
        }
    }

    public void beforeWrite(D record) {
        Instrumented.markMeter(this.recordsInMeter);
    }

    public void onSuccessfulWrite(long startTimeNanos) {
        Instrumented.updateTimer(this.dataWriterTimer, System.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS);
        Instrumented.markMeter(this.successfulWritesMeter);
    }

    public void onException(Exception exception) {
        Instrumented.markMeter(this.failedWritesMeter);
    }

    public abstract void writeImpl(D var1) throws IOException;

    public State getFinalState() {
        return new State();
    }

    @Override
    public void close() throws IOException {
        try {
            this.closer.close();
        }
        finally {
            if (this.writerMetricsUpdater.isPresent()) {
                ExecutorsUtils.shutdownExecutorService((ExecutorService)((ExecutorService)this.writerMetricsUpdater.get()), (Optional)Optional.of((Object)log));
            }
        }
    }

    @Override
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public void commit() throws IOException {
        this.updateRecordsWrittenMeter();
        this.updateBytesWrittenMeter();
    }

    private synchronized void updateRecordsWrittenMeter() {
        if (this.recordsWrittenMeter.isPresent()) {
            ((Meter)this.recordsWrittenMeter.get()).mark(this.recordsWritten() - ((Meter)this.recordsWrittenMeter.get()).getCount());
        }
    }

    private synchronized void updateBytesWrittenMeter() {
        if (this.bytesWrittenMeter.isPresent()) {
            try {
                ((Meter)this.bytesWrittenMeter.get()).mark(this.bytesWritten() - ((Meter)this.bytesWrittenMeter.get()).getCount());
            }
            catch (IOException e) {
                log.error("Cannot get bytesWritten for DataWriter, will not update " + ((Meter)this.bytesWrittenMeter.get()).toString(), (Throwable)e);
            }
        }
    }

    private static ScheduledThreadPoolExecutor buildWriterMetricsUpdater() {
        return new ScheduledThreadPoolExecutor(1, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)log), (Optional)Optional.of((Object)"WriterMetricsUpdater-%d")));
    }

    private static long getWriterMetricsUpdaterInterval(State state) {
        return state.getPropAsLong(WRITER_METRICS_UPDATER_INTERVAL, 30000L);
    }

    private ScheduledFuture<?> scheduleWriterMetricsUpdater(ScheduledThreadPoolExecutor writerMetricsUpdater, long scheduleInterval) {
        return writerMetricsUpdater.scheduleAtFixedRate(new WriterMetricsUpdater(), scheduleInterval, scheduleInterval, TimeUnit.MILLISECONDS);
    }

    private class WriterMetricsUpdater
    implements Runnable {
        private WriterMetricsUpdater() {
        }

        @Override
        public void run() {
            InstrumentedDataWriterBase.this.updateRecordsWrittenMeter();
            InstrumentedDataWriterBase.this.updateBytesWrittenMeter();
        }
    }
}

