/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event.sla;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlaEventSubmitter {
    private static final Logger log = LoggerFactory.getLogger(SlaEventSubmitter.class);
    private EventSubmitter eventSubmitter;
    private String eventName;
    private String datasetUrn;
    private String partition;
    private String originTimestamp;
    private String upstreamTimestamp;
    private String recordCount;
    private String previousPublishTimestamp;
    private String dedupeStatus;
    private String completenessPercentage;
    private String isFirstPublish;
    private String sourceCluster;
    private String destinationCluster;
    private String azkabanExecutionUrl;
    private Map<String, String> additionalMetadata;
    private static final Predicate<String> NOT_NULL_OR_EMPTY_PREDICATE = new Predicate<String>(){

        public boolean apply(String input) {
            return !Strings.isNullOrEmpty((String)input);
        }
    };

    public SlaEventSubmitter(EventSubmitter submitter, String name, Properties props) {
        this.eventName = name;
        this.eventSubmitter = submitter;
        this.datasetUrn = props.getProperty("event.sla.datasetUrn");
        this.datasetUrn = props.containsKey("event.sla.datasetUrn") ? props.getProperty("event.sla.datasetUrn") : props.getProperty("dataset.urn");
        this.partition = props.getProperty("event.sla.partition");
        this.originTimestamp = props.getProperty("event.sla.originTimestamp");
        this.upstreamTimestamp = props.getProperty("event.sla.upstreamTimestamp");
        this.completenessPercentage = props.getProperty("event.sla.completenessPercentage");
        this.recordCount = props.getProperty("event.sla.recordCount");
        this.previousPublishTimestamp = props.getProperty("event.sla.previousPublishTs");
        this.dedupeStatus = props.getProperty("event.sla.dedupeStatus");
        this.isFirstPublish = props.getProperty("event.sla.isFirstPublish");
        this.additionalMetadata = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!StringUtils.startsWith((CharSequence)entry.getKey().toString(), (CharSequence)"event.sla.additionalMetadata.")) continue;
            this.additionalMetadata.put(StringUtils.removeStart((String)entry.getKey().toString(), (String)"event.sla.additionalMetadata."), entry.getValue().toString());
        }
    }

    public void submit() {
        try {
            Preconditions.checkArgument((boolean)Predicates.notNull().apply((Object)this.eventSubmitter), (Object)"EventSubmitter needs to be set");
            Preconditions.checkArgument((boolean)NOT_NULL_OR_EMPTY_PREDICATE.apply((Object)this.eventName), (Object)"Eventname is required");
            Preconditions.checkArgument((boolean)NOT_NULL_OR_EMPTY_PREDICATE.apply((Object)this.datasetUrn), (Object)"DatasetUrn is required");
            this.eventSubmitter.submit(this.eventName, this.buildEventMap());
        }
        catch (IllegalArgumentException e) {
            log.info("Required arguments to submit an SLA event is not available. No Sla event will be submitted. " + e.toString());
        }
    }

    private Map<String, String> buildEventMap() {
        HashMap eventMetadataMap = Maps.newHashMap();
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.datasetUrn"), this.datasetUrn);
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.partition"), this.partition);
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.originTimestamp"), this.originTimestamp);
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.upstreamTimestamp"), this.upstreamTimestamp);
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.completenessPercentage"), this.completenessPercentage);
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.recordCount"), this.recordCount);
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.previousPublishTs"), this.previousPublishTimestamp);
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.dedupeStatus"), this.dedupeStatus);
        eventMetadataMap.put(this.withoutPropertiesPrefix("event.sla.isFirstPublish"), this.isFirstPublish);
        if (this.additionalMetadata != null) {
            eventMetadataMap.putAll(this.additionalMetadata);
        }
        return Maps.newHashMap((Map)Maps.filterValues((Map)eventMetadataMap, NOT_NULL_OR_EMPTY_PREDICATE));
    }

    private String withoutPropertiesPrefix(String key) {
        return StringUtils.removeStart((String)key, (String)"event.sla.");
    }

    public static SlaEventSubmitterBuilder builder() {
        return new SlaEventSubmitterBuilder();
    }

    private SlaEventSubmitter(EventSubmitter eventSubmitter, String eventName, String datasetUrn, String partition, String originTimestamp, String upstreamTimestamp, String recordCount, String previousPublishTimestamp, String dedupeStatus, String completenessPercentage, String isFirstPublish, String sourceCluster, String destinationCluster, String azkabanExecutionUrl, Map<String, String> additionalMetadata) {
        this.eventSubmitter = eventSubmitter;
        this.eventName = eventName;
        this.datasetUrn = datasetUrn;
        this.partition = partition;
        this.originTimestamp = originTimestamp;
        this.upstreamTimestamp = upstreamTimestamp;
        this.recordCount = recordCount;
        this.previousPublishTimestamp = previousPublishTimestamp;
        this.dedupeStatus = dedupeStatus;
        this.completenessPercentage = completenessPercentage;
        this.isFirstPublish = isFirstPublish;
        this.sourceCluster = sourceCluster;
        this.destinationCluster = destinationCluster;
        this.azkabanExecutionUrl = azkabanExecutionUrl;
        this.additionalMetadata = additionalMetadata;
    }

    public static class SlaEventSubmitterBuilder {
        private EventSubmitter eventSubmitter;
        private String eventName;
        private String datasetUrn;
        private String partition;
        private String originTimestamp;
        private String upstreamTimestamp;
        private String recordCount;
        private String previousPublishTimestamp;
        private String dedupeStatus;
        private String completenessPercentage;
        private String isFirstPublish;
        private String sourceCluster;
        private String destinationCluster;
        private String azkabanExecutionUrl;
        private ArrayList<String> additionalMetadata$key;
        private ArrayList<String> additionalMetadata$value;

        SlaEventSubmitterBuilder() {
        }

        public SlaEventSubmitterBuilder eventSubmitter(EventSubmitter eventSubmitter) {
            this.eventSubmitter = eventSubmitter;
            return this;
        }

        public SlaEventSubmitterBuilder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public SlaEventSubmitterBuilder datasetUrn(String datasetUrn) {
            this.datasetUrn = datasetUrn;
            return this;
        }

        public SlaEventSubmitterBuilder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public SlaEventSubmitterBuilder originTimestamp(String originTimestamp) {
            this.originTimestamp = originTimestamp;
            return this;
        }

        public SlaEventSubmitterBuilder upstreamTimestamp(String upstreamTimestamp) {
            this.upstreamTimestamp = upstreamTimestamp;
            return this;
        }

        public SlaEventSubmitterBuilder recordCount(String recordCount) {
            this.recordCount = recordCount;
            return this;
        }

        public SlaEventSubmitterBuilder previousPublishTimestamp(String previousPublishTimestamp) {
            this.previousPublishTimestamp = previousPublishTimestamp;
            return this;
        }

        public SlaEventSubmitterBuilder dedupeStatus(String dedupeStatus) {
            this.dedupeStatus = dedupeStatus;
            return this;
        }

        public SlaEventSubmitterBuilder completenessPercentage(String completenessPercentage) {
            this.completenessPercentage = completenessPercentage;
            return this;
        }

        public SlaEventSubmitterBuilder isFirstPublish(String isFirstPublish) {
            this.isFirstPublish = isFirstPublish;
            return this;
        }

        public SlaEventSubmitterBuilder sourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
            return this;
        }

        public SlaEventSubmitterBuilder destinationCluster(String destinationCluster) {
            this.destinationCluster = destinationCluster;
            return this;
        }

        public SlaEventSubmitterBuilder azkabanExecutionUrl(String azkabanExecutionUrl) {
            this.azkabanExecutionUrl = azkabanExecutionUrl;
            return this;
        }

        public SlaEventSubmitterBuilder additionalMetadata(String additionalMetadataKey, String additionalMetadataValue) {
            if (this.additionalMetadata$key == null) {
                this.additionalMetadata$key = new ArrayList();
                this.additionalMetadata$value = new ArrayList();
            }
            this.additionalMetadata$key.add(additionalMetadataKey);
            this.additionalMetadata$value.add(additionalMetadataValue);
            return this;
        }

        public SlaEventSubmitterBuilder additionalMetadata(Map<? extends String, ? extends String> additionalMetadata) {
            if (this.additionalMetadata$key == null) {
                this.additionalMetadata$key = new ArrayList();
                this.additionalMetadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : additionalMetadata.entrySet()) {
                this.additionalMetadata$key.add($lombokEntry.getKey());
                this.additionalMetadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SlaEventSubmitterBuilder clearAdditionalMetadata() {
            if (this.additionalMetadata$key != null) {
                this.additionalMetadata$key.clear();
                this.additionalMetadata$value.clear();
            }
            return this;
        }

        public SlaEventSubmitter build() {
            Map<Object, Object> additionalMetadata;
            switch (this.additionalMetadata$key == null ? 0 : this.additionalMetadata$key.size()) {
                case 0: {
                    additionalMetadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    additionalMetadata = Collections.singletonMap(this.additionalMetadata$key.get(0), this.additionalMetadata$value.get(0));
                    break;
                }
                default: {
                    additionalMetadata = new LinkedHashMap(this.additionalMetadata$key.size() < 0x40000000 ? 1 + this.additionalMetadata$key.size() + (this.additionalMetadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.additionalMetadata$key.size(); ++$i) {
                        additionalMetadata.put(this.additionalMetadata$key.get($i), this.additionalMetadata$value.get($i));
                    }
                    additionalMetadata = Collections.unmodifiableMap(additionalMetadata);
                }
            }
            return new SlaEventSubmitter(this.eventSubmitter, this.eventName, this.datasetUrn, this.partition, this.originTimestamp, this.upstreamTimestamp, this.recordCount, this.previousPublishTimestamp, this.dedupeStatus, this.completenessPercentage, this.isFirstPublish, this.sourceCluster, this.destinationCluster, this.azkabanExecutionUrl, additionalMetadata);
        }

        public String toString() {
            return "SlaEventSubmitter.SlaEventSubmitterBuilder(eventSubmitter=" + this.eventSubmitter + ", eventName=" + this.eventName + ", datasetUrn=" + this.datasetUrn + ", partition=" + this.partition + ", originTimestamp=" + this.originTimestamp + ", upstreamTimestamp=" + this.upstreamTimestamp + ", recordCount=" + this.recordCount + ", previousPublishTimestamp=" + this.previousPublishTimestamp + ", dedupeStatus=" + this.dedupeStatus + ", completenessPercentage=" + this.completenessPercentage + ", isFirstPublish=" + this.isFirstPublish + ", sourceCluster=" + this.sourceCluster + ", destinationCluster=" + this.destinationCluster + ", azkabanExecutionUrl=" + this.azkabanExecutionUrl + ", additionalMetadata$key=" + this.additionalMetadata$key + ", additionalMetadata$value=" + this.additionalMetadata$value + ")";
        }
    }
}

