/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event;

import java.util.HashMap;
import java.util.Map;

public enum EventName {
    FULL_JOB_EXECUTION("FullJobExecutionTimer"),
    WORK_UNITS_CREATION("WorkUnitsCreationTimer"),
    WORK_UNITS_PREPARATION("WorkUnitsPreparationTimer"),
    JOB_PREPARE("JobPrepareTimer"),
    JOB_START("JobStartTimer"),
    JOB_RUN("JobRunTimer"),
    JOB_COMMIT("JobCommitTimer"),
    JOB_CLEANUP("JobCleanupTimer"),
    JOB_CANCEL("JobCancelTimer"),
    JOB_COMPLETE("JobCompleteTimer"),
    JOB_FAILED("JobFailedTimer"),
    MR_STAGING_DATA_CLEAN("JobMrStagingDataCleanTimer"),
    UNKNOWN("Unknown");

    private static final Map<String, EventName> idMap;
    private String eventId;

    private EventName(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public static EventName getEnumFromEventId(String eventId) {
        EventName eventNameEnum = idMap.get(eventId);
        return eventNameEnum == null ? UNKNOWN : eventNameEnum;
    }

    static {
        idMap = new HashMap<String, EventName>();
        for (EventName value : EventName.values()) {
            idMap.put(value.eventId, value);
        }
    }
}

