/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.google.common.base.Optional;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.ContextAwareHistogram;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.metric.InnerMetric;

public class InnerHistogram
extends Histogram
implements InnerMetric {
    private final String name;
    private final Optional<ContextAwareHistogram> parentHistogram;
    private final WeakReference<ContextAwareHistogram> contextAwareHistogram;

    InnerHistogram(MetricContext context, String name, ContextAwareHistogram contextAwareHistogram) {
        super((Reservoir)new ExponentiallyDecayingReservoir());
        this.name = name;
        Optional<MetricContext> parentContext = context.getParent();
        this.parentHistogram = parentContext.isPresent() ? Optional.fromNullable((Object)((MetricContext)parentContext.get()).contextAwareHistogram(name)) : Optional.absent();
        this.contextAwareHistogram = new WeakReference<ContextAwareHistogram>(contextAwareHistogram);
    }

    InnerHistogram(MetricContext context, String name, ContextAwareHistogram contextAwareHistogram, long windowSize, TimeUnit unit) {
        super((Reservoir)new SlidingTimeWindowReservoir(windowSize, unit));
        this.name = name;
        Optional<MetricContext> parentContext = context.getParent();
        this.parentHistogram = parentContext.isPresent() ? Optional.fromNullable((Object)((MetricContext)parentContext.get()).contextAwareHistogram(name, windowSize, unit)) : Optional.absent();
        this.contextAwareHistogram = new WeakReference<ContextAwareHistogram>(contextAwareHistogram);
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        super.update(value);
        if (this.parentHistogram.isPresent()) {
            ((ContextAwareHistogram)this.parentHistogram.get()).update(value);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ContextAwareMetric getContextAwareMetric() {
        return (ContextAwareMetric)this.contextAwareHistogram.get();
    }
}

