/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import org.apache.gobblin.metrics.MetricContext;

public class Counters<E extends Enum<E>> {
    private ImmutableMap<E, Counter> counters;

    public void initialize(MetricContext metricContext, Class<E> enumClass, Class<?> instrumentedClass) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum e : Arrays.asList(enumClass.getEnumConstants())) {
            builder.put((Object)e, (Object)metricContext.counter(MetricRegistry.name(instrumentedClass, (String[])new String[]{e.name()})));
        }
        this.counters = builder.build();
    }

    public void inc(E e, long n) {
        if (this.counters != null && this.counters.containsKey(e)) {
            ((Counter)this.counters.get(e)).inc(n);
        }
    }

    public long getCount(E e) {
        if (this.counters.containsKey(e)) {
            return ((Counter)this.counters.get(e)).getCount();
        }
        return 0L;
    }
}

