/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.InnerTimer;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.metric.InnerMetric;

public class ContextAwareTimer
extends Timer
implements ContextAwareMetric {
    private final InnerTimer innerTimer;
    private final MetricContext context;

    ContextAwareTimer(MetricContext context, String name) {
        this.innerTimer = new InnerTimer(context, name, this);
        this.context = context;
    }

    ContextAwareTimer(MetricContext context, String name, long windowSize, TimeUnit unit) {
        super((Reservoir)new SlidingTimeWindowReservoir(windowSize, unit));
        this.innerTimer = new InnerTimer(context, name, this, windowSize, unit);
        this.context = context;
    }

    @Override
    public MetricContext getContext() {
        return this.context;
    }

    @Override
    public InnerMetric getInnerMetric() {
        return this.innerTimer;
    }

    public void update(long duration, TimeUnit unit) {
        this.innerTimer.update(duration, unit);
    }

    @Override
    public String getName() {
        return this.innerTimer.getName();
    }

    public ContextAwareMetric getContextAwareMetric() {
        return this.innerTimer.getContextAwareMetric();
    }

    public <T> T time(Callable<T> event) throws Exception {
        return (T)this.innerTimer.time(event);
    }

    public void time(Runnable event) {
        this.innerTimer.time(event);
    }

    public Timer.Context time() {
        return this.innerTimer.time();
    }

    public long getCount() {
        return this.innerTimer.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.innerTimer.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.innerTimer.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.innerTimer.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.innerTimer.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.innerTimer.getSnapshot();
    }
}

