/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.restspec;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.CustomAnnotationContentSchemaMap;
import com.linkedin.restli.restspec.SimpleSchema;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceSchema
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"ResourceSchema\",\"namespace\":\"com.linkedin.restli.restspec\",\"include\":[{\"type\":\"record\",\"name\":\"CustomAnnotationSchema\",\"doc\":\"Custom annotation for idl\",\"fields\":[{\"name\":\"annotations\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"CustomAnnotationContentSchema\",\"doc\":\"Unstructured record that represents arbitrary custom annotations for idl. Actual content is always a map with annotation's overridable member name as key and member value as value\",\"fields\":[]}},\"doc\":\"custom annotation data\",\"optional\":true}]}],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of the resource\"},{\"name\":\"namespace\",\"type\":\"string\",\"doc\":\"namespace of the resource\",\"optional\":true},{\"name\":\"path\",\"type\":\"string\",\"doc\":\"URI template for accessing the resource\"},{\"name\":\"schema\",\"type\":\"string\",\"doc\":\"Java-style fully-qualified class name for entities of this resource\",\"optional\":true},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this resource\",\"optional\":true},{\"name\":\"collection\",\"type\":{\"type\":\"record\",\"name\":\"CollectionSchema\",\"fields\":[{\"name\":\"identifier\",\"type\":{\"type\":\"record\",\"name\":\"IdentifierSchema\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of the identifier\"},{\"name\":\"type\",\"type\":\"string\",\"doc\":\"avro type of the identifier\"},{\"name\":\"params\",\"type\":\"string\",\"doc\":\"avro type of the identifier parameters\",\"optional\":true}]},\"doc\":\"details of the identifier (key) for this collection\"},{\"name\":\"alternativeKeys\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AlternativeKeySchema\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Name of the alternative key\"},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for the alternative key\",\"optional\":true},{\"name\":\"type\",\"type\":\"string\",\"doc\":\"the avro type of the alternative key\"},{\"name\":\"keyCoercer\",\"type\":\"string\",\"doc\":\"the keyCoercer class for this alternative key\"}]}},\"doc\":\"alternative keys\",\"optional\":true},{\"name\":\"supports\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"basic rest.li methods supported by this resource, e.g., create, get, update, delete, batch_get\"},{\"name\":\"methods\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"RestMethodSchema\",\"include\":[\"CustomAnnotationSchema\"],\"fields\":[{\"name\":\"method\",\"type\":\"string\",\"doc\":\"Method type for this rest method\"},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this rest method\",\"optional\":true},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"ParameterSchema\",\"include\":[\"CustomAnnotationSchema\"],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of this parameter\"},{\"name\":\"type\",\"type\":\"string\",\"doc\":\"avro type of this parameter\"},{\"name\":\"items\",\"type\":\"string\",\"doc\":\"type of individual items, if this is an array parameter (used for finder parameters)\",\"optional\":true},{\"name\":\"optional\",\"type\":\"boolean\",\"doc\":\"indicates whether this parameter is optional.  omitted for required parameters\",\"optional\":true},{\"name\":\"default\",\"type\":\"string\",\"doc\":\"indicates the default value for this parameter\",\"optional\":true},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this parameter\",\"optional\":true}]}},\"doc\":\"list of query parameters for this method\",\"optional\":true},{\"name\":\"pagingSupported\",\"type\":\"boolean\",\"doc\":\"Indicates if this rest method has paging support using the start and count parameters\",\"optional\":true}]}},\"doc\":\"details on rest methods supported by this collection\",\"optional\":true},{\"name\":\"finders\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"FinderSchema\",\"include\":[\"CustomAnnotationSchema\"],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of this finder - not required if this is the default finder\",\"optional\":true},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this finder\",\"optional\":true},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":\"ParameterSchema\"},\"doc\":\"list of query parameters for this finder\",\"optional\":true},{\"name\":\"metadata\",\"type\":{\"type\":\"record\",\"name\":\"MetadataSchema\",\"fields\":[{\"name\":\"type\",\"type\":\"string\",\"doc\":\"pegasus type of the metadata\"}]},\"doc\":\"describes the collection-level metadata returned by this finder\",\"optional\":true},{\"name\":\"assocKey\",\"type\":\"string\",\"doc\":\"association key for this finder - only present if this finder takes a single association key\",\"optional\":true},{\"name\":\"assocKeys\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"list of association keys for this finder - only present if this finder takes multiple association keys\",\"optional\":true},{\"name\":\"pagingSupported\",\"type\":\"boolean\",\"doc\":\"Indicates if this finder method has paging support using the start and count parameters\",\"optional\":true}]}},\"doc\":\"list of finders supported by this collection\",\"optional\":true},{\"name\":\"actions\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"ActionSchema\",\"include\":[\"CustomAnnotationSchema\"],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of this action\"},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this action\",\"optional\":true},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":\"ParameterSchema\"},\"doc\":\"parameters for this action\",\"optional\":true},{\"name\":\"returns\",\"type\":\"string\",\"doc\":\"avro type of this action's return value\",\"optional\":true},{\"name\":\"throws\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"list of exception types thrown by this action\",\"optional\":true}]}},\"doc\":\"list of actions supported by this collection\",\"optional\":true},{\"name\":\"entity\",\"type\":{\"type\":\"record\",\"name\":\"EntitySchema\",\"fields\":[{\"name\":\"path\",\"type\":\"string\",\"doc\":\"URI template for accessing this entity\"},{\"name\":\"actions\",\"type\":{\"type\":\"array\",\"items\":\"ActionSchema\"},\"doc\":\"list of actions supported by this entity\",\"optional\":true},{\"name\":\"subresources\",\"type\":{\"type\":\"array\",\"items\":\"ResourceSchema\"},\"doc\":\"list of subresources accessible via this entity\",\"optional\":true}]},\"doc\":\"details of the entity provided by this collection\"}]},\"doc\":\"details of collection, if this resource is a collection\",\"optional\":true},{\"name\":\"association\",\"type\":{\"type\":\"record\",\"name\":\"AssociationSchema\",\"fields\":[{\"name\":\"identifier\",\"type\":\"string\",\"doc\":\"name of the identifier (key) for this collection\",\"optional\":true},{\"name\":\"assocKeys\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AssocKeySchema\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of association key\"},{\"name\":\"type\",\"type\":\"string\",\"doc\":\"avro type of association key\"}]}},\"doc\":\"list of association keys for this association\"},{\"name\":\"alternativeKeys\",\"type\":{\"type\":\"array\",\"items\":\"AlternativeKeySchema\"},\"doc\":\"alternative keys\",\"optional\":true},{\"name\":\"supports\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"list of rest.li methods supported by this association, e.g., get, update, delete, batch_get\"},{\"name\":\"methods\",\"type\":{\"type\":\"array\",\"items\":\"RestMethodSchema\"},\"doc\":\"details on rest methods supported by this association\",\"optional\":true},{\"name\":\"finders\",\"type\":{\"type\":\"array\",\"items\":\"FinderSchema\"},\"doc\":\"list of finders supported by this association\",\"optional\":true},{\"name\":\"actions\",\"type\":{\"type\":\"array\",\"items\":\"ActionSchema\"},\"doc\":\"list of actions supported by this association\",\"optional\":true},{\"name\":\"entity\",\"type\":\"EntitySchema\",\"doc\":\"details on the entities contained in this association\"}]},\"doc\":\"details of association, if this resource is an association\",\"optional\":true},{\"name\":\"actionsSet\",\"type\":{\"type\":\"record\",\"name\":\"ActionsSetSchema\",\"fields\":[{\"name\":\"actions\",\"type\":{\"type\":\"array\",\"items\":\"ActionSchema\"},\"doc\":\"list of actions supported by this action set\"}]},\"doc\":\"details of action set, if this resource is an action set\",\"optional\":true},{\"name\":\"simple\",\"type\":{\"type\":\"record\",\"name\":\"SimpleSchema\",\"fields\":[{\"name\":\"supports\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"basic rest.li methods supported by this resource, e.g. get, update, delete\"},{\"name\":\"methods\",\"type\":{\"type\":\"array\",\"items\":\"RestMethodSchema\"},\"doc\":\"details on rest methods supported by this simple resource\",\"optional\":true},{\"name\":\"actions\",\"type\":{\"type\":\"array\",\"items\":\"ActionSchema\"},\"doc\":\"list of actions supported by this simple resource\",\"optional\":true},{\"name\":\"entity\",\"type\":\"EntitySchema\",\"doc\":\"details of the entity provided by this simple resource\"}]},\"doc\":\"details of simple resource, if this resource is a simple resource\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_Annotations = SCHEMA.getField("annotations");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Namespace = SCHEMA.getField("namespace");
    private static final RecordDataSchema.Field FIELD_Path = SCHEMA.getField("path");
    private static final RecordDataSchema.Field FIELD_Schema = SCHEMA.getField("schema");
    private static final RecordDataSchema.Field FIELD_Doc = SCHEMA.getField("doc");
    private static final RecordDataSchema.Field FIELD_Collection = SCHEMA.getField("collection");
    private static final RecordDataSchema.Field FIELD_Association = SCHEMA.getField("association");
    private static final RecordDataSchema.Field FIELD_ActionsSet = SCHEMA.getField("actionsSet");
    private static final RecordDataSchema.Field FIELD_Simple = SCHEMA.getField("simple");

    public ResourceSchema() {
        super(new DataMap(), SCHEMA);
    }

    public ResourceSchema(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasAnnotations() {
        return this.contains(FIELD_Annotations);
    }

    public void removeAnnotations() {
        this.remove(FIELD_Annotations);
    }

    public CustomAnnotationContentSchemaMap getAnnotations(GetMode mode) {
        return (CustomAnnotationContentSchemaMap)this.obtainWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, mode);
    }

    @Nullable
    public CustomAnnotationContentSchemaMap getAnnotations() {
        return (CustomAnnotationContentSchemaMap)this.obtainWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, GetMode.STRICT);
    }

    public ResourceSchema setAnnotations(CustomAnnotationContentSchemaMap value, SetMode mode) {
        this.putWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, (DataTemplate)value, mode);
        return this;
    }

    public ResourceSchema setAnnotations(@Nonnull CustomAnnotationContentSchemaMap value) {
        this.putWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasName() {
        return this.contains(FIELD_Name);
    }

    public void removeName() {
        this.remove(FIELD_Name);
    }

    public String getName(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Name, String.class, mode);
    }

    @Nonnull
    public String getName() {
        return (String)this.obtainDirect(FIELD_Name, String.class, GetMode.STRICT);
    }

    public ResourceSchema setName(String value, SetMode mode) {
        this.putDirect(FIELD_Name, String.class, String.class, value, mode);
        return this;
    }

    public ResourceSchema setName(@Nonnull String value) {
        this.putDirect(FIELD_Name, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasNamespace() {
        return this.contains(FIELD_Namespace);
    }

    public void removeNamespace() {
        this.remove(FIELD_Namespace);
    }

    public String getNamespace(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Namespace, String.class, mode);
    }

    @Nullable
    public String getNamespace() {
        return (String)this.obtainDirect(FIELD_Namespace, String.class, GetMode.STRICT);
    }

    public ResourceSchema setNamespace(String value, SetMode mode) {
        this.putDirect(FIELD_Namespace, String.class, String.class, value, mode);
        return this;
    }

    public ResourceSchema setNamespace(@Nonnull String value) {
        this.putDirect(FIELD_Namespace, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPath() {
        return this.contains(FIELD_Path);
    }

    public void removePath() {
        this.remove(FIELD_Path);
    }

    public String getPath(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Path, String.class, mode);
    }

    @Nonnull
    public String getPath() {
        return (String)this.obtainDirect(FIELD_Path, String.class, GetMode.STRICT);
    }

    public ResourceSchema setPath(String value, SetMode mode) {
        this.putDirect(FIELD_Path, String.class, String.class, value, mode);
        return this;
    }

    public ResourceSchema setPath(@Nonnull String value) {
        this.putDirect(FIELD_Path, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasSchema() {
        return this.contains(FIELD_Schema);
    }

    public void removeSchema() {
        this.remove(FIELD_Schema);
    }

    public String getSchema(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Schema, String.class, mode);
    }

    @Nullable
    public String getSchema() {
        return (String)this.obtainDirect(FIELD_Schema, String.class, GetMode.STRICT);
    }

    public ResourceSchema setSchema(String value, SetMode mode) {
        this.putDirect(FIELD_Schema, String.class, String.class, value, mode);
        return this;
    }

    public ResourceSchema setSchema(@Nonnull String value) {
        this.putDirect(FIELD_Schema, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDoc() {
        return this.contains(FIELD_Doc);
    }

    public void removeDoc() {
        this.remove(FIELD_Doc);
    }

    public String getDoc(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Doc, String.class, mode);
    }

    @Nullable
    public String getDoc() {
        return (String)this.obtainDirect(FIELD_Doc, String.class, GetMode.STRICT);
    }

    public ResourceSchema setDoc(String value, SetMode mode) {
        this.putDirect(FIELD_Doc, String.class, String.class, value, mode);
        return this;
    }

    public ResourceSchema setDoc(@Nonnull String value) {
        this.putDirect(FIELD_Doc, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasCollection() {
        return this.contains(FIELD_Collection);
    }

    public void removeCollection() {
        this.remove(FIELD_Collection);
    }

    public CollectionSchema getCollection(GetMode mode) {
        return (CollectionSchema)this.obtainWrapped(FIELD_Collection, CollectionSchema.class, mode);
    }

    @Nullable
    public CollectionSchema getCollection() {
        return (CollectionSchema)this.obtainWrapped(FIELD_Collection, CollectionSchema.class, GetMode.STRICT);
    }

    public ResourceSchema setCollection(CollectionSchema value, SetMode mode) {
        this.putWrapped(FIELD_Collection, CollectionSchema.class, (DataTemplate)value, mode);
        return this;
    }

    public ResourceSchema setCollection(@Nonnull CollectionSchema value) {
        this.putWrapped(FIELD_Collection, CollectionSchema.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasAssociation() {
        return this.contains(FIELD_Association);
    }

    public void removeAssociation() {
        this.remove(FIELD_Association);
    }

    public AssociationSchema getAssociation(GetMode mode) {
        return (AssociationSchema)this.obtainWrapped(FIELD_Association, AssociationSchema.class, mode);
    }

    @Nullable
    public AssociationSchema getAssociation() {
        return (AssociationSchema)this.obtainWrapped(FIELD_Association, AssociationSchema.class, GetMode.STRICT);
    }

    public ResourceSchema setAssociation(AssociationSchema value, SetMode mode) {
        this.putWrapped(FIELD_Association, AssociationSchema.class, (DataTemplate)value, mode);
        return this;
    }

    public ResourceSchema setAssociation(@Nonnull AssociationSchema value) {
        this.putWrapped(FIELD_Association, AssociationSchema.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasActionsSet() {
        return this.contains(FIELD_ActionsSet);
    }

    public void removeActionsSet() {
        this.remove(FIELD_ActionsSet);
    }

    public ActionsSetSchema getActionsSet(GetMode mode) {
        return (ActionsSetSchema)this.obtainWrapped(FIELD_ActionsSet, ActionsSetSchema.class, mode);
    }

    @Nullable
    public ActionsSetSchema getActionsSet() {
        return (ActionsSetSchema)this.obtainWrapped(FIELD_ActionsSet, ActionsSetSchema.class, GetMode.STRICT);
    }

    public ResourceSchema setActionsSet(ActionsSetSchema value, SetMode mode) {
        this.putWrapped(FIELD_ActionsSet, ActionsSetSchema.class, (DataTemplate)value, mode);
        return this;
    }

    public ResourceSchema setActionsSet(@Nonnull ActionsSetSchema value) {
        this.putWrapped(FIELD_ActionsSet, ActionsSetSchema.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasSimple() {
        return this.contains(FIELD_Simple);
    }

    public void removeSimple() {
        this.remove(FIELD_Simple);
    }

    public SimpleSchema getSimple(GetMode mode) {
        return (SimpleSchema)this.obtainWrapped(FIELD_Simple, SimpleSchema.class, mode);
    }

    @Nullable
    public SimpleSchema getSimple() {
        return (SimpleSchema)this.obtainWrapped(FIELD_Simple, SimpleSchema.class, GetMode.STRICT);
    }

    public ResourceSchema setSimple(SimpleSchema value, SetMode mode) {
        this.putWrapped(FIELD_Simple, SimpleSchema.class, (DataTemplate)value, mode);
        return this;
    }

    public ResourceSchema setSimple(@Nonnull SimpleSchema value) {
        this.putWrapped(FIELD_Simple, SimpleSchema.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public ResourceSchema clone() throws CloneNotSupportedException {
        return (ResourceSchema)super.clone();
    }

    public ResourceSchema copy() throws CloneNotSupportedException {
        return (ResourceSchema)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public CustomAnnotationContentSchemaMap.Fields annotations() {
            return new CustomAnnotationContentSchemaMap.Fields(this.getPathComponents(), "annotations");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec namespace() {
            return new PathSpec(this.getPathComponents(), "namespace");
        }

        public PathSpec path() {
            return new PathSpec(this.getPathComponents(), "path");
        }

        public PathSpec schema() {
            return new PathSpec(this.getPathComponents(), "schema");
        }

        public PathSpec doc() {
            return new PathSpec(this.getPathComponents(), "doc");
        }

        public CollectionSchema.Fields collection() {
            return new CollectionSchema.Fields(this.getPathComponents(), "collection");
        }

        public AssociationSchema.Fields association() {
            return new AssociationSchema.Fields(this.getPathComponents(), "association");
        }

        public ActionsSetSchema.Fields actionsSet() {
            return new ActionsSetSchema.Fields(this.getPathComponents(), "actionsSet");
        }

        public SimpleSchema.Fields simple() {
            return new SimpleSchema.Fields(this.getPathComponents(), "simple");
        }
    }
}

