/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.restli.common.ResourceMethod;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public interface RestConstants {
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_COUNT = 10;
    public static final String HEADER_RESTLI_REQUEST_METHOD = "X-RestLi-Method";
    public static final String HEADER_LINKEDIN_ERROR_RESPONSE = "X-LinkedIn-Error-Response";
    public static final String HEADER_RESTLI_ERROR_RESPONSE = "X-RestLi-Error-Response";
    public static final String HEADER_VALUE_ERROR = "true";
    public static final String HEADER_ID = "X-LinkedIn-Id";
    public static final String HEADER_RESTLI_ID = "X-RestLi-Id";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json";
    public static final String HEADER_VALUE_APPLICATION_PSON = "application/x-pson";
    public static final String HEADER_VALUE_MULTIPART_RELATED = "multipart/related";
    public static final String HEADER_VALUE_ACCEPT_ANY = "*/*";
    public static final String HEADER_RESTLI_PROTOCOL_VERSION = "X-RestLi-Protocol-Version";
    public static final String HEADER_CONTENT_ID = "Content-ID";
    public static final List<String> SUPPORTED_MIME_TYPES = Arrays.asList("application/x-pson", "application/json");
    public static final String START_PARAM = "start";
    public static final String COUNT_PARAM = "count";
    public static final String ACTION_PARAM = "action";
    public static final String QUERY_TYPE_PARAM = "q";
    public static final String QUERY_BATCH_IDS_PARAM = "ids";
    public static final String FIELDS_PARAM = "fields";
    public static final String ALT_KEY_PARAM = "altkey";
    public static final String METADATA_FIELDS_PARAM = "metadataFields";
    public static final String PAGING_FIELDS_PARAM = "pagingFields";
    public static final Set<String> PROJECTION_PARAMETERS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("fields", "metadataFields", "pagingFields")));
    public static final char SIMPLE_KEY_DELIMITER = '&';
    public static final char KEY_VALUE_DELIMITER = '=';
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final String RESOURCE_MODEL_FILENAME_EXTENSION = ".restspec.json";
    public static final String SNAPSHOT_FILENAME_EXTENTION = ".snapshot.json";
    public static final Set<ResourceMethod> SIMPLE_RESOURCE_METHODS = Collections.unmodifiableSet(new HashSet<ResourceMethod>(Arrays.asList(ResourceMethod.ACTION, ResourceMethod.DELETE, ResourceMethod.GET, ResourceMethod.PARTIAL_UPDATE, ResourceMethod.UPDATE)));
    public static final String RESTLI_PROTOCOL_VERSION_PROPERTY = "restli.protocol";
    public static final String RESTLI_PROTOCOL_VERSION_PERCENTAGE_PROPERTY = "restli.protocol.percentage";
    public static final String RESTLI_FORCE_USE_NEXT_VERSION_OVERRIDE = "restli.forceUseNextVersionOverride";
}

