/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RecordDataSchema
extends NamedDataSchema {
    public static final boolean OPTIONAL_FIELD_CANNOT_BE_UNION_WITH_NULL = false;
    private List<NamedDataSchema> _include = _emptyNamedSchemas;
    private List<Field> _fields = _emptyFields;
    private Map<String, Integer> _fieldNameToIndexMap = _emptyFieldNameToIndexMap;
    private final RecordType _recordType;
    private Set<NamedDataSchema> _includesDeclaredInline = _emptyIncludesDeclaredInline;
    private static ThreadLocal<IdentityHashMap<RecordDataSchema, RecordDataSchema>> _equalsTracking = new ThreadLocal<IdentityHashMap<RecordDataSchema, RecordDataSchema>>(){

        @Override
        protected IdentityHashMap<RecordDataSchema, RecordDataSchema> initialValue() {
            return null;
        }
    };
    private static ThreadLocal<IdentityHashMap<RecordDataSchema, Boolean>> _hashCodeTracking = new ThreadLocal<IdentityHashMap<RecordDataSchema, Boolean>>(){

        @Override
        protected IdentityHashMap<RecordDataSchema, Boolean> initialValue() {
            return null;
        }
    };
    private static final List<NamedDataSchema> _emptyNamedSchemas = Collections.emptyList();
    private static final List<Field> _emptyFields = Collections.emptyList();
    private static final Map<String, Integer> _emptyFieldNameToIndexMap = Collections.emptyMap();
    private static final Set<NamedDataSchema> _emptyIncludesDeclaredInline = Collections.emptySet();

    public RecordDataSchema(Name name, RecordType recordType) {
        super(DataSchema.Type.RECORD, name);
        this._recordType = recordType;
    }

    public RecordType recordType() {
        return this._recordType;
    }

    public boolean isErrorRecord() {
        return this._recordType == RecordType.ERROR;
    }

    public List<Field> getFields() {
        return this._fields;
    }

    public int index(String fieldName) {
        Integer i = this._fieldNameToIndexMap.get(fieldName);
        return i == null ? -1 : i;
    }

    public boolean contains(String fieldName) {
        return this._fieldNameToIndexMap.containsKey(fieldName);
    }

    public Field getField(String fieldName) {
        Integer index = this._fieldNameToIndexMap.get(fieldName);
        return index == null ? null : this._fields.get(index);
    }

    public boolean setFields(List<Field> fields, StringBuilder errorMessageBuilder) {
        boolean ok = true;
        this._fields = Collections.unmodifiableList(fields);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int index = 0;
        for (Field field : this._fields) {
            Integer oldIndex = map.put(field.getName(), index);
            if (oldIndex != null) {
                Field oldField = fields.get(oldIndex);
                boolean emitSource = field.getRecord() != oldField.getRecord() || field.getRecord() != this;
                errorMessageBuilder.append("Field \"").append(field.getName());
                errorMessageBuilder.append("\" defined more than once, with ").append(oldField.getType());
                if (emitSource) {
                    errorMessageBuilder.append(" defined in \"").append(oldField.getRecord().getFullName()).append("\"");
                }
                errorMessageBuilder.append(" and ").append(field.getType());
                if (emitSource) {
                    errorMessageBuilder.append(" defined in \"").append(field.getRecord().getFullName()).append("\"");
                }
                errorMessageBuilder.append(".\n");
                map.put(field.getName(), oldIndex);
                ok = false;
            }
            ++index;
        }
        this._fieldNameToIndexMap = Collections.unmodifiableMap(map);
        if (!ok) {
            this.setHasError();
        }
        return ok;
    }

    public List<NamedDataSchema> getInclude() {
        return this._include;
    }

    public void setInclude(List<NamedDataSchema> include) {
        this._include = Collections.unmodifiableList(include);
    }

    public void setIncludesDeclaredInline(Set<NamedDataSchema> includesDeclaredInline) {
        this._includesDeclaredInline = Collections.unmodifiableSet(includesDeclaredInline);
    }

    public boolean isIncludeDeclaredInline(NamedDataSchema type) {
        return this._includesDeclaredInline.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == RecordDataSchema.class) {
            RecordDataSchema other = (RecordDataSchema)object;
            if (!super.equals(other) || this._recordType != other._recordType) {
                return false;
            }
            IdentityHashMap<RecordDataSchema, RecordDataSchema> trackingMap = _equalsTracking.get();
            boolean startTracking = trackingMap == null;
            try {
                if (startTracking) {
                    trackingMap = new IdentityHashMap();
                    _equalsTracking.set(trackingMap);
                } else {
                    RecordDataSchema trackedOther = trackingMap.get(this);
                    if (trackedOther == other) {
                        boolean bl = true;
                        return bl;
                    }
                    if (trackedOther != null) {
                        boolean bl = false;
                        return bl;
                    }
                }
                trackingMap.put(this, other);
                boolean bl = this._fields.equals(other._fields);
                return bl;
            }
            finally {
                if (startTracking) {
                    _equalsTracking.remove();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        IdentityHashMap<RecordDataSchema, Boolean> trackingMap = _hashCodeTracking.get();
        boolean startTracking = trackingMap == null;
        try {
            if (startTracking) {
                trackingMap = new IdentityHashMap();
                _hashCodeTracking.set(trackingMap);
            }
            if (trackingMap.containsKey(this)) {
                int n = 0;
                return n;
            }
            trackingMap.put(this, Boolean.TRUE);
            int n = super.hashCode() ^ this._recordType.hashCode() ^ this._fields.hashCode();
            return n;
        }
        finally {
            if (startTracking) {
                _hashCodeTracking.remove();
            }
        }
    }

    public static enum RecordType {
        RECORD,
        ERROR;

    }

    public static class Field {
        private boolean _hasError = false;
        private DataSchema _type = DataSchemaConstants.NULL_DATA_SCHEMA;
        private String _name = "";
        private String _doc = "";
        private Object _defaultValue;
        private boolean _optional;
        private Order _order = Order.ASCENDING;
        private RecordDataSchema _record = null;
        private List<String> _aliases = _emptyAliases;
        private Map<String, Object> _properties = _emptyProperties;
        private boolean _declaredInline = false;
        private static final Map<String, Object> _emptyProperties = Collections.emptyMap();
        private static final List<String> _emptyAliases = Collections.emptyList();

        public Field(DataSchema type) {
            this.setType(type);
        }

        public void setType(DataSchema type) {
            if (type == null) {
                this._type = DataSchemaConstants.NULL_DATA_SCHEMA;
                this._hasError = true;
            } else {
                this._type = type;
            }
        }

        public boolean setName(String name, StringBuilder errorMessageBuilder) {
            boolean ok = true;
            if (!Field.isValidFieldName(name)) {
                errorMessageBuilder.append("\"").append(name).append("\" is an invalid field name.\n");
                ok = false;
            }
            this._name = name;
            this._hasError |= !ok;
            return ok;
        }

        public boolean hasError() {
            return this._hasError;
        }

        public void setDoc(String documentation) {
            this._doc = documentation;
        }

        public void setProperties(Map<String, Object> properties) {
            this._properties = Collections.unmodifiableMap(properties);
        }

        public boolean setAliases(List<String> aliases, StringBuilder errorMessageBuilder) {
            boolean ok = true;
            for (String alias : aliases) {
                if (Field.isValidFieldName(alias)) continue;
                errorMessageBuilder.append(alias).append(" is an invalid field name alias.\n");
                ok = false;
            }
            this._aliases = Collections.unmodifiableList(aliases);
            this._hasError |= !ok;
            return ok;
        }

        public void setDefault(Object defaultValue) {
            this._defaultValue = defaultValue;
        }

        public void setOptional(boolean optional) {
            this._optional = optional;
        }

        public void setOrder(Order sortOrder) {
            this._order = sortOrder;
        }

        public void setRecord(RecordDataSchema record) {
            this._record = record;
        }

        public String getName() {
            return this._name;
        }

        public DataSchema getType() {
            return this._type;
        }

        public String getDoc() {
            return this._doc;
        }

        public Map<String, Object> getProperties() {
            return this._properties;
        }

        public List<String> getAliases() {
            return this._aliases;
        }

        public Object getDefault() {
            return this._defaultValue;
        }

        public boolean getOptional() {
            return this._optional;
        }

        public Order getOrder() {
            return this._order;
        }

        public RecordDataSchema getRecord() {
            return this._record;
        }

        public void setDeclaredInline(boolean declaredInline) {
            this._declaredInline = declaredInline;
        }

        public boolean isDeclaredInline() {
            return this._declaredInline;
        }

        public boolean equals(Object object) {
            boolean result;
            if (object == this) {
                result = true;
            } else if (object != null && object.getClass() == Field.class) {
                Field other = (Field)object;
                result = this._hasError == other._hasError && this._type.equals(other._type) && this._name.equals(other._name) && this._doc.equals(other._doc) && (this._defaultValue == null && other._defaultValue == null || this._defaultValue != null && this._defaultValue.equals(other._defaultValue)) && this._optional == other._optional && this._order == other._order && this._aliases.equals(other._aliases) && this._properties.equals(other._properties);
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return this._type.hashCode() ^ this._name.hashCode() ^ this._doc.hashCode() ^ (this._defaultValue == null ? 0 : this._defaultValue.hashCode()) ^ (this._optional ? -1431655766 : 0x55555555) ^ this._order.hashCode() ^ this._aliases.hashCode() ^ this._properties.hashCode();
        }

        public static boolean isValidFieldName(String input) {
            return DataSchemaConstants.FIELD_NAME_PATTERN.matcher(input).matches();
        }

        public static enum Order {
            ASCENDING,
            DESCENDING,
            IGNORE;

            private final String _name = this.name().toLowerCase();

            public String toString() {
                return this._name;
            }
        }
    }
}

