/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.collections;

import com.linkedin.data.collections.CommonMap;
import com.linkedin.data.collections.MapChecker;
import com.linkedin.data.collections.RefCounted;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CowMap<K, V>
implements CommonMap<K, V>,
Cloneable {
    protected MapChecker<K, V> _checker;
    private boolean _readOnly = false;
    private RefCounted<HashMap<K, V>> _refCounted;

    public CowMap() {
        this._checker = null;
        this._refCounted = new RefCounted(new HashMap());
    }

    public CowMap(Map<? extends K, ? extends V> map) {
        this._checker = null;
        this.checkAll(map);
        this._refCounted = new RefCounted<HashMap<? extends K, ? extends V>>(new HashMap<K, V>(map));
    }

    public CowMap(int initialCapacity) {
        this._checker = null;
        this._refCounted = new RefCounted(new HashMap(initialCapacity));
    }

    public CowMap(int initialCapacity, float loadFactor) {
        this._checker = null;
        this._refCounted = new RefCounted(new HashMap(initialCapacity, loadFactor));
    }

    public CowMap(MapChecker<K, V> checker) {
        this._checker = checker;
        this._refCounted = new RefCounted(new HashMap());
    }

    public CowMap(Map<? extends K, ? extends V> map, MapChecker<K, V> checker) {
        this._checker = checker;
        this.checkAll(map);
        this._refCounted = new RefCounted<HashMap<? extends K, ? extends V>>(new HashMap<K, V>(map));
    }

    public CowMap(int initialCapacity, MapChecker<K, V> checker) {
        this._checker = checker;
        this._refCounted = new RefCounted(new HashMap(initialCapacity));
    }

    public CowMap(int initialCapacity, float loadFactor, MapChecker<K, V> checker) {
        this._checker = checker;
        this._refCounted = new RefCounted(new HashMap(initialCapacity, loadFactor));
    }

    @Override
    public void clear() {
        this.getMutable().clear();
    }

    @Override
    public CowMap<K, V> clone() throws CloneNotSupportedException {
        CowMap o = (CowMap)super.clone();
        o._refCounted = this._refCounted.acquire();
        o._readOnly = false;
        return o;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getObject().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getObject().containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableMap(this.getObject()).entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this.getObject().equals(object);
    }

    @Override
    public V get(Object key) {
        return this.getObject().get(key);
    }

    @Override
    public int hashCode() {
        return this.getObject().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getObject().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.getObject().keySet());
    }

    @Override
    public V put(K key, V value) {
        this.checkKeyValue(key, value);
        return this.getMutable().put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkAll(m);
        this.getMutable().putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.getMutable().remove(key);
    }

    public String toString() {
        return this.getObject().toString();
    }

    @Override
    public int size() {
        return this.getObject().size();
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.getObject().values());
    }

    @Override
    public boolean isReadOnly() {
        return this._readOnly;
    }

    @Override
    public void setReadOnly() {
        this._readOnly = true;
    }

    @Override
    public void invalidate() {
        try {
            if (this._refCounted != null) {
                this._refCounted.release();
            }
        }
        finally {
            this._refCounted = null;
        }
    }

    private final void checkKeyValue(K key, V value) {
        if (this._checker != null) {
            this._checker.checkKeyValue(this, key, value);
        }
    }

    private final void checkAll(Map<? extends K, ? extends V> m) {
        if (this._checker != null) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this._checker.checkKeyValue(this, e.getKey(), e.getValue());
            }
        }
    }

    protected V putWithoutChecking(K key, V value) {
        return this.getMutable().put(key, value);
    }

    RefCounted<HashMap<K, V>> getRefCounted() {
        return this._refCounted;
    }

    private final Map<K, V> getMutable() {
        if (this._readOnly) {
            throw new UnsupportedOperationException("Cannot mutate a read-only map");
        }
        this._refCounted = this._refCounted.getMutable();
        return this._refCounted.getObject();
    }

    protected final Map<K, V> getObject() {
        return this._refCounted.getObject();
    }
}

