/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientConstants;
import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.ErrorContext;
import com.microsoft.azure.servicebus.ExceptionUtil;
import com.microsoft.azure.servicebus.IErrorContextProvider;
import com.microsoft.azure.servicebus.MessagingFactory;
import com.microsoft.azure.servicebus.ReceiverContext;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import com.microsoft.azure.servicebus.TimeoutException;
import com.microsoft.azure.servicebus.TimeoutTracker;
import com.microsoft.azure.servicebus.Timer;
import com.microsoft.azure.servicebus.TimerType;
import com.microsoft.azure.servicebus.WorkItem;
import com.microsoft.azure.servicebus.amqp.AmqpConstants;
import com.microsoft.azure.servicebus.amqp.DispatchHandler;
import com.microsoft.azure.servicebus.amqp.IAmqpReceiver;
import com.microsoft.azure.servicebus.amqp.ReceiveLinkHandler;
import com.microsoft.azure.servicebus.amqp.SessionHandler;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnknownDescribedType;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.Message;

public class MessageReceiver
extends ClientEntity
implements IAmqpReceiver,
IErrorContextProvider {
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private static final int MIN_TIMEOUT_DURATION_MILLIS = 20;
    private final ConcurrentLinkedQueue<ReceiveWorkItem> pendingReceives;
    private final MessagingFactory underlyingFactory;
    private final String receivePath;
    private final Runnable onOperationTimedout;
    private final Duration operationTimeout;
    private final CompletableFuture<Void> linkClose;
    private final Object prefetchCountSync;
    private int prefetchCount;
    private ConcurrentLinkedQueue<Message> prefetchedMessages;
    private Receiver receiveLink;
    private WorkItem<MessageReceiver> linkOpen;
    private Duration receiveTimeout;
    private long epoch;
    private boolean isEpochReceiver;
    private Instant dateTime;
    private boolean offsetInclusive;
    private String lastReceivedOffset;
    private Exception lastKnownLinkError;
    private int nextCreditToFlow;

    private MessageReceiver(MessagingFactory factory, String name, String recvPath, String offset, boolean offsetInclusive, Instant dateTime, int prefetchCount, Long epoch, boolean isEpochReceiver) {
        super(name, factory);
        this.underlyingFactory = factory;
        this.operationTimeout = factory.getOperationTimeout();
        this.receivePath = recvPath;
        this.prefetchCount = prefetchCount;
        this.epoch = epoch;
        this.isEpochReceiver = isEpochReceiver;
        this.prefetchedMessages = new ConcurrentLinkedQueue();
        this.linkClose = new CompletableFuture();
        this.lastKnownLinkError = null;
        this.receiveTimeout = factory.getOperationTimeout();
        this.prefetchCountSync = new Object();
        if (offset != null) {
            this.lastReceivedOffset = offset;
            this.offsetInclusive = offsetInclusive;
        } else {
            this.dateTime = dateTime;
        }
        this.pendingReceives = new ConcurrentLinkedQueue();
        this.onOperationTimedout = new Runnable(){

            @Override
            public void run() {
                WorkItem topWorkItem = null;
                boolean workItemTimedout = false;
                while ((topWorkItem = (WorkItem)MessageReceiver.this.pendingReceives.peek()) != null) {
                    if (topWorkItem.getTimeoutTracker().remaining().toMillis() <= 20L) {
                        WorkItem dequedWorkItem = (WorkItem)MessageReceiver.this.pendingReceives.poll();
                        if (dequedWorkItem == null) break;
                        workItemTimedout = true;
                        dequedWorkItem.getWork().complete(null);
                        continue;
                    }
                    MessageReceiver.this.scheduleOperationTimer(topWorkItem.getTimeoutTracker());
                    break;
                }
                if (workItemTimedout) {
                    try {
                        MessageReceiver.this.underlyingFactory.scheduleOnReactorThread(new DispatchHandler(){

                            @Override
                            public void onEvent() {
                                MessageReceiver.this.receiveLink.flow(0);
                            }
                        });
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public static CompletableFuture<MessageReceiver> create(MessagingFactory factory, String name, String recvPath, String offset, boolean offsetInclusive, Instant dateTime, int prefetchCount, long epoch, boolean isEpochReceiver) {
        MessageReceiver msgReceiver = new MessageReceiver(factory, name, recvPath, offset, offsetInclusive, dateTime, prefetchCount, epoch, isEpochReceiver);
        return msgReceiver.createLink();
    }

    private CompletableFuture<MessageReceiver> createLink() {
        this.linkOpen = new WorkItem(new CompletableFuture(), this.operationTimeout);
        this.scheduleLinkOpenTimeout(this.linkOpen.getTimeoutTracker());
        try {
            this.underlyingFactory.scheduleOnReactorThread(new DispatchHandler(){

                @Override
                public void onEvent() {
                    MessageReceiver.this.createReceiveLink();
                }
            });
        }
        catch (IOException ioException) {
            this.linkOpen.getWork().completeExceptionally(new ServiceBusException(false, "Failed to create Receiver, see cause for more details.", ioException));
        }
        return this.linkOpen.getWork();
    }

    private List<Message> receiveCore(int messageCount) {
        LinkedList<Message> returnMessages = null;
        Message currentMessage = this.pollPrefetchQueue();
        while (currentMessage != null) {
            if (returnMessages == null) {
                returnMessages = new LinkedList<Message>();
            }
            returnMessages.add(currentMessage);
            if (returnMessages.size() >= messageCount) break;
            currentMessage = this.pollPrefetchQueue();
        }
        return returnMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrefetchCount() {
        Object object = this.prefetchCountSync;
        synchronized (object) {
            return this.prefetchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefetchCount(int value) throws ServiceBusException {
        int deltaPrefetchCount;
        Object object = this.prefetchCountSync;
        synchronized (object) {
            deltaPrefetchCount = this.prefetchCount - value;
            this.prefetchCount = value;
        }
        try {
            this.underlyingFactory.scheduleOnReactorThread(new DispatchHandler(){

                @Override
                public void onEvent() {
                    MessageReceiver.this.sendFlow(deltaPrefetchCount);
                }
            });
        }
        catch (IOException ioException) {
            throw new ServiceBusException(false, "Setting prefetch count failed, see cause for more details", ioException);
        }
    }

    public Duration getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(Duration value) {
        this.receiveTimeout = value;
    }

    public CompletableFuture<Collection<Message>> receive(final int maxMessageCount) {
        this.throwIfClosed(this.lastKnownLinkError);
        if (maxMessageCount <= 0 || maxMessageCount > this.prefetchCount) {
            throw new IllegalArgumentException(String.format(Locale.US, "parameter 'maxMessageCount' should be a positive number and should be less than prefetchCount(%s)", this.prefetchCount));
        }
        if (this.pendingReceives.isEmpty()) {
            this.scheduleOperationTimer(TimeoutTracker.create(this.receiveTimeout));
        }
        final CompletableFuture<Collection<Message>> onReceive = new CompletableFuture<Collection<Message>>();
        try {
            this.underlyingFactory.scheduleOnReactorThread(new DispatchHandler(){

                @Override
                public void onEvent() {
                    List messages = MessageReceiver.this.receiveCore(maxMessageCount);
                    if (messages != null) {
                        onReceive.complete(messages);
                    } else {
                        MessageReceiver.this.pendingReceives.offer(new ReceiveWorkItem(onReceive, MessageReceiver.this.receiveTimeout, maxMessageCount));
                    }
                    if (MessageReceiver.this.receiveLink.getLocalState() == EndpointState.CLOSED || MessageReceiver.this.receiveLink.getRemoteState() == EndpointState.CLOSED) {
                        MessageReceiver.this.createReceiveLink();
                    }
                }
            });
        }
        catch (IOException ioException) {
            onReceive.completeExceptionally(new ServiceBusException(false, "Receive failed while dispatching to Reactor, see cause for more details.", ioException));
        }
        return onReceive;
    }

    @Override
    public void onOpenComplete(Exception exception) {
        if (exception == null) {
            if (this.linkOpen != null && !this.linkOpen.getWork().isDone()) {
                this.linkOpen.getWork().complete(this);
            }
            this.lastKnownLinkError = null;
            this.offsetInclusive = false;
            this.underlyingFactory.getRetryPolicy().resetRetryCount(this.underlyingFactory.getClientId());
            this.nextCreditToFlow = 0;
            this.sendFlow(this.prefetchCount - this.prefetchedMessages.size());
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, String.format("receiverPath[%s], linkname[%s], updated-link-credit[%s], sentCredits[%s]", this.receivePath, this.receiveLink.getName(), this.receiveLink.getCredit(), this.prefetchCount));
            }
        } else {
            if (this.linkOpen != null && !this.linkOpen.getWork().isDone()) {
                this.setClosed();
                ExceptionUtil.completeExceptionally(this.linkOpen.getWork(), exception, this);
            }
            this.lastKnownLinkError = exception;
        }
    }

    @Override
    public void onReceiveComplete(Delivery delivery) {
        Message message = null;
        int msgSize = delivery.pending();
        byte[] buffer = new byte[msgSize];
        int read = this.receiveLink.recv(buffer, 0, msgSize);
        message = Proton.message();
        message.decode(buffer, 0, read);
        delivery.settle();
        this.prefetchedMessages.add(message);
        this.underlyingFactory.getRetryPolicy().resetRetryCount(this.getClientId());
        ReceiveWorkItem currentReceive = this.pendingReceives.poll();
        if (currentReceive != null && !currentReceive.getWork().isDone()) {
            List<Message> messages = this.receiveCore(currentReceive.maxMessageCount);
            CompletableFuture<List<Message>> future = currentReceive.getWork();
            future.complete(messages);
        }
    }

    public void onError(ErrorCondition error) {
        Exception completionException = ExceptionUtil.toException(error);
        this.onError(completionException);
    }

    @Override
    public void onError(Exception exception) {
        this.prefetchedMessages.clear();
        if (this.getIsClosingOrClosed()) {
            boolean isTransientException;
            this.linkClose.complete(null);
            WorkItem workItem = null;
            boolean bl = isTransientException = exception == null || exception instanceof ServiceBusException && ((ServiceBusException)exception).getIsTransient();
            while ((workItem = (WorkItem)this.pendingReceives.poll()) != null) {
                CompletableFuture<Object> future = workItem.getWork();
                if (isTransientException) {
                    future.complete(null);
                    continue;
                }
                ExceptionUtil.completeExceptionally(future, exception, this);
            }
        } else {
            Duration nextRetryInterval;
            this.lastKnownLinkError = exception;
            this.onOpenComplete(exception);
            WorkItem workItem = this.pendingReceives.peek();
            Duration duration = nextRetryInterval = workItem != null && workItem.getTimeoutTracker() != null ? this.underlyingFactory.getRetryPolicy().getNextRetryInterval(this.getClientId(), exception, workItem.getTimeoutTracker().remaining()) : null;
            if (nextRetryInterval != null) {
                try {
                    this.underlyingFactory.scheduleOnReactorThread((int)nextRetryInterval.toMillis(), new DispatchHandler(){

                        @Override
                        public void onEvent() {
                            if (MessageReceiver.this.receiveLink.getLocalState() == EndpointState.CLOSED || MessageReceiver.this.receiveLink.getRemoteState() == EndpointState.CLOSED) {
                                MessageReceiver.this.createReceiveLink();
                                MessageReceiver.this.underlyingFactory.getRetryPolicy().incrementRetryCount(MessageReceiver.this.getClientId());
                            }
                        }
                    });
                }
                catch (IOException future) {}
            } else {
                WorkItem pendingReceive = null;
                while ((pendingReceive = (WorkItem)this.pendingReceives.poll()) != null) {
                    ExceptionUtil.completeExceptionally(pendingReceive.getWork(), exception, this);
                }
            }
        }
    }

    private void scheduleOperationTimer(TimeoutTracker tracker) {
        if (tracker != null) {
            Timer.schedule(this.onOperationTimedout, tracker.remaining(), TimerType.OneTimeRun);
        }
    }

    private void createReceiveLink() {
        Connection connection = this.underlyingFactory.getConnection();
        Source source = new Source();
        source.setAddress(this.receivePath);
        UnknownDescribedType filter = null;
        if (this.lastReceivedOffset == null) {
            long totalMilliSeconds;
            block7: {
                try {
                    totalMilliSeconds = this.dateTime.toEpochMilli();
                }
                catch (ArithmeticException ex) {
                    totalMilliSeconds = Long.MAX_VALUE;
                    if (!TRACE_LOGGER.isLoggable(Level.WARNING)) break block7;
                    TRACE_LOGGER.log(Level.WARNING, String.format("receiverPath[%s], linkname[%s], warning[starting receiver from epoch+Long.Max]", this.receivePath, this.receiveLink.getName()));
                }
            }
            filter = new UnknownDescribedType((Object)AmqpConstants.STRING_FILTER, (Object)String.format("amqp.annotation.%s >%s '%s'", "x-opt-enqueued-time", "", totalMilliSeconds));
        } else {
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, String.format("receiverPath[%s], action[recreateReceiveLink], offset[%s], offsetInclusive[%s]", this.receivePath, this.lastReceivedOffset, this.offsetInclusive));
            }
            filter = new UnknownDescribedType((Object)AmqpConstants.STRING_FILTER, (Object)String.format("amqp.annotation.%s >%s '%s'", "x-opt-offset", this.offsetInclusive ? "=" : "", this.lastReceivedOffset));
        }
        Map<Symbol, UnknownDescribedType> filterMap = Collections.singletonMap(AmqpConstants.STRING_FILTER, filter);
        source.setFilter(filterMap);
        Session session = connection.session();
        session.setIncomingCapacity(Integer.MAX_VALUE);
        session.open();
        BaseHandler.setHandler((Extendable)session, (Handler)new SessionHandler(this.receivePath));
        String receiveLinkNamePrefix = StringUtil.getRandomString();
        String receiveLinkName = !StringUtil.isNullOrEmpty(connection.getRemoteContainer()) ? receiveLinkNamePrefix.concat("_").concat(connection.getRemoteContainer()) : receiveLinkNamePrefix;
        Receiver receiver = session.receiver(receiveLinkName);
        receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)new Target());
        receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        receiver.setReceiverSettleMode(ReceiverSettleMode.SECOND);
        if (this.isEpochReceiver) {
            receiver.setProperties(Collections.singletonMap(AmqpConstants.EPOCH, this.epoch));
        }
        ReceiveLinkHandler handler = new ReceiveLinkHandler(this);
        BaseHandler.setHandler((Extendable)receiver, (Handler)handler);
        this.underlyingFactory.registerForConnectionError((Link)receiver);
        receiver.open();
        if (this.receiveLink != null) {
            Receiver oldReceiver = this.receiveLink;
            this.underlyingFactory.deregisterForConnectionError((Link)oldReceiver);
        }
        this.receiveLink = receiver;
    }

    private Message pollPrefetchQueue() {
        Message message = this.prefetchedMessages.poll();
        if (message != null) {
            this.lastReceivedOffset = message.getMessageAnnotations().getValue().get(AmqpConstants.OFFSET).toString();
            this.sendFlow(1);
        }
        return message;
    }

    private void sendFlow(int credits) {
        this.nextCreditToFlow += credits;
        if (this.nextCreditToFlow >= this.prefetchCount || this.nextCreditToFlow >= 100) {
            int tempFlow = this.nextCreditToFlow;
            this.receiveLink.flow(tempFlow);
            this.nextCreditToFlow = 0;
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, String.format("receiverPath[%s], linkname[%s], updated-link-credit[%s], sentCredits[%s]", this.receivePath, this.receiveLink.getName(), this.receiveLink.getCredit(), tempFlow));
            }
        }
    }

    private void scheduleLinkOpenTimeout(TimeoutTracker timeout) {
        Timer.schedule(new Runnable(){

            @Override
            public void run() {
                if (!MessageReceiver.this.linkOpen.getWork().isDone()) {
                    TimeoutException operationTimedout = new TimeoutException(String.format(Locale.US, "%s operation on ReceiveLink(%s) to path(%s) timed out at %s.", "Open", MessageReceiver.this.receiveLink.getName(), MessageReceiver.this.receivePath, ZonedDateTime.now()), (Throwable)MessageReceiver.this.lastKnownLinkError);
                    if (TRACE_LOGGER.isLoggable(Level.WARNING)) {
                        TRACE_LOGGER.log(Level.WARNING, String.format(Locale.US, "receiverPath[%s], linkName[%s], %s call timedout", MessageReceiver.this.receivePath, MessageReceiver.this.receiveLink.getName(), "Open"), operationTimedout);
                    }
                    ExceptionUtil.completeExceptionally(MessageReceiver.this.linkOpen.getWork(), operationTimedout, MessageReceiver.this);
                }
            }
        }, timeout.remaining(), TimerType.OneTimeRun);
    }

    private void scheduleLinkCloseTimeout(TimeoutTracker timeout) {
        Timer.schedule(new Runnable(){

            @Override
            public void run() {
                if (!MessageReceiver.this.linkClose.isDone()) {
                    TimeoutException operationTimedout = new TimeoutException(String.format(Locale.US, "%s operation on Receive Link(%s) timed out at %s", "Close", MessageReceiver.this.receiveLink.getName(), ZonedDateTime.now()));
                    if (TRACE_LOGGER.isLoggable(Level.WARNING)) {
                        TRACE_LOGGER.log(Level.WARNING, String.format(Locale.US, "receiverPath[%s], linkName[%s], %s call timedout", MessageReceiver.this.receivePath, MessageReceiver.this.receiveLink.getName(), "Close"), operationTimedout);
                    }
                    ExceptionUtil.completeExceptionally(MessageReceiver.this.linkClose, operationTimedout, MessageReceiver.this);
                }
            }
        }, timeout.remaining(), TimerType.OneTimeRun);
    }

    @Override
    public void onClose(ErrorCondition condition) {
        if (condition == null) {
            this.onError(new ServiceBusException(true, String.format(Locale.US, "Closing the link. LinkName(%s), EntityPath(%s)", this.receiveLink.getName(), this.receivePath)));
        } else {
            this.onError(condition);
        }
    }

    @Override
    public ErrorContext getContext() {
        boolean isLinkOpened;
        boolean bl = isLinkOpened = this.linkOpen != null && this.linkOpen.getWork().isDone();
        String referenceId = this.receiveLink != null && this.receiveLink.getRemoteProperties() != null && this.receiveLink.getRemoteProperties().containsKey(ClientConstants.TRACKING_ID_PROPERTY) ? this.receiveLink.getRemoteProperties().get(ClientConstants.TRACKING_ID_PROPERTY).toString() : (this.receiveLink != null ? this.receiveLink.getName() : null);
        ReceiverContext errorContext = new ReceiverContext(this.underlyingFactory != null ? this.underlyingFactory.getHostName() : null, this.receivePath, referenceId, isLinkOpened && this.lastReceivedOffset != null ? Long.valueOf(Long.parseLong(this.lastReceivedOffset)) : null, isLinkOpened ? Integer.valueOf(this.prefetchCount) : null, isLinkOpened && this.receiveLink != null ? Integer.valueOf(this.receiveLink.getCredit()) : null, isLinkOpened && this.prefetchedMessages != null ? Integer.valueOf(this.prefetchedMessages.size()) : null, this.isEpochReceiver);
        return errorContext;
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        if (!this.getIsClosed()) {
            if (this.receiveLink != null && this.receiveLink.getLocalState() != EndpointState.CLOSED) {
                this.receiveLink.close();
                this.scheduleLinkCloseTimeout(TimeoutTracker.create(this.operationTimeout));
            } else if (this.receiveLink == null || this.receiveLink.getRemoteState() == EndpointState.CLOSED) {
                this.linkClose.complete(null);
            }
        }
        return this.linkClose;
    }

    private static class ReceiveWorkItem
    extends WorkItem<Collection<Message>> {
        private final int maxMessageCount;

        public ReceiveWorkItem(CompletableFuture<Collection<Message>> completableFuture, Duration timeout, int maxMessageCount) {
            super(completableFuture, timeout);
            this.maxMessageCount = maxMessageCount;
        }
    }
}

