/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.kafka.client.ByteArrayBasedKafkaRecord;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaRecord;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaSimpleExtractor;

public class KafkaSimpleJsonExtractor
extends KafkaSimpleExtractor
implements Extractor<String, byte[]> {
    private static final Gson gson = new Gson();
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public KafkaSimpleJsonExtractor(WorkUnitState state) {
        super(state);
    }

    @Override
    protected byte[] decodeRecord(ByteArrayBasedKafkaRecord messageAndOffset) throws IOException {
        long offset = messageAndOffset.getOffset();
        byte[] keyBytes = messageAndOffset.getKeyBytes();
        String key = keyBytes == null ? "" : new String(keyBytes, CHARSET);
        byte[] payloadBytes = messageAndOffset.getMessageBytes();
        String payload = payloadBytes == null ? "" : new String(payloadBytes, CHARSET);
        KafkaRecord record = new KafkaRecord(offset, key, payload);
        byte[] decodedRecord = gson.toJson((Object)record).getBytes(CHARSET);
        return decodedRecord;
    }
}

