/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.base.Preconditions;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaAvroExtractor;

@Alias(value="AVRO_FIXED_SCHEMA")
public class FixedSchemaKafkaAvroExtractor
extends KafkaAvroExtractor<Void> {
    public static final String STATIC_SCHEMA_ROOT_KEY = "gobblin.source.kafka.fixedSchema";

    public FixedSchemaKafkaAvroExtractor(WorkUnitState state) {
        super(state);
    }

    @Override
    protected Schema getLatestSchemaByTopic(String topic) {
        String key = "gobblin.source.kafka.fixedSchema." + topic;
        Preconditions.checkArgument((boolean)this.workUnitState.contains(key), (Object)String.format("Could not find schema for topic %s. Looking for key %s.", topic, key));
        return new Schema.Parser().parse(this.workUnitState.getProp(key));
    }

    @Override
    protected Schema getRecordSchema(byte[] payload) {
        if (!this.schema.isPresent()) {
            throw new RuntimeException("Schema is not preset. This is an error in the code.");
        }
        return (Schema)this.schema.get();
    }

    @Override
    protected Decoder getDecoder(byte[] payload) {
        return DecoderFactory.get().binaryDecoder(payload, null);
    }
}

