/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.schemareg;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.gobblin.kafka.schemareg.HttpClientFactory;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistry;
import org.apache.gobblin.kafka.schemareg.SchemaRegistryException;
import org.apache.gobblin.kafka.serialize.MD5Digest;
import org.apache.gobblin.metrics.reporter.util.KafkaAvroReporterUtil;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiKafkaSchemaRegistry
implements KafkaSchemaRegistry<MD5Digest, Schema> {
    private static final Logger LOG = LoggerFactory.getLogger(LiKafkaSchemaRegistry.class);
    private static final String GET_RESOURCE_BY_ID = "/id=";
    private static final String GET_RESOURCE_BY_TYPE = "/latest_with_type=";
    private static final String SCHEMA_ID_HEADER_NAME = "Location";
    private static final String SCHEMA_ID_HEADER_PREFIX = "/id=";
    private final GenericObjectPool<HttpClient> httpClientPool;
    private final String url;
    private final Optional<Map<String, String>> namespaceOverride;
    private final boolean switchTopicNames;

    public LiKafkaSchemaRegistry(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey("kafka.schemaRegistry.url"), (Object)String.format("Property %s not provided.", "kafka.schemaRegistry.url"));
        this.url = props.getProperty("kafka.schemaRegistry.url");
        this.namespaceOverride = KafkaAvroReporterUtil.extractOverrideNamespace(props);
        this.switchTopicNames = PropertiesUtils.getPropAsBoolean((Properties)props, (String)"kafka.schemaRegistry.switchName", (String)"true");
        int objPoolSize = Integer.parseInt(props.getProperty("kafka.source.work.units.creation.threads", "30"));
        LOG.info("Create HttpClient pool with size " + objPoolSize);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(objPoolSize);
        config.setMaxIdle(objPoolSize);
        this.httpClientPool = new GenericObjectPool((PooledObjectFactory)new HttpClientFactory(), config);
    }

    @Override
    public Schema getById(MD5Digest id) throws IOException, SchemaRegistryException {
        return this.fetchSchemaByKey(id);
    }

    @Override
    public boolean hasInternalCache() {
        return false;
    }

    @Override
    public Schema getLatestSchema(String topic) throws SchemaRegistryException {
        Schema schema;
        String schemaString;
        int statusCode;
        String schemaUrl = this.url + GET_RESOURCE_BY_TYPE + topic;
        LOG.debug("Fetching from URL : " + schemaUrl);
        GetMethod get = new GetMethod(schemaUrl);
        HttpClient httpClient = this.borrowClient();
        try {
            statusCode = httpClient.executeMethod((HttpMethod)get);
            schemaString = get.getResponseBodyAsString();
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            get.releaseConnection();
            this.httpClientPool.returnObject((Object)httpClient);
        }
        if (statusCode != 200) {
            throw new SchemaRegistryException(String.format("Latest schema for topic %s cannot be retrieved. Status code = %d", topic, statusCode));
        }
        try {
            schema = new Schema.Parser().parse(schemaString);
        }
        catch (Throwable t) {
            throw new SchemaRegistryException(String.format("Latest schema for topic %s cannot be retrieved", topic), t);
        }
        return schema;
    }

    private HttpClient borrowClient() throws SchemaRegistryException {
        try {
            return (HttpClient)this.httpClientPool.borrowObject();
        }
        catch (Exception e) {
            throw new SchemaRegistryException("Unable to borrow " + HttpClient.class.getSimpleName());
        }
    }

    @Override
    public MD5Digest register(String name, Schema schema) throws SchemaRegistryException {
        PostMethod post = new PostMethod(this.url);
        if (this.switchTopicNames) {
            return this.register(AvroUtils.switchName((Schema)schema, (String)name), post);
        }
        post.addParameter("name", name);
        return this.register(schema, post);
    }

    public synchronized MD5Digest register(Schema schema, PostMethod post) throws SchemaRegistryException {
        if (this.namespaceOverride.isPresent()) {
            schema = AvroUtils.switchNamespace((Schema)schema, (Map)((Map)this.namespaceOverride.get()));
        }
        LOG.info("Registering schema " + schema.toString());
        post.addParameter("schema", schema.toString());
        HttpClient httpClient = this.borrowClient();
        try {
            MD5Digest schemaId;
            Header[] headers;
            LOG.debug("Loading: " + post.getURI());
            int statusCode = httpClient.executeMethod((HttpMethod)post);
            if (statusCode != 201) {
                throw new SchemaRegistryException("Error occurred while trying to register schema: " + statusCode);
            }
            String response = post.getResponseBodyAsString();
            if (response != null) {
                LOG.info("Received response " + response);
            }
            if ((headers = post.getResponseHeaders(SCHEMA_ID_HEADER_NAME)).length != 1) {
                throw new SchemaRegistryException("Error reading schema id returned by registerSchema call: headers.length = " + headers.length);
            }
            if (!headers[0].getValue().startsWith("/id=")) {
                throw new SchemaRegistryException("Error parsing schema id returned by registerSchema call: header = " + headers[0].getValue());
            }
            LOG.info("Registered schema successfully");
            String schemaKey = headers[0].getValue().substring("/id=".length());
            MD5Digest mD5Digest = schemaId = MD5Digest.fromString(schemaKey);
            return mD5Digest;
        }
        catch (Throwable t) {
            throw new SchemaRegistryException(t);
        }
        finally {
            post.releaseConnection();
            this.httpClientPool.returnObject((Object)httpClient);
        }
    }

    protected Schema fetchSchemaByKey(MD5Digest key) throws SchemaRegistryException {
        Schema schema;
        String schemaString;
        int statusCode;
        String schemaUrl = this.url + "/id=" + key.asString();
        GetMethod get = new GetMethod(schemaUrl);
        HttpClient httpClient = this.borrowClient();
        try {
            statusCode = httpClient.executeMethod((HttpMethod)get);
            schemaString = get.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new SchemaRegistryException(e);
        }
        finally {
            get.releaseConnection();
            this.httpClientPool.returnObject((Object)httpClient);
        }
        if (statusCode != 200) {
            throw new SchemaRegistryException(String.format("Schema with key %s cannot be retrieved, statusCode = %d", key, statusCode));
        }
        try {
            schema = new Schema.Parser().parse(schemaString);
        }
        catch (Throwable t) {
            throw new SchemaRegistryException(String.format("Schema with ID = %s cannot be parsed", key), t);
        }
        return schema;
    }
}

