/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.validation;

import azkaban.jobExecutor.AbstractJob;
import com.google.common.base.Charsets;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDataset;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDatasetFinder;
import org.apache.gobblin.data.management.conversion.hive.provider.HiveUnitUpdateProvider;
import org.apache.gobblin.data.management.conversion.hive.provider.UpdateNotFoundException;
import org.apache.gobblin.data.management.conversion.hive.provider.UpdateProviderFactory;
import org.apache.gobblin.data.management.conversion.hive.query.HiveValidationQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.apache.gobblin.data.management.conversion.hive.validation.ValidationType;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.HiveUtils;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.hive.HiveSerDeWrapper;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.HiveJdbcConnector;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.slf4j.LoggerFactory;

public class ValidationJob
extends AbstractJob {
    private static final Logger log = Logger.getLogger(ValidationJob.class);
    private static final String HIVE_SOURCE_SKIP_RECENT_THAN_DAYS_KEY = "hive.source.skip.recentThanDays";
    private static final String HIVE_DATASET_CONFIG_AVRO_PREFIX = "hive.conversion.avro";
    private static final String DEFAULT_HIVE_SOURCE_MAXIMUM_LOOKBACK_DAYS = "3";
    private static final String DEFAULT_HIVE_SOURCE_SKIP_RECENT_THAN_DAYS = "1";
    private static final String MAX_THREAD_COUNT = "validation.maxThreadCount";
    private static final String DEFAULT_MAX_THREAD_COUNT = "50";
    private static final String VALIDATION_TYPE_KEY = "hive.validation.type";
    private static final String HIVE_VALIDATION_IGNORE_DATA_PATH_IDENTIFIER_KEY = "hive.validation.ignoreDataPathIdentifier";
    private static final String DEFAULT_HIVE_VALIDATION_IGNORE_DATA_PATH_IDENTIFIER = "";
    private static final Splitter COMMA_BASED_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private static final Splitter EQUALITY_SPLITTER = Splitter.on((String)"=").omitEmptyStrings().trimResults();
    private static final Splitter SLASH_SPLITTER = Splitter.on((String)"/").omitEmptyStrings().trimResults();
    private static final String VALIDATION_FILE_FORMAT_KEY = "hive.validation.fileFormat";
    private static final String IS_NESTED_ORC = "hive.validation.isNestedORC";
    private static final String DEFAULT_IS_NESTED_ORC = "false";
    private static final String HIVE_SETTINGS = "hive.settings";
    private static final String DATEPARTITION = "datepartition";
    private static final String DATE_FORMAT = "yyyy-MM-dd-HH";
    public static final String GOBBLIN_CONFIG_TAGS_WHITELIST = "gobblin.config.tags.whitelist";
    private final ValidationType validationType;
    private List<String> ignoreDataPathIdentifierList;
    private final List<Throwable> throwables;
    private final Properties props;
    private final MetricContext metricContext;
    private final EventSubmitter eventSubmitter;
    private final HiveUnitUpdateProvider updateProvider;
    private final ConvertibleHiveDatasetFinder datasetFinder;
    private final long maxLookBackTime;
    private final long skipRecentThanTime;
    private final HiveMetastoreClientPool pool;
    private final FileSystem fs;
    private final ExecutorService exec;
    private final List<Future<Void>> futures;
    private final Boolean isNestedORC;
    private final List<String> hiveSettings;
    protected Optional<String> configStoreUri;
    private static final short maxParts = 1000;
    private Map<String, String> successfulConversions;
    private Map<String, String> failedConversions;
    private Map<String, String> warnConversions;
    private Map<String, String> dataValidationFailed;
    private Map<String, String> dataValidationSuccessful;

    public ValidationJob(String jobId, Properties props) throws IOException {
        super(jobId, log);
        props.setProperty("hive.dataset.configPrefix", HIVE_DATASET_CONFIG_AVRO_PREFIX);
        Config config = ConfigFactory.parseProperties((Properties)props);
        this.props = props;
        this.metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)config), ValidationJob.class);
        this.eventSubmitter = new EventSubmitter.Builder(this.metricContext, "gobblin.hive.conversion").build();
        this.updateProvider = UpdateProviderFactory.create((Properties)props);
        this.datasetFinder = new ConvertibleHiveDatasetFinder(ValidationJob.getSourceFs(), props, this.eventSubmitter);
        this.fs = FileSystem.get((Configuration)new Configuration());
        int maxLookBackDays = Integer.parseInt(props.getProperty("hive.source.maximum.lookbackDays", DEFAULT_HIVE_SOURCE_MAXIMUM_LOOKBACK_DAYS));
        int skipRecentThanDays = Integer.parseInt(props.getProperty(HIVE_SOURCE_SKIP_RECENT_THAN_DAYS_KEY, DEFAULT_HIVE_SOURCE_SKIP_RECENT_THAN_DAYS));
        this.maxLookBackTime = new DateTime().minusDays(maxLookBackDays).getMillis();
        this.skipRecentThanTime = new DateTime().minusDays(skipRecentThanDays).getMillis();
        int maxThreadCount = Integer.parseInt(props.getProperty(MAX_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT));
        this.exec = Executors.newFixedThreadPool(maxThreadCount, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LoggerFactory.getLogger(ValidationJob.class)), (Optional)Optional.of((Object)"getValidationOutputFromHive")));
        this.futures = Lists.newArrayList();
        EventSubmitter.submit((Optional)Optional.of((Object)this.eventSubmitter), (String)"gobblin.hive.validation.Setup");
        this.pool = HiveMetastoreClientPool.get((Properties)props, (Optional)Optional.fromNullable((Object)props.getProperty("hive.dataset.hive.metastore.uri")));
        Preconditions.checkArgument((boolean)props.containsKey(VALIDATION_TYPE_KEY), (Object)"Missing property hive.validation.type");
        this.validationType = ValidationType.valueOf(props.getProperty(VALIDATION_TYPE_KEY));
        this.ignoreDataPathIdentifierList = COMMA_BASED_SPLITTER.splitToList((CharSequence)props.getProperty(HIVE_VALIDATION_IGNORE_DATA_PATH_IDENTIFIER_KEY, DEFAULT_HIVE_VALIDATION_IGNORE_DATA_PATH_IDENTIFIER));
        this.throwables = new ArrayList<Throwable>();
        this.isNestedORC = Boolean.parseBoolean(props.getProperty(IS_NESTED_ORC, DEFAULT_IS_NESTED_ORC));
        this.hiveSettings = Splitter.on((String)";").trimResults().omitEmptyStrings().splitToList((CharSequence)props.getProperty(HIVE_SETTINGS, DEFAULT_HIVE_VALIDATION_IGNORE_DATA_PATH_IDENTIFIER));
    }

    public void run() throws Exception {
        if (this.validationType == ValidationType.COUNT_VALIDATION) {
            this.runCountValidation();
        } else if (this.validationType == ValidationType.FILE_FORMAT_VALIDATION) {
            this.runFileFormatValidation();
        }
    }

    private void runFileFormatValidation() throws IOException {
        Preconditions.checkArgument((boolean)this.props.containsKey(VALIDATION_FILE_FORMAT_KEY));
        Optional optional = this.configStoreUri = StringUtils.isNotBlank((CharSequence)this.props.getProperty("gobblin.config.management.store.uri")) ? Optional.of((Object)this.props.getProperty("gobblin.config.management.store.uri")) : Optional.absent();
        if (!Boolean.valueOf(this.props.getProperty("gobblin.config.management.store.enabled", DEFAULT_IS_NESTED_ORC)).booleanValue()) {
            this.configStoreUri = Optional.absent();
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (this.configStoreUri.isPresent()) {
            Preconditions.checkArgument((boolean)this.props.containsKey(GOBBLIN_CONFIG_TAGS_WHITELIST), (Object)"Missing required property gobblin.config.tags.whitelist");
            String tag = this.props.getProperty(GOBBLIN_CONFIG_TAGS_WHITELIST);
            ConfigClient configClient = ConfigClient.createConfigClient((VersionStabilityPolicy)VersionStabilityPolicy.WEAK_LOCAL_STABILITY);
            Path tagUri = PathUtils.mergePaths((Path)new Path((String)this.configStoreUri.get()), (Path)new Path(tag));
            try (AutoReturnableObject client = this.pool.getClient();){
                Collection importedBy = configClient.getImportedBy(new URI(tagUri.toString()), true);
                for (URI uri : importedBy) {
                    String dbName = new Path(uri).getParent().getName();
                    Table table = new Table(((IMetaStoreClient)client.get()).getTable(dbName, new Path(uri).getName()));
                    for (org.apache.hadoop.hive.metastore.api.Partition partition : ((IMetaStoreClient)client.get()).listPartitions(dbName, table.getTableName(), (short)1000)) {
                        partitions.add(new Partition(table, partition));
                    }
                }
            }
            catch (Exception e) {
                this.throwables.add(e);
            }
        }
        for (Partition partition : partitions) {
            if (!this.shouldValidate(partition)) continue;
            String fileFormat = this.props.getProperty(VALIDATION_FILE_FORMAT_KEY);
            Optional hiveSerDe = Enums.getIfPresent(HiveSerDeWrapper.BuiltInHiveSerDe.class, (String)fileFormat.toUpperCase());
            if (!hiveSerDe.isPresent()) {
                this.throwables.add(new Throwable("Partition SerDe is either not supported or absent"));
                continue;
            }
            String serdeLib = partition.getTPartition().getSd().getSerdeInfo().getSerializationLib();
            if (((HiveSerDeWrapper.BuiltInHiveSerDe)hiveSerDe.get()).toString().equalsIgnoreCase(serdeLib)) continue;
            this.throwables.add(new Throwable("Partition " + partition.getCompleteName() + " SerDe " + serdeLib + " doesn't match with the required SerDe " + ((HiveSerDeWrapper.BuiltInHiveSerDe)hiveSerDe.get()).toString()));
        }
        if (!this.throwables.isEmpty()) {
            for (Throwable e : this.throwables) {
                log.error((Object)("Failed to validate due to " + e));
            }
            throw new RuntimeException("Validation Job Failed");
        }
    }

    private void runCountValidation() throws InterruptedException {
        try {
            this.successfulConversions = Maps.newConcurrentMap();
            this.failedConversions = Maps.newConcurrentMap();
            this.warnConversions = Maps.newConcurrentMap();
            this.dataValidationFailed = Maps.newConcurrentMap();
            this.dataValidationSuccessful = Maps.newConcurrentMap();
            Iterator iterator = this.datasetFinder.getDatasetsIterator();
            EventSubmitter.submit((Optional)Optional.of((Object)this.eventSubmitter), (String)"gobblin.hive.validation.FindHiveTables");
            while (iterator.hasNext()) {
                ConvertibleHiveDataset hiveDataset = (ConvertibleHiveDataset)iterator.next();
                AutoReturnableObject client = hiveDataset.getClientPool().getClient();
                Throwable throwable = null;
                try {
                    log.info((Object)String.format("Validating dataset: %s", hiveDataset));
                    if (HiveUtils.isPartitioned((Table)hiveDataset.getTable())) {
                        this.processPartitionedTable(hiveDataset, (AutoReturnableObject<IMetaStoreClient>)client);
                        continue;
                    }
                    this.processNonPartitionedTable(hiveDataset);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            log.info((Object)String.format("Waiting for %d futures to complete", this.futures.size()));
            this.exec.shutdown();
            this.exec.awaitTermination(4L, TimeUnit.HOURS);
            boolean oneFutureFailure = false;
            for (Future<Void> future : this.futures) {
                try {
                    future.get();
                }
                catch (Throwable t) {
                    log.error((Object)"getValidationOutputFromHive failed", t);
                    oneFutureFailure = true;
                }
            }
            for (Map.Entry entry : this.successfulConversions.entrySet()) {
                log.info((Object)String.format("Successful conversion: %s [%s]", entry.getKey(), entry.getValue()));
            }
            for (Map.Entry entry : this.warnConversions.entrySet()) {
                log.warn((Object)String.format("No conversion found for: %s [%s]", entry.getKey(), entry.getValue()));
            }
            for (Map.Entry entry : this.failedConversions.entrySet()) {
                log.error((Object)String.format("Failed conversion: %s [%s]", entry.getKey(), entry.getValue()));
            }
            for (Map.Entry entry : this.dataValidationSuccessful.entrySet()) {
                log.info((Object)String.format("Data validation successful: %s [%s]", entry.getKey(), entry.getValue()));
            }
            for (Map.Entry entry : this.dataValidationFailed.entrySet()) {
                log.error((Object)String.format("Data validation failed: %s [%s]", entry.getKey(), entry.getValue()));
            }
            if (!this.failedConversions.isEmpty() || !this.dataValidationFailed.isEmpty()) {
                throw new RuntimeException(String.format("Validation failed for %s conversions. See previous logs for exact validation failures", this.failedConversions.size()));
            }
            if (oneFutureFailure) {
                throw new RuntimeException("At least one hive ddl failed. Check previous logs");
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void processNonPartitionedTable(final ConvertibleHiveDataset hiveDataset) throws IOException {
        try {
            final long updateTime = this.updateProvider.getUpdateTime(hiveDataset.getTable());
            log.info((Object)String.format("Validating table: %s", hiveDataset.getTable()));
            for (final String format : hiveDataset.getDestFormats()) {
                Optional conversionConfigOptional = hiveDataset.getConversionConfigForFormat(format);
                if (conversionConfigOptional.isPresent()) {
                    ConvertibleHiveDataset.ConversionConfig conversionConfig = (ConvertibleHiveDataset.ConversionConfig)conversionConfigOptional.get();
                    String orcTableName = conversionConfig.getDestinationTableName();
                    String orcTableDatabase = conversionConfig.getDestinationDbName();
                    Pair destinationMeta = HiveConverterUtils.getDestinationTableMeta((String)orcTableDatabase, (String)orcTableName, (Properties)this.props);
                    final List validationQueries = HiveValidationQueryGenerator.generateCountValidationQueries((HiveDataset)hiveDataset, (Optional)Optional.absent(), (ConvertibleHiveDataset.ConversionConfig)conversionConfig);
                    final ArrayList dataValidationQueries = Lists.newArrayList((Object[])new String[]{HiveValidationQueryGenerator.generateDataValidationQuery((String)hiveDataset.getTable().getTableName(), (String)hiveDataset.getTable().getDbName(), (org.apache.hadoop.hive.metastore.api.Table)((org.apache.hadoop.hive.metastore.api.Table)((Optional)destinationMeta.getKey()).get()), (Optional)Optional.absent(), (boolean)this.isNestedORC)});
                    this.futures.add(this.exec.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            log.debug((Object)String.format("Going to execute queries: %s for format: %s", validationQueries, format));
                            List rowCounts = ValidationJob.this.getValidationOutputFromHive(validationQueries);
                            log.debug((Object)String.format("Going to execute queries: %s for format: %s", dataValidationQueries, format));
                            List rowDataValidatedCount = ValidationJob.this.getValidationOutputFromHive(dataValidationQueries);
                            ValidationJob.this.validateAndPopulateReport(hiveDataset.getTable().getCompleteName(), updateTime, rowCounts, rowDataValidatedCount);
                            return null;
                        }
                    }));
                    continue;
                }
                log.warn((Object)String.format("No config found for format: %s So skipping table: %s for this format", format, hiveDataset.getTable().getCompleteName()));
            }
        }
        catch (UncheckedExecutionException e) {
            log.warn((Object)String.format("Not validating table: %s %s", hiveDataset.getTable().getCompleteName(), e.getMessage()));
        }
        catch (UpdateNotFoundException e) {
            log.warn((Object)String.format("Not validating table: %s as update time was not found. %s", hiveDataset.getTable().getCompleteName(), e.getMessage()));
        }
    }

    private void processPartitionedTable(ConvertibleHiveDataset hiveDataset, AutoReturnableObject<IMetaStoreClient> client) throws IOException {
        List sourcePartitions = HiveUtils.getPartitions((IMetaStoreClient)((IMetaStoreClient)client.get()), (Table)hiveDataset.getTable(), (Optional)Optional.absent());
        for (final String format : hiveDataset.getDestFormats()) {
            Optional conversionConfigOptional = hiveDataset.getConversionConfigForFormat(format);
            if (conversionConfigOptional.isPresent()) {
                ConvertibleHiveDataset.ConversionConfig conversionConfig = (ConvertibleHiveDataset.ConversionConfig)conversionConfigOptional.get();
                String orcTableName = conversionConfig.getDestinationTableName();
                String orcTableDatabase = conversionConfig.getDestinationDbName();
                Pair destinationMeta = HiveConverterUtils.getDestinationTableMeta((String)orcTableDatabase, (String)orcTableName, (Properties)this.props);
                for (final Partition sourcePartition : sourcePartitions) {
                    try {
                        final long updateTime = this.updateProvider.getUpdateTime(sourcePartition);
                        if (this.shouldValidate(sourcePartition)) {
                            log.info((Object)String.format("Validating partition: %s", sourcePartition.getCompleteName()));
                            final List countValidationQueries = HiveValidationQueryGenerator.generateCountValidationQueries((HiveDataset)hiveDataset, (Optional)Optional.of((Object)sourcePartition), (ConvertibleHiveDataset.ConversionConfig)conversionConfig);
                            final ArrayList dataValidationQueries = Lists.newArrayList((Object[])new String[]{HiveValidationQueryGenerator.generateDataValidationQuery((String)hiveDataset.getTable().getTableName(), (String)hiveDataset.getTable().getDbName(), (org.apache.hadoop.hive.metastore.api.Table)((org.apache.hadoop.hive.metastore.api.Table)((Optional)destinationMeta.getKey()).get()), (Optional)Optional.of((Object)sourcePartition), (boolean)this.isNestedORC)});
                            this.futures.add(this.exec.submit(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    log.debug((Object)String.format("Going to execute count validation queries queries: %s for format: %s and partition %s", countValidationQueries, format, sourcePartition.getCompleteName()));
                                    List rowCounts = ValidationJob.this.getValidationOutputFromHive(countValidationQueries);
                                    log.debug((Object)String.format("Going to execute data validation queries: %s for format: %s and partition %s", dataValidationQueries, format, sourcePartition.getCompleteName()));
                                    List rowDataValidatedCount = ValidationJob.this.getValidationOutputFromHive(dataValidationQueries);
                                    ValidationJob.this.validateAndPopulateReport(sourcePartition.getCompleteName(), updateTime, rowCounts, rowDataValidatedCount);
                                    return null;
                                }
                            }));
                            continue;
                        }
                        log.debug((Object)String.format("Not validating partition: %s as updateTime: %s is not in range of max look back: %s and skip recent than: %s", sourcePartition.getCompleteName(), updateTime, this.maxLookBackTime, this.skipRecentThanTime));
                    }
                    catch (UncheckedExecutionException e) {
                        log.warn((Object)String.format("Not validating partition: %s %s", sourcePartition.getCompleteName(), e.getMessage()));
                    }
                    catch (UpdateNotFoundException e) {
                        log.warn((Object)String.format("Not validating partition: %s as update time was not found. %s", sourcePartition.getCompleteName(), e.getMessage()));
                    }
                }
                continue;
            }
            log.info((Object)String.format("No conversion config found for format %s. Ignoring data validation", format));
        }
    }

    private List<Long> getValidationOutputFromHiveJdbc(List<String> queries) throws IOException {
        if (null == queries || queries.size() == 0) {
            log.warn((Object)"No queries specified to be executed");
            return Collections.emptyList();
        }
        Statement statement = null;
        ArrayList rowCounts = Lists.newArrayList();
        Closer closer = Closer.create();
        try {
            HiveJdbcConnector hiveJdbcConnector = HiveJdbcConnector.newConnectorWithProps((Properties)this.props);
            statement = hiveJdbcConnector.getConnection().createStatement();
            for (String query : queries) {
                log.info((Object)("Executing query: " + query));
                boolean result = statement.execute(query);
                if (result) {
                    ResultSet resultSet = statement.getResultSet();
                    if (!resultSet.next()) continue;
                    rowCounts.add(resultSet.getLong(1));
                    continue;
                }
                log.warn((Object)("Query output for: " + query + " : " + result));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                closer.close();
            }
            catch (Exception e) {
                log.warn((Object)"Could not close HiveJdbcConnector", (Throwable)e);
            }
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Could not close Hive statement", (Throwable)e);
                }
            }
        }
        return rowCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Temporary fix")
    private List<Long> getValidationOutputFromHive(List<String> queries) throws IOException {
        if (null == queries || queries.size() == 0) {
            log.warn((Object)"No queries specified to be executed");
            return Collections.emptyList();
        }
        ArrayList rowCounts = Lists.newArrayList();
        Closer closer = Closer.create();
        try {
            HiveJdbcConnector hiveJdbcConnector = (HiveJdbcConnector)closer.register((Closeable)HiveJdbcConnector.newConnectorWithProps((Properties)this.props));
            for (String query : queries) {
                String hiveOutput = "hiveConversionValidationOutput_" + UUID.randomUUID().toString();
                Path hiveTempDir = new Path("/tmp/" + hiveOutput);
                query = "INSERT OVERWRITE DIRECTORY '" + hiveTempDir + "' " + query;
                log.info((Object)("Executing query: " + query));
                try {
                    if (this.hiveSettings.size() > 0) {
                        hiveJdbcConnector.executeStatements(this.hiveSettings.toArray(new String[this.hiveSettings.size()]));
                    }
                    hiveJdbcConnector.executeStatements(new String[]{"SET hive.exec.compress.output=false", "SET hive.auto.convert.join=false", query});
                    FileStatus[] fileStatusList = this.fs.listStatus(hiveTempDir);
                    ArrayList<FileStatus> files = new ArrayList<FileStatus>();
                    for (FileStatus fileStatus : fileStatusList) {
                        if (!fileStatus.isFile()) continue;
                        files.add(fileStatus);
                    }
                    if (files.size() > 1) {
                        log.warn((Object)"Found more than one output file. Should have been one.");
                        continue;
                    }
                    if (files.size() == 0) {
                        log.warn((Object)"Found no output file. Should have been one.");
                        continue;
                    }
                    String theString = IOUtils.toString((Reader)new InputStreamReader((InputStream)this.fs.open(((FileStatus)files.get(0)).getPath()), Charsets.UTF_8));
                    log.info((Object)("Found row count: " + theString.trim()));
                    if (StringUtils.isBlank((CharSequence)theString.trim())) {
                        rowCounts.add(0L);
                        continue;
                    }
                    try {
                        rowCounts.add(Long.parseLong(theString.trim()));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Could not parse Hive output: " + theString.trim(), e);
                    }
                }
                finally {
                    if (!this.fs.exists(hiveTempDir)) continue;
                    log.debug((Object)("Deleting temp dir: " + hiveTempDir));
                    this.fs.delete(hiveTempDir, true);
                }
            }
        }
        catch (SQLException e) {
            log.warn((Object)("Execution failed for query set " + queries.toString()), (Throwable)e);
        }
        finally {
            try {
                closer.close();
            }
            catch (Exception e) {
                log.warn((Object)"Could not close HiveJdbcConnector", (Throwable)e);
            }
        }
        return rowCounts;
    }

    private void validateAndPopulateReport(String datasetIdentifier, long conversionInstance, List<Long> rowCounts, List<Long> rowDataValidatedCount) {
        if (null == rowCounts || rowCounts.size() == 0) {
            this.warnConversions.put(String.format("Dataset: %s Instance: %s", datasetIdentifier, conversionInstance), "No conversion details found");
            this.eventSubmitter.submit("gobblin.hive.validation.ValidationNoop", (Map)ImmutableMap.of((Object)"datasetUrn", (Object)datasetIdentifier));
            return;
        }
        if (null == rowDataValidatedCount || rowDataValidatedCount.size() == 0) {
            this.warnConversions.put(String.format("Dataset: %s Instance: %s", datasetIdentifier, conversionInstance), "No conversion details found");
            this.eventSubmitter.submit("gobblin.hive.validation.ValidationNoop", (Map)ImmutableMap.of((Object)"datasetUrn", (Object)datasetIdentifier));
            return;
        }
        long rowCountCached = -1L;
        boolean isFirst = true;
        for (Long rowCount : rowCounts) {
            if (isFirst) {
                rowCountCached = rowCount;
                isFirst = false;
                continue;
            }
            if (rowCount != rowCountCached) {
                if (rowCount == 0L) {
                    this.warnConversions.put(String.format("Dataset: %s Instance: %s", datasetIdentifier, conversionInstance), "Row counts found 0, may be the conversion is delayed.");
                    this.eventSubmitter.submit("gobblin.hive.validation.ValidationNoop", (Map)ImmutableMap.of((Object)"datasetUrn", (Object)datasetIdentifier));
                    continue;
                }
                this.failedConversions.put(String.format("Dataset: %s Instance: %s", datasetIdentifier, conversionInstance), String.format("Row counts did not match across all conversions. Row count expected: %d, Row count got: %d", rowCountCached, rowCount));
                this.eventSubmitter.submit("gobblin.hive.validation.ValidationFailed", (Map)ImmutableMap.of((Object)"datasetUrn", (Object)datasetIdentifier));
                return;
            }
            this.successfulConversions.put(String.format("Dataset: %s Instance: %s", datasetIdentifier, conversionInstance), String.format("Row counts matched across all conversions. Row count expected: %d, Row count got: %d", rowCountCached, rowCount));
            this.eventSubmitter.submit("gobblin.hive.validation.ValidationSuccessful", (Map)ImmutableMap.of((Object)"datasetUrn", (Object)datasetIdentifier));
        }
        if (rowCountCached == rowDataValidatedCount.get(0)) {
            this.dataValidationSuccessful.put(String.format("Dataset: %s Instance: %s", datasetIdentifier, conversionInstance), "Common rows matched expected value. Expected: " + rowCountCached + " Found: " + rowDataValidatedCount);
        } else {
            this.dataValidationFailed.put(String.format("Dataset: %s Instance: %s", datasetIdentifier, conversionInstance), "Common rows did not match expected value. Expected: " + rowCountCached + " Found: " + rowDataValidatedCount);
        }
    }

    private static FileSystem getSourceFs() throws IOException {
        return FileSystem.get((Configuration)HadoopUtils.newConfiguration());
    }

    private boolean shouldValidate(Partition partition) {
        for (String pathToken : this.ignoreDataPathIdentifierList) {
            if (!partition.getDataLocation().toString().toLowerCase().contains(pathToken.toLowerCase())) continue;
            log.info((Object)("Skipping partition " + partition.getCompleteName() + " containing invalid token " + pathToken.toLowerCase()));
            return false;
        }
        try {
            boolean withinTimeWindow;
            long createTime = ValidationJob.getPartitionCreateTime(partition.getName());
            boolean bl = withinTimeWindow = new DateTime(createTime).isAfter(this.maxLookBackTime) && new DateTime(createTime).isBefore(this.skipRecentThanTime);
            if (withinTimeWindow) {
                log.info((Object)("Validating partition " + partition.getCompleteName()));
                return withinTimeWindow;
            }
            log.info((Object)("Skipping partition " + partition.getCompleteName() + " as create time " + new DateTime(createTime).toString() + " is not within validation time window "));
        }
        catch (ParseException e) {
            Throwables.propagate((Throwable)e);
        }
        return false;
    }

    public static Long getPartitionCreateTime(String partitionName) throws ParseException {
        String dateString = null;
        for (String st : SLASH_SPLITTER.splitToList((CharSequence)partitionName)) {
            if (!st.startsWith(DATEPARTITION)) continue;
            dateString = (String)EQUALITY_SPLITTER.splitToList((CharSequence)st).get(1);
        }
        Preconditions.checkNotNull(dateString, (Object)"Unable to get partition date");
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        return dateFormat.parse(dateString).getTime();
    }
}

