/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.ingestion.google.webmaster.ProducerJob;
import org.apache.gobblin.ingestion.google.webmaster.UrlTrie;
import org.apache.gobblin.ingestion.google.webmaster.UrlTrieNode;
import org.apache.gobblin.ingestion.google.webmaster.UrlTriePrefixGrouper;

public class TrieBasedProducerJob
extends ProducerJob {
    private final String _startDate;
    private final String _endDate;
    private final int _groupSize;
    private final Triple<String, GoogleWebmasterFilter.FilterOperator, UrlTrieNode> _jobNode;

    TrieBasedProducerJob(String startDate, String endDate, Triple<String, GoogleWebmasterFilter.FilterOperator, UrlTrieNode> jobNode, int groupSize) {
        this._startDate = startDate;
        this._endDate = endDate;
        this._jobNode = jobNode;
        this._groupSize = groupSize;
    }

    @Override
    public String getPage() {
        return (String)this._jobNode.getLeft();
    }

    @Override
    public String getStartDate() {
        return this._startDate;
    }

    @Override
    public String getEndDate() {
        return this._endDate;
    }

    @Override
    public GoogleWebmasterFilter.FilterOperator getOperator() {
        return (GoogleWebmasterFilter.FilterOperator)((Object)this._jobNode.getMiddle());
    }

    @Override
    public int getPagesSize() {
        if (this.isOperatorEquals()) {
            return 1;
        }
        return ((UrlTrieNode)this._jobNode.getRight()).getSize();
    }

    @Override
    public List<? extends ProducerJob> partitionJobs() {
        UrlTrieNode root = (UrlTrieNode)this._jobNode.getRight();
        if (this.isOperatorEquals() || root.getSize() == 1) {
            return super.partitionJobs();
        }
        if (this._groupSize <= 1) {
            throw new RuntimeException("This is impossible. When group size is 1, the operator must be equals");
        }
        UrlTrie trie = new UrlTrie(this.getPage(), root);
        int gs = Math.min(root.getSize(), this._groupSize);
        UrlTriePrefixGrouper grouper = new UrlTriePrefixGrouper(trie, (int)Math.ceil((double)gs / 2.0));
        ArrayList<TrieBasedProducerJob> jobs = new ArrayList<TrieBasedProducerJob>();
        while (grouper.hasNext()) {
            jobs.add(new TrieBasedProducerJob(this._startDate, this._endDate, grouper.next(), grouper.getGroupSize()));
        }
        return jobs;
    }

    private boolean isOperatorEquals() {
        return this.getOperator().equals((Object)GoogleWebmasterFilter.FilterOperator.EQUALS);
    }

    public String toString() {
        return String.format("TrieBasedProducerJob{_page='%s', _startDate='%s', _endDate='%s', _operator='%s', _groupSize='%s', _nodeSize='%s'}", new Object[]{this.getPage(), this._startDate, this._endDate, this.getOperator(), this._groupSize, ((UrlTrieNode)this._jobNode.getRight()).getSize()});
    }

    public int getGroupSize() {
        return this._groupSize;
    }
}

