/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.gson.Gson;
import org.apache.gobblin.data.management.copy.CopyableDatasetBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyableDatasetMetadata {
    private static final Logger log = LoggerFactory.getLogger(CopyableDatasetMetadata.class);
    private final String datasetURN;
    private static final Gson GSON = new Gson();

    public CopyableDatasetMetadata(CopyableDatasetBase copyableDataset) {
        this.datasetURN = copyableDataset.datasetURN();
    }

    public String serialize() {
        return GSON.toJson((Object)this);
    }

    public static CopyableDatasetMetadata deserialize(String serialized) {
        return (CopyableDatasetMetadata)GSON.fromJson(CopyableDatasetMetadata.getSerializedWithNewPackage(serialized), CopyableDatasetMetadata.class);
    }

    private static String getSerializedWithNewPackage(String serialized) {
        serialized = serialized.replace("\"gobblin.data.management.", "\"org.apache.gobblin.data.management.");
        log.debug("Serialized updated copy entity: " + serialized);
        return serialized;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyableDatasetMetadata)) {
            return false;
        }
        CopyableDatasetMetadata other = (CopyableDatasetMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$datasetURN = this.getDatasetURN();
        String other$datasetURN = other.getDatasetURN();
        return !(this$datasetURN == null ? other$datasetURN != null : !this$datasetURN.equals(other$datasetURN));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CopyableDatasetMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $datasetURN = this.getDatasetURN();
        result = result * 59 + ($datasetURN == null ? 43 : $datasetURN.hashCode());
        return result;
    }

    public String toString() {
        return "CopyableDatasetMetadata(datasetURN=" + this.getDatasetURN() + ")";
    }

    public String getDatasetURN() {
        return this.datasetURN;
    }
}

