/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.extractor;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.conversion.hive.source.HiveWorkUnit;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.source.extractor.Extractor;

public abstract class HiveBaseExtractor<S, D>
implements Extractor<S, D> {
    protected HiveWorkUnit hiveWorkUnit;
    protected HiveDataset hiveDataset;
    protected String dbName;
    protected String tableName;
    protected HiveMetastoreClientPool pool;

    public HiveBaseExtractor(WorkUnitState state) throws IOException {
        if (Boolean.valueOf(state.getPropAsBoolean("hive.source.watermark.isWatermarkWorkUnit")).booleanValue()) {
            return;
        }
        this.hiveWorkUnit = new HiveWorkUnit(state.getWorkunit());
        this.hiveDataset = this.hiveWorkUnit.getHiveDataset();
        this.dbName = this.hiveDataset.getDbAndTable().getDb();
        this.tableName = this.hiveDataset.getDbAndTable().getTable();
        this.pool = HiveMetastoreClientPool.get((Properties)state.getJobState().getProperties(), (Optional)Optional.fromNullable((Object)state.getJobState().getProp("hive.dataset.hive.metastore.uri")));
    }

    public long getExpectedRecordCount() {
        return 1L;
    }

    public long getHighWatermark() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

