/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.dataset;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.gobblin.data.management.conversion.hive.entities.StageableTableMetadata;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertibleHiveDataset
extends HiveDataset {
    private static final Logger log = LoggerFactory.getLogger(ConvertibleHiveDataset.class);
    public static final String DESTINATION_CONVERSION_FORMATS_KEY = "destinationFormats";
    private final Set<String> destFormats;
    private final Map<String, ConversionConfig> destConversionConfigs;

    public ConvertibleHiveDataset(FileSystem fs, HiveMetastoreClientPool clientPool, Table table, Properties jobProps, Config config) {
        super(fs, clientPool, table, jobProps, config);
        Preconditions.checkArgument((boolean)config.hasPath(DESTINATION_CONVERSION_FORMATS_KEY), (Object)String.format("Atleast one destination format should be specified at %s.%s. If you do not intend to convert this dataset set %s.%s to true", this.properties.getProperty("hive.dataset.configPrefix", ""), DESTINATION_CONVERSION_FORMATS_KEY, this.properties.getProperty("hive.dataset.configPrefix", ""), "is.blacklisted"));
        this.destFormats = Sets.newHashSet((Iterable)ConfigUtils.getStringList((Config)this.datasetConfig, (String)DESTINATION_CONVERSION_FORMATS_KEY));
        this.destConversionConfigs = Maps.newHashMap();
        for (String format : this.destFormats) {
            if (!this.datasetConfig.hasPath(format)) continue;
            log.debug("Found desination format: " + format);
            this.destConversionConfigs.put(format, new ConversionConfig(this.datasetConfig.getConfig(format), table, format));
        }
    }

    public Optional<ConversionConfig> getConversionConfigForFormat(String format) {
        return Optional.fromNullable((Object)this.destConversionConfigs.get(format));
    }

    @Override
    public String toString() {
        return "ConvertibleHiveDataset(destFormats=" + this.getDestFormats() + ", destConversionConfigs=" + this.destConversionConfigs + ")";
    }

    public Set<String> getDestFormats() {
        return this.destFormats;
    }

    public static class ConversionConfig
    extends StageableTableMetadata {
        public static final String DESTINATION_VIEW_KEY = "destination.viewName";
        public static final String UPDATE_VIEW_ALWAYS_ENABLED = "updateViewAlways.enabled";
        private final String destinationFormat;
        private final Optional<String> destinationViewName;
        private final boolean updateViewAlwaysEnabled;

        private ConversionConfig(Config config, Table table, String destinationFormat) {
            super(config, table);
            this.destinationFormat = destinationFormat;
            this.destinationViewName = Optional.fromNullable((Object)HiveDataset.resolveTemplate(ConfigUtils.getString((Config)config, (String)DESTINATION_VIEW_KEY, null), table));
            this.updateViewAlwaysEnabled = ConfigUtils.getBoolean((Config)config, (String)UPDATE_VIEW_ALWAYS_ENABLED, (boolean)true);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConversionConfig that = (ConversionConfig)o;
            if (this.isUpdateViewAlwaysEnabled() != that.isUpdateViewAlwaysEnabled()) {
                return false;
            }
            if (!this.getDestinationFormat().equals(that.getDestinationFormat())) {
                return false;
            }
            return this.getDestinationViewName().equals(that.getDestinationViewName());
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.getDestinationFormat().hashCode();
            result = 31 * result + this.getDestinationViewName().hashCode();
            result = 31 * result + (this.isUpdateViewAlwaysEnabled() ? 1 : 0);
            return result;
        }

        public String getDestinationFormat() {
            return this.destinationFormat;
        }

        public Optional<String> getDestinationViewName() {
            return this.destinationViewName;
        }

        public boolean isUpdateViewAlwaysEnabled() {
            return this.updateViewAlwaysEnabled;
        }

        @Override
        public String toString() {
            return "ConvertibleHiveDataset.ConversionConfig(destinationFormat=" + this.getDestinationFormat() + ", destinationViewName=" + this.getDestinationViewName() + ", updateViewAlwaysEnabled=" + this.isUpdateViewAlwaysEnabled() + ")";
        }
    }
}

