/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.FlowProps;
import azkaban.flow.Node;
import azkaban.project.Project;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManager;
import azkaban.project.ProjectManagerException;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleManager;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.user.Permission;
import azkaban.user.Role;
import azkaban.user.User;
import azkaban.user.UserManager;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ProjectManagerServlet
extends LoginAbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ProjectManagerServlet.class);
    private static final NodeLevelComparator NODE_LEVEL_COMPARATOR = new NodeLevelComparator();
    private static final String LOCKDOWN_CREATE_PROJECTS_KEY = "lockdown.create.projects";
    private ProjectManager projectManager;
    private ExecutorManagerAdapter executorManager;
    private ScheduleManager scheduleManager;
    private UserManager userManager;
    private boolean lockdownCreateProjects = false;
    private static Comparator<Flow> FLOW_ID_COMPARATOR = new Comparator<Flow>(){

        @Override
        public int compare(Flow f1, Flow f2) {
            return f1.getId().compareTo(f2.getId());
        }
    };

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.projectManager = server.getProjectManager();
        this.executorManager = server.getExecutorManager();
        this.scheduleManager = server.getScheduleManager();
        this.userManager = server.getUserManager();
        this.lockdownCreateProjects = server.getServerProps().getBoolean(LOCKDOWN_CREATE_PROJECTS_KEY, false);
        if (this.lockdownCreateProjects) {
            logger.info((Object)"Creation of projects is locked down");
        }
    }

    @Override
    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "project")) {
            if (this.hasParam(req, "ajax")) {
                this.handleAJAXAction(req, resp, session);
            } else if (this.hasParam(req, "logs")) {
                this.handleProjectLogsPage(req, resp, session);
            } else if (this.hasParam(req, "permissions")) {
                this.handlePermissionPage(req, resp, session);
            } else if (this.hasParam(req, "prop")) {
                this.handlePropertyPage(req, resp, session);
            } else if (this.hasParam(req, "history")) {
                this.handleJobHistoryPage(req, resp, session);
            } else if (this.hasParam(req, "job")) {
                this.handleJobPage(req, resp, session);
            } else if (this.hasParam(req, "flow")) {
                this.handleFlowPage(req, resp, session);
            } else if (this.hasParam(req, "delete")) {
                this.handleRemoveProject(req, resp, session);
            } else {
                this.handleProjectPage(req, resp, session);
            }
            return;
        }
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/projectpage.vm");
        page.add("errorMsg", "No project set.");
        page.render();
    }

    @Override
    protected void handleMultiformPost(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, Session session) throws ServletException, IOException {
        String action;
        if (params.containsKey("ajax")) {
            String action2 = (String)params.get("ajax");
            HashMap<String, String> ret = new HashMap<String, String>();
            if (action2.equals("upload")) {
                this.ajaxHandleUpload(req, ret, params, session);
            }
            this.writeJSON(resp, ret);
        } else if (params.containsKey("action") && (action = (String)params.get("action")).equals("upload")) {
            this.handleUpload(req, resp, params, session);
        }
    }

    @Override
    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        String action;
        if (this.hasParam(req, "action") && (action = this.getParam(req, "action")).equals("create")) {
            this.handleCreate(req, resp, session);
        }
    }

    private void handleAJAXAction(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        String projectName = this.getParam(req, "project");
        User user = session.getUser();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("project", projectName);
        Project project = this.projectManager.getProject(projectName);
        if (project == null) {
            ret.put("error", "Project " + projectName + " doesn't exist.");
            return;
        }
        ret.put("projectId", project.getId());
        String ajaxName = this.getParam(req, "ajax");
        if (ajaxName.equals("fetchProjectLogs")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchProjectLogEvents(project, req, resp, ret, user);
            }
        } else if (ajaxName.equals("fetchflowjobs")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchFlow(project, ret, req, resp);
            }
        } else if (ajaxName.equals("fetchflowdetails")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchFlowDetails(project, ret, req);
            }
        } else if (ajaxName.equals("fetchflowgraph")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchFlowGraph(project, ret, req);
            }
        } else if (ajaxName.equals("fetchflownodedata")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchFlowNodeData(project, ret, req);
            }
        } else if (ajaxName.equals("fetchprojectflows")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchProjectFlows(project, ret, req);
            }
        } else if (ajaxName.equals("changeDescription")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.WRITE, ret)) {
                this.ajaxChangeDescription(project, ret, req, user);
            }
        } else if (ajaxName.equals("getPermissions")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxGetPermissions(project, ret);
            }
        } else if (ajaxName.equals("changePermission")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.ADMIN, ret)) {
                this.ajaxChangePermissions(project, ret, req, user);
            }
        } else if (ajaxName.equals("addPermission")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.ADMIN, ret)) {
                this.ajaxAddPermission(project, ret, req, user);
            }
        } else if (ajaxName.equals("addProxyUser")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.ADMIN, ret)) {
                this.ajaxAddProxyUser(project, ret, req, user);
            }
        } else if (ajaxName.equals("removeProxyUser")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.ADMIN, ret)) {
                this.ajaxRemoveProxyUser(project, ret, req, user);
            }
        } else if (ajaxName.equals("fetchFlowExecutions")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchFlowExecutions(project, ret, req);
            }
        } else if (ajaxName.equals("fetchLastSuccessfulFlowExecution")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchLastSuccessfulFlowExecution(project, ret, req);
            }
        } else if (ajaxName.equals("fetchJobInfo")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.READ, ret)) {
                this.ajaxFetchJobInfo(project, ret, req);
            }
        } else if (ajaxName.equals("setJobOverrideProperty")) {
            if (this.handleAjaxPermission(project, user, Permission.Type.WRITE, ret)) {
                this.ajaxSetJobOverrideProperty(project, ret, req);
            }
        } else {
            ret.put("error", "Cannot execute command " + ajaxName);
        }
        if (ret != null) {
            this.writeJSON(resp, ret);
        }
    }

    private boolean handleAjaxPermission(Project project, User user, Permission.Type type, Map<String, Object> ret) {
        if (this.hasPermission(project, user, type)) {
            return true;
        }
        ret.put("error", "Permission denied. Need " + type.toString() + " access.");
        return false;
    }

    private void ajaxFetchProjectLogEvents(Project project, HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user) throws ServletException {
        if (!this.hasPermission(project, user, Permission.Type.READ)) {
            ret.put("error", "Permission denied. Need READ access.");
            return;
        }
        int num = this.getIntParam(req, "size", 1000);
        int skip = this.getIntParam(req, "skip", 0);
        List<ProjectLogEvent> logEvents = null;
        try {
            logEvents = this.projectManager.getProjectEventLogs(project, num, skip);
        }
        catch (ProjectManagerException e) {
            throw new ServletException((Throwable)e);
        }
        String[] columns = new String[]{"user", "time", "type", "message"};
        ret.put("columns", columns);
        ArrayList<Object[]> eventData = new ArrayList<Object[]>();
        for (ProjectLogEvent events : logEvents) {
            Object[] entry = new Object[]{events.getUser(), events.getTime(), events.getType(), events.getMessage()};
            eventData.add(entry);
        }
        ret.put("logData", eventData);
    }

    private List<String> getFlowJobTypes(Flow flow) {
        HashSet<String> jobTypeSet = new HashSet<String>();
        for (Node node : flow.getNodes()) {
            jobTypeSet.add(node.getType());
        }
        ArrayList<String> jobTypes = new ArrayList<String>();
        jobTypes.addAll(jobTypeSet);
        return jobTypes;
    }

    private void ajaxFetchFlowDetails(Project project, HashMap<String, Object> ret, HttpServletRequest req) throws ServletException {
        String flowName = this.getParam(req, "flow");
        Flow flow = null;
        try {
            flow = project.getFlow(flowName);
            if (flow == null) {
                ret.put("error", "Flow " + flowName + " not found.");
                return;
            }
            ret.put("jobTypes", this.getFlowJobTypes(flow));
        }
        catch (AccessControlException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxFetchLastSuccessfulFlowExecution(Project project, HashMap<String, Object> ret, HttpServletRequest req) throws ServletException {
        String flowId = this.getParam(req, "flow");
        List<ExecutableFlow> exFlows = null;
        try {
            exFlows = this.executorManager.getExecutableFlows(project.getId(), flowId, 0, 1, Status.SUCCEEDED);
        }
        catch (ExecutorManagerException e) {
            ret.put("error", "Error retrieving executable flows");
            return;
        }
        if (exFlows.size() == 0) {
            ret.put("success", "false");
            ret.put("message", "This flow has no successful run.");
            return;
        }
        ret.put("success", "true");
        ret.put("message", "");
        ret.put("execId", exFlows.get(0).getExecutionId());
    }

    private void ajaxFetchFlowExecutions(Project project, HashMap<String, Object> ret, HttpServletRequest req) throws ServletException {
        String flowId = this.getParam(req, "flow");
        int from = Integer.valueOf(this.getParam(req, "start"));
        int length = Integer.valueOf(this.getParam(req, "length"));
        ArrayList<ExecutableFlow> exFlows = new ArrayList<ExecutableFlow>();
        int total = 0;
        try {
            total = this.executorManager.getExecutableFlows(project.getId(), flowId, from, length, exFlows);
        }
        catch (ExecutorManagerException e) {
            ret.put("error", "Error retrieving executable flows");
        }
        ret.put("flow", flowId);
        ret.put("total", total);
        ret.put("from", from);
        ret.put("length", length);
        ArrayList history = new ArrayList();
        for (ExecutableFlow flow : exFlows) {
            HashMap<String, Object> flowInfo = new HashMap<String, Object>();
            flowInfo.put("execId", flow.getExecutionId());
            flowInfo.put("flowId", flow.getFlowId());
            flowInfo.put("projectId", flow.getProjectId());
            flowInfo.put("status", flow.getStatus().toString());
            flowInfo.put("submitTime", flow.getSubmitTime());
            flowInfo.put("startTime", flow.getStartTime());
            flowInfo.put("endTime", flow.getEndTime());
            flowInfo.put("submitUser", flow.getSubmitUser());
            history.add(flowInfo);
        }
        ret.put("executions", history);
    }

    private void handleRemoveProject(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        User user = session.getUser();
        String projectName = this.getParam(req, "project");
        Project project = this.projectManager.getProject(projectName);
        if (project == null) {
            this.setErrorMessageInCookie(resp, "Project " + projectName + " doesn't exist.");
            resp.sendRedirect(req.getContextPath());
            return;
        }
        if (!this.hasPermission(project, user, Permission.Type.ADMIN)) {
            this.setErrorMessageInCookie(resp, "Cannot delete. User '" + user.getUserId() + "' is not an ADMIN.");
            resp.sendRedirect(req.getRequestURI() + "?project=" + projectName);
            return;
        }
        Schedule sflow = null;
        try {
            for (Schedule flow : this.scheduleManager.getSchedules()) {
                if (flow.getProjectId() != project.getId()) continue;
                sflow = flow;
                break;
            }
        }
        catch (ScheduleManagerException e) {
            throw new ServletException((Throwable)e);
        }
        if (sflow != null) {
            this.setErrorMessageInCookie(resp, "Cannot delete. Please unschedule " + sflow.getScheduleName() + ".");
            resp.sendRedirect(req.getRequestURI() + "?project=" + projectName);
            return;
        }
        ExecutableFlow exflow = null;
        for (ExecutableFlow flow : this.executorManager.getRunningFlows()) {
            if (flow.getProjectId() != project.getId()) continue;
            exflow = flow;
            break;
        }
        if (exflow != null) {
            this.setErrorMessageInCookie(resp, "Cannot delete. Executable flow " + exflow.getExecutionId() + " is still running.");
            resp.sendRedirect(req.getRequestURI() + "?project=" + projectName);
            return;
        }
        try {
            this.projectManager.removeProject(project, user);
        }
        catch (ProjectManagerException e) {
            this.setErrorMessageInCookie(resp, e.getMessage());
            resp.sendRedirect(req.getRequestURI() + "?project=" + projectName);
            return;
        }
        this.setSuccessMessageInCookie(resp, "Project '" + projectName + "' was successfully deleted.");
        resp.sendRedirect(req.getContextPath());
    }

    private void ajaxChangeDescription(Project project, HashMap<String, Object> ret, HttpServletRequest req, User user) throws ServletException {
        String description = this.getParam(req, "description");
        project.setDescription(description);
        try {
            this.projectManager.updateProjectDescription(project, description, user);
        }
        catch (ProjectManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxFetchJobInfo(Project project, HashMap<String, Object> ret, HttpServletRequest req) throws ServletException {
        Props overrideProp;
        Props prop;
        String flowName = this.getParam(req, "flowName");
        String jobName = this.getParam(req, "jobName");
        Flow flow = project.getFlow(flowName);
        if (flow == null) {
            ret.put("error", "Flow " + flowName + " not found in project " + project.getName());
            return;
        }
        Node node = flow.getNode(jobName);
        if (node == null) {
            ret.put("error", "Job " + jobName + " not found in flow " + flowName);
            return;
        }
        try {
            prop = this.projectManager.getProperties(project, node.getJobSource());
        }
        catch (ProjectManagerException e) {
            ret.put("error", "Failed to retrieve job properties!");
            return;
        }
        try {
            overrideProp = this.projectManager.getJobOverrideProperty(project, jobName);
        }
        catch (ProjectManagerException e) {
            ret.put("error", "Failed to retrieve job override properties!");
            return;
        }
        ret.put("jobName", node.getId());
        ret.put("jobType", prop.get("type"));
        if (overrideProp == null) {
            overrideProp = new Props(prop);
        }
        HashMap<String, String> generalParams = new HashMap<String, String>();
        HashMap<String, String> overrideParams = new HashMap<String, String>();
        for (String ps : prop.getKeySet()) {
            generalParams.put(ps, prop.getString(ps));
        }
        for (String ops : overrideProp.getKeySet()) {
            overrideParams.put(ops, overrideProp.getString(ops));
        }
        ret.put("generalParams", generalParams);
        ret.put("overrideParams", overrideParams);
    }

    private void ajaxSetJobOverrideProperty(Project project, HashMap<String, Object> ret, HttpServletRequest req) throws ServletException {
        String flowName = this.getParam(req, "flowName");
        String jobName = this.getParam(req, "jobName");
        Flow flow = project.getFlow(flowName);
        if (flow == null) {
            ret.put("error", "Flow " + flowName + " not found in project " + project.getName());
            return;
        }
        Node node = flow.getNode(jobName);
        if (node == null) {
            ret.put("error", "Job " + jobName + " not found in flow " + flowName);
            return;
        }
        Map<String, String> jobParamGroup = this.getParamGroup(req, "jobOverride");
        Props overrideParams = new Props(null, jobParamGroup);
        try {
            this.projectManager.setJobOverrideProperty(project, overrideParams, jobName);
        }
        catch (ProjectManagerException e) {
            ret.put("error", "Failed to upload job override property");
        }
    }

    private void ajaxFetchProjectFlows(Project project, HashMap<String, Object> ret, HttpServletRequest req) throws ServletException {
        ArrayList flowList = new ArrayList();
        for (Flow flow : project.getFlows()) {
            HashMap<String, String> flowObj = new HashMap<String, String>();
            flowObj.put("flowId", flow.getId());
            flowList.add(flowObj);
        }
        ret.put("flows", flowList);
    }

    private void ajaxFetchFlowGraph(Project project, HashMap<String, Object> ret, HttpServletRequest req) throws ServletException {
        String flowId = this.getParam(req, "flow");
        this.fillFlowInfo(project, flowId, ret);
    }

    private void fillFlowInfo(Project project, String flowId, HashMap<String, Object> ret) {
        Flow flow = project.getFlow(flowId);
        ArrayList<HashMap<String, Object>> nodeList = new ArrayList<HashMap<String, Object>>();
        for (Node node : flow.getNodes()) {
            HashMap<String, Object> nodeObj = new HashMap<String, Object>();
            nodeObj.put("id", node.getId());
            nodeObj.put("type", node.getType());
            if (node.getEmbeddedFlowId() != null) {
                nodeObj.put("flowId", node.getEmbeddedFlowId());
                this.fillFlowInfo(project, node.getEmbeddedFlowId(), nodeObj);
            }
            nodeList.add(nodeObj);
            Set<Edge> inEdges = flow.getInEdges(node.getId());
            if (inEdges == null || inEdges.isEmpty()) continue;
            ArrayList<String> inEdgesList = new ArrayList<String>();
            for (Edge edge : inEdges) {
                inEdgesList.add(edge.getSourceId());
            }
            Collections.sort(inEdgesList);
            nodeObj.put("in", inEdgesList);
        }
        Collections.sort(nodeList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                String id = (String)o1.get("id");
                return id.compareTo((String)o2.get("id"));
            }
        });
        ret.put("flow", flowId);
        ret.put("nodes", nodeList);
    }

    private void ajaxFetchFlowNodeData(Project project, HashMap<String, Object> ret, HttpServletRequest req) throws ServletException {
        Props props;
        String nodeId;
        String flowId = this.getParam(req, "flow");
        Flow flow = project.getFlow(flowId);
        Node node = flow.getNode(nodeId = this.getParam(req, "node"));
        if (node == null) {
            ret.put("error", "Job " + nodeId + " doesn't exist.");
            return;
        }
        ret.put("id", nodeId);
        ret.put("flow", flowId);
        ret.put("type", node.getType());
        try {
            props = this.projectManager.getProperties(project, node.getJobSource());
        }
        catch (ProjectManagerException e) {
            ret.put("error", "Failed to upload job override property for " + nodeId);
            return;
        }
        if (props == null) {
            ret.put("error", "Properties for " + nodeId + " isn't found.");
            return;
        }
        Map<String, String> properties = PropsUtils.toStringMap(props, true);
        ret.put("props", properties);
        if (node.getType().equals("flow") && node.getEmbeddedFlowId() != null) {
            this.fillFlowInfo(project, node.getEmbeddedFlowId(), ret);
        }
    }

    private void ajaxFetchFlow(Project project, HashMap<String, Object> ret, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String flowId = this.getParam(req, "flow");
        Flow flow = project.getFlow(flowId);
        ArrayList<Node> flowNodes = new ArrayList<Node>(flow.getNodes());
        Collections.sort(flowNodes, NODE_LEVEL_COMPARATOR);
        ArrayList nodeList = new ArrayList();
        for (Node node : flowNodes) {
            HashMap<String, Object> nodeObj = new HashMap<String, Object>();
            nodeObj.put("id", node.getId());
            ArrayList<String> dependencies = new ArrayList<String>();
            Set<Edge> collection = flow.getInEdges(node.getId());
            if (collection != null) {
                for (Edge edge : collection) {
                    dependencies.add(edge.getSourceId());
                }
            }
            ArrayList<String> dependents = new ArrayList<String>();
            collection = flow.getOutEdges(node.getId());
            if (collection != null) {
                for (Edge edge : collection) {
                    dependents.add(edge.getTargetId());
                }
            }
            nodeObj.put("dependencies", dependencies);
            nodeObj.put("dependents", dependents);
            nodeObj.put("level", node.getLevel());
            nodeList.add(nodeObj);
        }
        ret.put("flowId", flowId);
        ret.put("nodes", nodeList);
    }

    private void ajaxAddProxyUser(Project project, HashMap<String, Object> ret, HttpServletRequest req, User user) throws ServletException {
        String name = this.getParam(req, "name");
        logger.info((Object)("Adding proxy user " + name + " by " + user.getUserId()));
        if (this.userManager.validateProxyUser(name, user)) {
            try {
                this.projectManager.addProjectProxyUser(project, name, user);
            }
            catch (ProjectManagerException e) {
                ret.put("error", e.getMessage());
            }
        } else {
            ret.put("error", "User " + user.getUserId() + " has no permission to add " + name + " as proxy user.");
            return;
        }
    }

    private void ajaxRemoveProxyUser(Project project, HashMap<String, Object> ret, HttpServletRequest req, User user) throws ServletException {
        String name = this.getParam(req, "name");
        logger.info((Object)("Removing proxy user " + name + " by " + user.getUserId()));
        try {
            this.projectManager.removeProjectProxyUser(project, name, user);
        }
        catch (ProjectManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxAddPermission(Project project, HashMap<String, Object> ret, HttpServletRequest req, User user) throws ServletException {
        String name = this.getParam(req, "name");
        boolean group = Boolean.parseBoolean(this.getParam(req, "group"));
        if (group) {
            if (project.getGroupPermission(name) != null) {
                ret.put("error", "Group permission already exists.");
                return;
            }
            if (!this.userManager.validateGroup(name)) {
                ret.put("error", "Group is invalid.");
                return;
            }
        } else {
            if (project.getUserPermission(name) != null) {
                ret.put("error", "User permission already exists.");
                return;
            }
            if (!this.userManager.validateUser(name)) {
                ret.put("error", "User is invalid.");
                return;
            }
        }
        boolean admin = Boolean.parseBoolean(this.getParam(req, "permissions[admin]"));
        boolean read = Boolean.parseBoolean(this.getParam(req, "permissions[read]"));
        boolean write = Boolean.parseBoolean(this.getParam(req, "permissions[write]"));
        boolean execute = Boolean.parseBoolean(this.getParam(req, "permissions[execute]"));
        boolean schedule = Boolean.parseBoolean(this.getParam(req, "permissions[schedule]"));
        Permission perm = new Permission();
        if (admin) {
            perm.setPermission(Permission.Type.ADMIN, true);
        } else {
            perm.setPermission(Permission.Type.READ, read);
            perm.setPermission(Permission.Type.WRITE, write);
            perm.setPermission(Permission.Type.EXECUTE, execute);
            perm.setPermission(Permission.Type.SCHEDULE, schedule);
        }
        try {
            this.projectManager.updateProjectPermission(project, name, perm, group, user);
        }
        catch (ProjectManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxChangePermissions(Project project, HashMap<String, Object> ret, HttpServletRequest req, User user) throws ServletException {
        boolean admin = Boolean.parseBoolean(this.getParam(req, "permissions[admin]"));
        boolean read = Boolean.parseBoolean(this.getParam(req, "permissions[read]"));
        boolean write = Boolean.parseBoolean(this.getParam(req, "permissions[write]"));
        boolean execute = Boolean.parseBoolean(this.getParam(req, "permissions[execute]"));
        boolean schedule = Boolean.parseBoolean(this.getParam(req, "permissions[schedule]"));
        boolean group = Boolean.parseBoolean(this.getParam(req, "group"));
        String name = this.getParam(req, "name");
        Permission perm = group ? project.getGroupPermission(name) : project.getUserPermission(name);
        if (perm == null) {
            ret.put("error", "Permissions for " + name + " cannot be found.");
            return;
        }
        if (admin || read || write || execute || schedule) {
            if (admin) {
                perm.setPermission(Permission.Type.ADMIN, true);
                perm.setPermission(Permission.Type.READ, false);
                perm.setPermission(Permission.Type.WRITE, false);
                perm.setPermission(Permission.Type.EXECUTE, false);
                perm.setPermission(Permission.Type.SCHEDULE, false);
            } else {
                perm.setPermission(Permission.Type.ADMIN, false);
                perm.setPermission(Permission.Type.READ, read);
                perm.setPermission(Permission.Type.WRITE, write);
                perm.setPermission(Permission.Type.EXECUTE, execute);
                perm.setPermission(Permission.Type.SCHEDULE, schedule);
            }
            try {
                this.projectManager.updateProjectPermission(project, name, perm, group, user);
            }
            catch (ProjectManagerException e) {
                ret.put("error", e.getMessage());
            }
        } else {
            try {
                this.projectManager.removeProjectPermission(project, name, group, user);
            }
            catch (ProjectManagerException e) {
                ret.put("error", e.getMessage());
            }
        }
    }

    private void ajaxGetPermissions(Project project, HashMap<String, Object> ret) {
        ArrayList permissions = new ArrayList();
        for (Pair<String, Permission> perm : project.getUserPermissions()) {
            HashMap<String, Object> permObj = new HashMap<String, Object>();
            String userId = perm.getFirst();
            permObj.put("username", userId);
            permObj.put("permission", perm.getSecond().toStringArray());
            permissions.add(permObj);
        }
        ret.put("permissions", permissions);
    }

    private void handleProjectLogsPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/projectlogpage.vm");
        String projectName = this.getParam(req, "project");
        User user = session.getUser();
        Project project = null;
        try {
            project = this.projectManager.getProject(projectName);
            if (project == null) {
                page.add("errorMsg", "Project " + projectName + " doesn't exist.");
            } else {
                if (!this.hasPermission(project, user, Permission.Type.READ)) {
                    throw new AccessControlException("No permission to view project " + projectName + ".");
                }
                page.add("project", project);
                page.add("admins", Utils.flattenToString(project.getUsersWithPermission(Permission.Type.ADMIN), ","));
                Permission perm = this.getPermissionObject(project, user, Permission.Type.ADMIN);
                page.add("userpermission", perm);
                boolean adminPerm = perm.isPermissionSet(Permission.Type.ADMIN);
                if (adminPerm) {
                    page.add("admin", true);
                }
                if (perm.isPermissionSet(Permission.Type.EXECUTE) || adminPerm) {
                    page.add("exec", true);
                } else {
                    page.add("exec", false);
                }
            }
        }
        catch (AccessControlException e) {
            page.add("errorMsg", e.getMessage());
        }
        int numBytes = 1024;
        StringBuffer buffer = new StringBuffer(numBytes);
        page.add("log", buffer.toString());
        page.render();
    }

    private void handleJobHistoryPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/jobhistorypage.vm");
        String projectName = this.getParam(req, "project");
        User user = session.getUser();
        Project project = this.projectManager.getProject(projectName);
        if (project == null) {
            page.add("errorMsg", "Project " + projectName + " doesn't exist.");
            page.render();
            return;
        }
        if (!this.hasPermission(project, user, Permission.Type.READ)) {
            page.add("errorMsg", "No permission to view project " + projectName + ".");
            page.render();
            return;
        }
        String jobId = this.getParam(req, "job");
        int pageNum = this.getIntParam(req, "page", 1);
        int pageSize = this.getIntParam(req, "size", 25);
        page.add("projectId", project.getId());
        page.add("projectName", project.getName());
        page.add("jobid", jobId);
        page.add("page", pageNum);
        int skipPage = (pageNum - 1) * pageSize;
        int numResults = 0;
        try {
            numResults = this.executorManager.getNumberOfJobExecutions(project, jobId);
            int maxPage = numResults / pageSize + 1;
            List<ExecutableJobInfo> jobInfo = this.executorManager.getExecutableJobs(project, jobId, skipPage, pageSize);
            if (jobInfo == null || jobInfo.isEmpty()) {
                jobInfo = null;
            }
            page.add("history", jobInfo);
            page.add("previous", new PageSelection("Previous", pageSize, true, false, Math.max(pageNum - 1, 1)));
            page.add("next", new PageSelection("Next", pageSize, false, false, Math.min(pageNum + 1, maxPage)));
            if (jobInfo != null) {
                ArrayList<Map<String, Object>> dataSeries = new ArrayList<Map<String, Object>>();
                for (ExecutableJobInfo info : jobInfo) {
                    Map<String, Object> map = info.toObject();
                    dataSeries.add(map);
                }
                page.add("dataSeries", JSONUtils.toJSON(dataSeries));
            } else {
                page.add("dataSeries", "[]");
            }
        }
        catch (ExecutorManagerException e) {
            page.add("errorMsg", e.getMessage());
        }
        int pageStartValue = 1;
        if (pageNum > 3) {
            pageStartValue = pageNum - 2;
        }
        int maxPage = numResults / pageSize + 1;
        page.add("page1", new PageSelection(String.valueOf(pageStartValue), pageSize, pageStartValue > maxPage, pageStartValue == pageNum, Math.min(pageStartValue, maxPage)));
        page.add("page2", new PageSelection(String.valueOf(++pageStartValue), pageSize, pageStartValue > maxPage, pageStartValue == pageNum, Math.min(pageStartValue, maxPage)));
        page.add("page3", new PageSelection(String.valueOf(++pageStartValue), pageSize, pageStartValue > maxPage, pageStartValue == pageNum, Math.min(pageStartValue, maxPage)));
        page.add("page4", new PageSelection(String.valueOf(++pageStartValue), pageSize, pageStartValue > maxPage, pageStartValue == pageNum, Math.min(pageStartValue, maxPage)));
        page.add("page5", new PageSelection(String.valueOf(++pageStartValue), pageSize, pageStartValue > maxPage, pageStartValue == pageNum, Math.min(pageStartValue, maxPage)));
        page.render();
    }

    private void handlePermissionPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/permissionspage.vm");
        String projectName = this.getParam(req, "project");
        User user = session.getUser();
        Project project = null;
        try {
            project = this.projectManager.getProject(projectName);
            if (project == null) {
                page.add("errorMsg", "Project " + projectName + " not found.");
            } else {
                Set<String> proxyUsers;
                List<Pair<String, Permission>> groupPermission;
                List<Pair<String, Permission>> userPermission;
                if (!this.hasPermission(project, user, Permission.Type.READ)) {
                    throw new AccessControlException("No permission to view project " + projectName + ".");
                }
                page.add("project", project);
                page.add("username", user.getUserId());
                page.add("admins", Utils.flattenToString(project.getUsersWithPermission(Permission.Type.ADMIN), ","));
                Permission perm = this.getPermissionObject(project, user, Permission.Type.ADMIN);
                page.add("userpermission", perm);
                if (perm.isPermissionSet(Permission.Type.ADMIN)) {
                    page.add("admin", true);
                }
                if ((userPermission = project.getUserPermissions()) != null && !userPermission.isEmpty()) {
                    page.add("permissions", userPermission);
                }
                if ((groupPermission = project.getGroupPermissions()) != null && !groupPermission.isEmpty()) {
                    page.add("groupPermissions", groupPermission);
                }
                if ((proxyUsers = project.getProxyUsers()) != null && !proxyUsers.isEmpty()) {
                    page.add("proxyUsers", proxyUsers);
                }
                if (this.hasPermission(project, user, Permission.Type.ADMIN)) {
                    page.add("isAdmin", true);
                }
            }
        }
        catch (AccessControlException e) {
            page.add("errorMsg", e.getMessage());
        }
        page.render();
    }

    private void handleJobPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/jobpage.vm");
        String projectName = this.getParam(req, "project");
        String flowName = this.getParam(req, "flow");
        String jobName = this.getParam(req, "job");
        User user = session.getUser();
        Project project = null;
        Flow flow = null;
        try {
            project = this.projectManager.getProject(projectName);
            if (project == null) {
                page.add("errorMsg", "Project " + projectName + " not found.");
                page.render();
                return;
            }
            if (!this.hasPermission(project, user, Permission.Type.READ)) {
                throw new AccessControlException("No permission to view project " + projectName + ".");
            }
            page.add("project", project);
            flow = project.getFlow(flowName);
            if (flow == null) {
                page.add("errorMsg", "Flow " + flowName + " not found.");
                page.render();
                return;
            }
            page.add("flowid", flow.getId());
            Node node = flow.getNode(jobName);
            if (node == null) {
                page.add("errorMsg", "Job " + jobName + " not found.");
                page.render();
                return;
            }
            Props prop = this.projectManager.getProperties(project, node.getJobSource());
            Props overrideProp = this.projectManager.getJobOverrideProperty(project, jobName);
            if (overrideProp == null) {
                overrideProp = new Props();
            }
            Props comboProp = new Props(prop);
            for (String key : overrideProp.getKeySet()) {
                comboProp.put(key, overrideProp.get(key));
            }
            page.add("jobid", node.getId());
            page.add("jobtype", node.getType());
            ArrayList<String> dependencies = new ArrayList<String>();
            Set<Edge> inEdges = flow.getInEdges(node.getId());
            if (inEdges != null) {
                for (Edge dependency : inEdges) {
                    dependencies.add(dependency.getSourceId());
                }
            }
            if (!dependencies.isEmpty()) {
                page.add("dependencies", dependencies);
            }
            ArrayList<String> dependents = new ArrayList<String>();
            Set<Edge> outEdges = flow.getOutEdges(node.getId());
            if (outEdges != null) {
                for (Edge dependent : outEdges) {
                    dependents.add(dependent.getTargetId());
                }
            }
            if (!dependents.isEmpty()) {
                page.add("dependents", dependents);
            }
            ArrayList<String> source = new ArrayList<String>();
            String nodeSource = node.getPropsSource();
            if (nodeSource != null) {
                source.add(nodeSource);
                FlowProps parent = flow.getFlowProps(nodeSource);
                while (parent.getInheritedSource() != null) {
                    source.add(parent.getInheritedSource());
                    parent = flow.getFlowProps(parent.getInheritedSource());
                }
            }
            if (!source.isEmpty()) {
                page.add("properties", source);
            }
            ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
            for (String key : comboProp.getKeySet()) {
                String value = comboProp.get(key);
                parameters.add(new Pair<String, String>(key, value));
            }
            page.add("parameters", parameters);
        }
        catch (AccessControlException e) {
            page.add("errorMsg", e.getMessage());
        }
        catch (ProjectManagerException e) {
            page.add("errorMsg", e.getMessage());
        }
        page.render();
    }

    private void handlePropertyPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/propertypage.vm");
        String projectName = this.getParam(req, "project");
        String flowName = this.getParam(req, "flow");
        String jobName = this.getParam(req, "job");
        String propSource = this.getParam(req, "prop");
        User user = session.getUser();
        Project project = null;
        Flow flow = null;
        try {
            project = this.projectManager.getProject(projectName);
            if (project == null) {
                page.add("errorMsg", "Project " + projectName + " not found.");
                page.render();
                return;
            }
            if (!this.hasPermission(project, user, Permission.Type.READ)) {
                throw new AccessControlException("No permission to view project " + projectName + ".");
            }
            page.add("project", project);
            flow = project.getFlow(flowName);
            if (flow == null) {
                page.add("errorMsg", "Flow " + flowName + " not found.");
                page.render();
                return;
            }
            page.add("flowid", flow.getId());
            Node node = flow.getNode(jobName);
            if (node == null) {
                page.add("errorMsg", "Job " + jobName + " not found.");
                page.render();
                return;
            }
            Props prop = this.projectManager.getProperties(project, propSource);
            page.add("property", propSource);
            page.add("jobid", node.getId());
            ArrayList<String> inheritProps = new ArrayList<String>();
            FlowProps parent = flow.getFlowProps(propSource);
            while (parent.getInheritedSource() != null) {
                inheritProps.add(parent.getInheritedSource());
                parent = flow.getFlowProps(parent.getInheritedSource());
            }
            if (!inheritProps.isEmpty()) {
                page.add("inheritedproperties", inheritProps);
            }
            ArrayList<String> dependingProps = new ArrayList<String>();
            FlowProps child = flow.getFlowProps(flow.getNode(jobName).getPropsSource());
            while (!child.getSource().equals(propSource)) {
                dependingProps.add(child.getSource());
                child = flow.getFlowProps(child.getInheritedSource());
            }
            if (!dependingProps.isEmpty()) {
                page.add("dependingproperties", dependingProps);
            }
            ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
            for (String key : prop.getKeySet()) {
                String value = prop.get(key);
                parameters.add(new Pair<String, String>(key, value));
            }
            page.add("parameters", parameters);
        }
        catch (AccessControlException e) {
            page.add("errorMsg", e.getMessage());
        }
        catch (ProjectManagerException e) {
            page.add("errorMsg", e.getMessage());
        }
        page.render();
    }

    private void handleFlowPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/flowpage.vm");
        String projectName = this.getParam(req, "project");
        String flowName = this.getParam(req, "flow");
        User user = session.getUser();
        Project project = null;
        Flow flow = null;
        try {
            project = this.projectManager.getProject(projectName);
            if (project == null) {
                page.add("errorMsg", "Project " + projectName + " not found.");
                page.render();
                return;
            }
            if (!this.hasPermission(project, user, Permission.Type.READ)) {
                throw new AccessControlException("No permission Project " + projectName + ".");
            }
            page.add("project", project);
            flow = project.getFlow(flowName);
            if (flow == null) {
                page.add("errorMsg", "Flow " + flowName + " not found.");
            }
            page.add("flowid", flow.getId());
        }
        catch (AccessControlException e) {
            page.add("errorMsg", e.getMessage());
        }
        page.render();
    }

    private void handleProjectPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/projectpage.vm");
        String projectName = this.getParam(req, "project");
        User user = session.getUser();
        Project project = null;
        try {
            project = this.projectManager.getProject(projectName);
            if (project == null) {
                page.add("errorMsg", "Project " + projectName + " not found.");
            } else {
                if (!this.hasPermission(project, user, Permission.Type.READ)) {
                    throw new AccessControlException("No permission to view project " + projectName + ".");
                }
                page.add("project", project);
                page.add("admins", Utils.flattenToString(project.getUsersWithPermission(Permission.Type.ADMIN), ","));
                Permission perm = this.getPermissionObject(project, user, Permission.Type.ADMIN);
                page.add("userpermission", perm);
                boolean adminPerm = perm.isPermissionSet(Permission.Type.ADMIN);
                if (adminPerm) {
                    page.add("admin", true);
                }
                if (perm.isPermissionSet(Permission.Type.EXECUTE) || adminPerm) {
                    page.add("exec", true);
                } else {
                    page.add("exec", false);
                }
                List<Flow> flows = project.getFlows();
                if (!flows.isEmpty()) {
                    Collections.sort(flows, FLOW_ID_COMPARATOR);
                    page.add("flows", flows);
                }
            }
        }
        catch (AccessControlException e) {
            page.add("errorMsg", e.getMessage());
        }
        page.render();
    }

    private void handleCreate(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException {
        String projectName = this.hasParam(req, "name") ? this.getParam(req, "name") : null;
        String projectDescription = this.hasParam(req, "description") ? this.getParam(req, "description") : null;
        logger.info((Object)("Create project " + projectName));
        User user = session.getUser();
        String status = null;
        String action = null;
        String message = null;
        HashMap<String, String> params = null;
        if (this.lockdownCreateProjects && !this.hasPermissionToCreateProject(user)) {
            message = "User " + user.getUserId() + " doesn't have permission to create projects.";
            logger.info((Object)message);
            status = "error";
        } else {
            try {
                this.projectManager.createProject(projectName, projectDescription, user);
                status = "success";
                action = "redirect";
                String redirect = "manager?project=" + projectName;
                params = new HashMap<String, String>();
                params.put("path", redirect);
            }
            catch (ProjectManagerException e) {
                message = e.getMessage();
                status = "error";
            }
        }
        String response = ProjectManagerServlet.createJsonResponse(status, message, action, params);
        try {
            PrintWriter write = resp.getWriter();
            ((Writer)write).append(response);
            ((Writer)write).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ajaxHandleUpload(HttpServletRequest req, Map<String, String> ret, Map<String, Object> multipart, Session session) throws ServletException, IOException {
        User user = session.getUser();
        String projectName = (String)multipart.get("project");
        Project project = this.projectManager.getProject(projectName);
        if (projectName == null || projectName.isEmpty()) {
            ret.put("error", "No project name found.");
        } else if (project == null) {
            ret.put("error", "Installation Failed. Project '" + projectName + "' doesn't exist.");
        } else if (!this.hasPermission(project, user, Permission.Type.WRITE)) {
            ret.put("error", "Installation Failed. User '" + user.getUserId() + "' does not have write access.");
        } else {
            ret.put("projectId", String.valueOf(project.getId()));
            FileItem item = (FileItem)multipart.get("file");
            String name = item.getName();
            String type = null;
            String contentType = item.getContentType();
            if (contentType == null || !contentType.startsWith("application/zip") && !contentType.startsWith("application/x-zip-compressed") && !contentType.startsWith("application/octet-stream")) {
                item.delete();
                ret.put("error", "File type " + contentType + " unrecognized.");
                return;
            }
            type = "zip";
            File tempDir = Utils.createTempDir();
            OutputStream out = null;
            try {
                logger.info((Object)("Uploading file " + name));
                File archiveFile = new File(tempDir, name);
                out = new BufferedOutputStream(new FileOutputStream(archiveFile));
                IOUtils.copy((InputStream)item.getInputStream(), (OutputStream)out);
                out.close();
                this.projectManager.uploadProject(project, archiveFile, type, user);
            }
            catch (Exception e) {
                logger.info((Object)"Installation Failed.", (Throwable)e);
                String error = e.getMessage();
                if (error.length() > 512) {
                    error = error.substring(0, 512) + "\nToo many errors to display.\n";
                }
                ret.put("error", "Installation Failed.\n" + error);
            }
            finally {
                if (tempDir.exists()) {
                    FileUtils.deleteDirectory((File)tempDir);
                }
                if (out != null) {
                    out.close();
                }
            }
            ret.put("version", String.valueOf(project.getVersion()));
        }
    }

    private void handleUpload(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> multipart, Session session) throws ServletException, IOException {
        HashMap<String, String> ret = new HashMap<String, String>();
        String projectName = (String)multipart.get("project");
        this.ajaxHandleUpload(req, ret, multipart, session);
        if (ret.containsKey("error")) {
            this.setErrorMessageInCookie(resp, ret.get("error"));
        }
        resp.sendRedirect(req.getRequestURI() + "?project=" + projectName);
    }

    private Permission getPermissionObject(Project project, User user, Permission.Type type) {
        Permission perm = project.getCollectivePermission(user);
        for (String roleName : user.getRoles()) {
            Role role = this.userManager.getRole(roleName);
            perm.addPermissions(role.getPermission());
        }
        return perm;
    }

    private boolean hasPermissionToCreateProject(User user) {
        for (String roleName : user.getRoles()) {
            Role role = this.userManager.getRole(roleName);
            Permission perm = role.getPermission();
            if (!perm.isPermissionSet(Permission.Type.ADMIN) && !perm.isPermissionSet(Permission.Type.CREATEPROJECTS)) continue;
            return true;
        }
        return false;
    }

    public class PageSelection {
        private String page;
        private int size;
        private boolean disabled;
        private boolean selected;
        private int nextPage;

        public PageSelection(String pageName, int size, boolean disabled, boolean selected, int nextPage) {
            this.page = pageName;
            this.size = size;
            this.disabled = disabled;
            this.setSelected(selected);
            this.nextPage = nextPage;
        }

        public String getPage() {
            return this.page;
        }

        public int getSize() {
            return this.size;
        }

        public boolean getDisabled() {
            return this.disabled;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public int getNextPage() {
            return this.nextPage;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    private static class NodeLevelComparator
    implements Comparator<Node> {
        private NodeLevelComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            return node1.getLevel() - node2.getLevel();
        }
    }
}

