/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.limiter.broker;

import com.typesafe.config.Config;
import java.util.Collection;
import org.apache.gobblin.broker.ResourceCoordinate;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.NoSuchScopeException;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.ScopedConfigView;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceFactoryResponse;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.LimiterFactory;
import org.apache.gobblin.util.limiter.MultiLimiter;
import org.apache.gobblin.util.limiter.NoopLimiter;
import org.apache.gobblin.util.limiter.broker.SharedLimiterKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedLimiterFactory<S extends ScopeType<S>>
implements SharedResourceFactory<Limiter, SharedLimiterKey, S> {
    private static final Logger log = LoggerFactory.getLogger(SharedLimiterFactory.class);
    public static final String NAME = "limiter";
    public static final String LIMITER_CLASS_KEY = "class";
    public static final String FAIL_IF_NO_GLOBAL_LIMITER_KEY = "failIfNoGlobalLimiter";
    public static final String SKIP_GLOBAL_LIMITER_KEY = "skipGlobalLimiter";
    public static final String FAIL_ON_UNKNOWN_RESOURCE_ID = "faiOnUnknownResourceId";
    private static final ClassAliasResolver<LimiterFactory> RESOLVER = new ClassAliasResolver(LimiterFactory.class);

    public String getName() {
        return NAME;
    }

    public SharedResourceFactoryResponse<Limiter> createResource(SharedResourcesBroker<S> broker, ScopedConfigView<S, SharedLimiterKey> configView) throws NotConfiguredException {
        Limiter limiter;
        Config config;
        block16: {
            config = configView.getConfig();
            SharedLimiterKey.GlobalLimiterPolicy globalLimiterPolicy = ((SharedLimiterKey)configView.getKey()).getGlobalLimiterPolicy();
            if (ConfigUtils.getBoolean(config, SKIP_GLOBAL_LIMITER_KEY, false)) {
                if (globalLimiterPolicy != SharedLimiterKey.GlobalLimiterPolicy.LOCAL_ONLY) {
                    SharedLimiterKey modifiedKey = new SharedLimiterKey(((SharedLimiterKey)configView.getKey()).getResourceLimitedPath(), SharedLimiterKey.GlobalLimiterPolicy.LOCAL_ONLY);
                    return new ResourceCoordinate((SharedResourceFactory)this, (SharedResourceKey)modifiedKey, configView.getScope());
                }
            } else if (config.hasPath(FAIL_IF_NO_GLOBAL_LIMITER_KEY) && config.getBoolean(FAIL_IF_NO_GLOBAL_LIMITER_KEY) && globalLimiterPolicy != SharedLimiterKey.GlobalLimiterPolicy.USE_GLOBAL) {
                SharedLimiterKey modifiedKey = new SharedLimiterKey(((SharedLimiterKey)configView.getKey()).getResourceLimitedPath(), SharedLimiterKey.GlobalLimiterPolicy.USE_GLOBAL);
                return new ResourceCoordinate((SharedResourceFactory)this, (SharedResourceKey)modifiedKey, configView.getScope());
            }
            if (!configView.getScope().isLocal() && !globalLimiterPolicy.equals((Object)SharedLimiterKey.GlobalLimiterPolicy.LOCAL_ONLY)) {
                try {
                    Class<?> klazz = Class.forName("org.apache.gobblin.util.limiter.RestliLimiterFactory");
                    return new ResourceCoordinate((SharedResourceFactory)klazz.newInstance(), configView.getKey(), configView.getScope());
                }
                catch (ReflectiveOperationException roe) {
                    if (!globalLimiterPolicy.equals((Object)SharedLimiterKey.GlobalLimiterPolicy.USE_GLOBAL)) break block16;
                    throw new RuntimeException("There is no Global limiter factory in the classpath.");
                }
            }
        }
        if (config.hasPath(LIMITER_CLASS_KEY)) {
            try {
                LimiterFactory factory = (LimiterFactory)RESOLVER.resolveClass(config.getString(LIMITER_CLASS_KEY)).newInstance();
                limiter = factory.buildLimiter(config);
            }
            catch (ReflectiveOperationException roe) {
                throw new RuntimeException(roe);
            }
        } else {
            if (config.hasPath(FAIL_ON_UNKNOWN_RESOURCE_ID) && config.getBoolean(FAIL_ON_UNKNOWN_RESOURCE_ID)) {
                throw new NotConfiguredException();
            }
            limiter = new NoopLimiter();
        }
        ScopeType scope = configView.getScope();
        Collection parentScopes = scope.parentScopes();
        if (parentScopes != null) {
            try {
                for (ScopeType parentScope : parentScopes) {
                    limiter = new MultiLimiter(limiter, (Limiter)broker.getSharedResourceAtScope((SharedResourceFactory)this, configView.getKey(), parentScope));
                }
            }
            catch (NoSuchScopeException nsse) {
                throw new RuntimeException("Could not get higher scope limiter. This is an error in code.", nsse);
            }
        }
        return new ResourceInstance<NoopLimiter>((NoopLimiter)limiter);
    }

    public S getAutoScope(SharedResourcesBroker<S> broker, ConfigView<S, SharedLimiterKey> config) {
        return (S)broker.selfScope().getType();
    }
}

