/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.dataset;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.StateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetUtils.class);
    public static final String DATASET = "dataset";
    public static final String DATASET_SPECIFIC_PROPS = "dataset.specific.props";
    private static final String KAFKA_TOPIC_SPECIFIC_STATE = "kafka.topic.specific.state";

    private DatasetUtils() {
    }

    public static Map<String, State> getDatasetSpecificProps(Iterable<String> datasets, State state) {
        if (!Strings.isNullOrEmpty((String)state.getProp(DATASET_SPECIFIC_PROPS)) || !Strings.isNullOrEmpty((String)state.getProp(KAFKA_TOPIC_SPECIFIC_STATE))) {
            HashMap datasetSpecificConfigMap = Maps.newHashMap();
            JsonArray array = !Strings.isNullOrEmpty((String)state.getProp(DATASET_SPECIFIC_PROPS)) ? state.getPropAsJsonArray(DATASET_SPECIFIC_PROPS) : state.getPropAsJsonArray(KAFKA_TOPIC_SPECIFIC_STATE);
            for (JsonElement datasetElement : array) {
                Preconditions.checkArgument((boolean)datasetElement.isJsonObject(), (Object)"The value for property dataset.specific.props is malformed");
                JsonObject object = datasetElement.getAsJsonObject();
                if (object.has(DATASET)) {
                    JsonElement datasetNameElement = object.get(DATASET);
                    Preconditions.checkArgument((boolean)datasetNameElement.isJsonPrimitive(), (Object)"The value for property dataset.specific.props is malformed, the dataset field must be a string");
                    for (String dataset : Iterables.filter(datasets, (Predicate)new DatasetPredicate(datasetNameElement.getAsString()))) {
                        if (datasetSpecificConfigMap.containsKey(dataset)) {
                            ((State)datasetSpecificConfigMap.get(dataset)).addAll(StateUtils.jsonObjectToState((JsonObject)object, (String[])new String[]{DATASET}));
                            continue;
                        }
                        datasetSpecificConfigMap.put(dataset, StateUtils.jsonObjectToState((JsonObject)object, (String[])new String[]{DATASET}));
                    }
                    continue;
                }
                LOG.warn("Skipping JsonElement " + datasetElement + " as it is does not contain a field with key " + DATASET);
            }
            return datasetSpecificConfigMap;
        }
        return Maps.newHashMap();
    }

    private static class DatasetPredicate
    implements Predicate<String> {
        private final Pattern datasetPattern;

        private DatasetPredicate(String datasetRegex) {
            this.datasetPattern = Pattern.compile(datasetRegex, 2);
        }

        public boolean apply(String input) {
            return this.datasetPattern.matcher(input).matches();
        }
    }
}

