/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.chrono.ISOChronology;

public enum DatePartitionType {
    YEAR("yyyy", DateTimeFieldType.year()),
    MONTH("yyyy/MM", DateTimeFieldType.monthOfYear()),
    DAY("yyyy/MM/dd", DateTimeFieldType.dayOfMonth()),
    HOUR("yyyy/MM/dd/HH", DateTimeFieldType.hourOfDay()),
    MINUTE("yyyy/MM/dd/HH/mm", DateTimeFieldType.minuteOfHour());

    private static final Map<String, DateTimeFieldType> lookupByPattern;
    private DateTimeFieldType dateTimeField;
    private String dateTimePattern;

    private DatePartitionType(String dateTimePattern, DateTimeFieldType dateTimeField) {
        this.dateTimeField = dateTimeField;
        this.dateTimePattern = dateTimePattern;
    }

    public static DateTimeFieldType getLowestIntervalUnit(String pattern) {
        DateTimeFieldType intervalUnit = null;
        for (Map.Entry<String, DateTimeFieldType> pat : lookupByPattern.entrySet()) {
            if (!pattern.contains(pat.getKey())) continue;
            intervalUnit = pat.getValue();
            break;
        }
        return intervalUnit;
    }

    public long getUnitMilliseconds() {
        return this.dateTimeField.getDurationType().getField((Chronology)ISOChronology.getInstance()).getUnitMillis();
    }

    public DateTimeFieldType getDateTimeFieldType() {
        return this.dateTimeField;
    }

    public int getField(DateTime dateTime) {
        return dateTime.get(this.dateTimeField);
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    static {
        lookupByPattern = new LinkedHashMap<String, DateTimeFieldType>();
        lookupByPattern.put("s", DateTimeFieldType.secondOfMinute());
        lookupByPattern.put("m", DateTimeFieldType.minuteOfHour());
        lookupByPattern.put("h", DateTimeFieldType.hourOfDay());
        lookupByPattern.put("H", DateTimeFieldType.hourOfDay());
        lookupByPattern.put("K", DateTimeFieldType.hourOfDay());
        lookupByPattern.put("d", DateTimeFieldType.dayOfMonth());
        lookupByPattern.put("D", DateTimeFieldType.dayOfMonth());
        lookupByPattern.put("e", DateTimeFieldType.dayOfMonth());
        lookupByPattern.put("w", DateTimeFieldType.weekOfWeekyear());
        lookupByPattern.put("M", DateTimeFieldType.monthOfYear());
        lookupByPattern.put("y", DateTimeFieldType.year());
        lookupByPattern.put("Y", DateTimeFieldType.year());
    }
}

