/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.JobConfigurationManager;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.MutableJobCatalog;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecConsumer;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class StreamingJobConfigurationManager
extends JobConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingJobConfigurationManager.class);
    private final ExecutorService fetchJobSpecExecutor;
    private final SpecConsumer specConsumer;
    private final long stopTimeoutSeconds;

    public StreamingJobConfigurationManager(EventBus eventBus, Config config, MutableJobCatalog jobCatalog) {
        super(eventBus, config);
        this.stopTimeoutSeconds = ConfigUtils.getLong((Config)config, (String)"gobblin.cluster.stopTimeoutSeconds", (Long)60L);
        this.fetchJobSpecExecutor = Executors.newSingleThreadExecutor(ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOGGER), (Optional)Optional.of((Object)"FetchJobSpecExecutor")));
        String specExecutorInstanceConsumerClassName = ConfigUtils.getString((Config)config, (String)"gobblin.cluster.specConsumer.class", (String)"org.apache.gobblin.service.StreamingKafkaSpecConsumer");
        LOGGER.info("Using SpecConsumer ClassNameclass name/alias " + specExecutorInstanceConsumerClassName);
        try {
            ClassAliasResolver aliasResolver = new ClassAliasResolver(SpecConsumer.class);
            this.specConsumer = (SpecConsumer)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(aliasResolver.resolve(specExecutorInstanceConsumerClassName)), (List[])new List[]{ImmutableList.of((Object)config, (Object)jobCatalog), ImmutableList.of((Object)config)});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not construct SpecConsumer " + specExecutorInstanceConsumerClassName, e);
        }
    }

    @Override
    protected void startUp() throws Exception {
        LOGGER.info("Starting the " + StreamingJobConfigurationManager.class.getSimpleName());
        this.fetchJobSpecExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        StreamingJobConfigurationManager.this.fetchJobSpecs();
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.info("Fetch thread interrupted... will exit");
                }
                catch (ExecutionException e) {
                    LOGGER.error("Failed to fetch job specs", (Throwable)e);
                    throw new RuntimeException("Failed to fetch specs", e);
                }
            }
        });
        if (this.specConsumer instanceof Service) {
            ((Service)this.specConsumer).startAsync().awaitRunning();
        }
    }

    private void fetchJobSpecs() throws ExecutionException, InterruptedException {
        List changesSpecs = (List)this.specConsumer.changedSpecs().get();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        for (Pair entry : changesSpecs) {
            JobSpec jobSpec;
            SpecExecutor.Verb verb = (SpecExecutor.Verb)entry.getKey();
            if (verb.equals((Object)SpecExecutor.Verb.ADD)) {
                jobSpec = (JobSpec)entry.getValue();
                this.postNewJobConfigArrival(jobSpec.getUri().toString(), jobSpec.getConfigAsProperties());
                continue;
            }
            if (verb.equals((Object)SpecExecutor.Verb.UPDATE)) {
                jobSpec = (JobSpec)entry.getValue();
                this.postUpdateJobConfigArrival(jobSpec.getUri().toString(), jobSpec.getConfigAsProperties());
                continue;
            }
            if (!verb.equals((Object)SpecExecutor.Verb.DELETE)) continue;
            Spec anonymousSpec = (Spec)entry.getValue();
            this.postDeleteJobConfigArrival(anonymousSpec.getUri().toString(), new Properties());
        }
    }

    @Override
    protected void shutDown() throws Exception {
        if (this.specConsumer instanceof Service) {
            ((Service)this.specConsumer).stopAsync().awaitTerminated(this.stopTimeoutSeconds, TimeUnit.SECONDS);
        }
        ExecutorsUtils.shutdownExecutorService((ExecutorService)this.fetchJobSpecExecutor, (Optional)Optional.of((Object)LOGGER));
    }

    public SpecConsumer getSpecConsumer() {
        return this.specConsumer;
    }
}

