/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.disruptor;

import com.linkedin.r2.disruptor.DisruptContext;
import com.linkedin.r2.disruptor.DisruptMode;

public class DisruptContexts {
    public static DisruptContext delay(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Delay cannot be smaller than 0");
        }
        return new DelayDisruptContext(delay);
    }

    public static DisruptContext timeout() {
        return new TimeoutDisruptContext();
    }

    public static DisruptContext error(long latency) {
        if (latency < 0L) {
            throw new IllegalArgumentException("Latency cannot be smaller than 0");
        }
        return new ErrorDisruptContext(latency);
    }

    static class ErrorDisruptContext
    extends DisruptContext {
        private final long _latency;

        public ErrorDisruptContext(long latency) {
            super(DisruptMode.ERROR);
            this._latency = latency;
        }

        public long latency() {
            return this._latency;
        }
    }

    static class TimeoutDisruptContext
    extends DisruptContext {
        public TimeoutDisruptContext() {
            super(DisruptMode.TIMEOUT);
        }
    }

    static class DelayDisruptContext
    extends DisruptContext {
        private final long _delay;

        public DelayDisruptContext(long delay) {
            this(DisruptMode.DELAY, delay);
        }

        public DelayDisruptContext(DisruptMode mode, long delay) {
            super(mode);
            this._delay = delay;
        }

        public long delay() {
            return this._delay;
        }
    }
}

